/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.components;

import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.components.DirectoryEntry;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;

class DirectoryRenderer
extends DefaultListCellRenderer {
    private static final Icon ICON_FOLDER_OPEN = GUIHelper.loadIcon("folder_open.png");
    private static final Icon ICON_FOLDER_CLOSED = GUIHelper.loadIcon("folder_closed.png");
    private static final int INDENT_SIZE = 6;

    DirectoryRenderer() {
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        if (object != null && object instanceof DirectoryEntry) {
            DirectoryEntry directoryEntry = (DirectoryEntry)object;
            if (directoryEntry.isOpen()) {
                this.setIcon(ICON_FOLDER_OPEN);
            } else {
                this.setIcon(ICON_FOLDER_CLOSED);
            }
            this.setBorder(BorderFactory.createEmptyBorder(0, 3 + directoryEntry.getIndent() * 6, 0, 0));
        }
        return this;
    }
}

