/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.cmd;

import java.io.IOException;
import org.jrobin.cmd.RrdToolCmd;
import org.jrobin.core.Archive;
import org.jrobin.core.Datasource;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdUpdater;

class RrdInfoCmd
extends RrdToolCmd {
    RrdInfoCmd() {
    }

    String getCmdType() {
        return "info";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object execute() throws RrdException, IOException {
        String string;
        String[] stringArray = this.getRemainingWords();
        if (stringArray.length != 2) {
            throw new RrdException("Invalid rrdinfo syntax");
        }
        String string2 = stringArray[1];
        RrdDb rrdDb = RrdInfoCmd.getRrdDbReference(string2);
        try {
            string = this.getInfo(rrdDb);
            RrdInfoCmd.println(string);
        }
        finally {
            RrdInfoCmd.releaseRrdDbReference(rrdDb);
        }
        return string;
    }

    private String getInfo(RrdDb rrdDb) throws IOException {
        RrdUpdater rrdUpdater;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("filename = \"").append(rrdDb.getPath()).append("\"\n");
        stringBuffer.append("rrd_version = \"0001\"\n");
        stringBuffer.append("step = ").append(rrdDb.getHeader().getStep()).append("\n");
        stringBuffer.append("last_update = ").append(rrdDb.getHeader().getLastUpdateTime()).append("\n");
        for (n = 0; n < rrdDb.getDsCount(); ++n) {
            rrdUpdater = rrdDb.getDatasource(n);
            stringBuffer.append("ds[").append(((Datasource)rrdUpdater).getDsName()).append("].type = \"").append(((Datasource)rrdUpdater).getDsType()).append("\"\n");
            stringBuffer.append("ds[").append(((Datasource)rrdUpdater).getDsName()).append("].minimal_heartbeat = ").append(((Datasource)rrdUpdater).getHeartbeat()).append("\n");
            stringBuffer.append("ds[").append(((Datasource)rrdUpdater).getDsName()).append("].min = ").append(((Datasource)rrdUpdater).getMinValue()).append("\n");
            stringBuffer.append("ds[").append(((Datasource)rrdUpdater).getDsName()).append("].max = ").append(((Datasource)rrdUpdater).getMaxValue()).append("\n");
            stringBuffer.append("ds[").append(((Datasource)rrdUpdater).getDsName()).append("].last_ds = ").append(((Datasource)rrdUpdater).getLastValue()).append("\n");
            stringBuffer.append("ds[").append(((Datasource)rrdUpdater).getDsName()).append("].value = ").append(((Datasource)rrdUpdater).getAccumValue()).append("\n");
            stringBuffer.append("ds[").append(((Datasource)rrdUpdater).getDsName()).append("].unknown_sec = ").append(((Datasource)rrdUpdater).getNanSeconds()).append("\n");
        }
        for (n = 0; n < rrdDb.getArcCount(); ++n) {
            rrdUpdater = rrdDb.getArchive(n);
            stringBuffer.append("rra[").append(n).append("].cf = \"").append(((Archive)rrdUpdater).getConsolFun()).append("\"\n");
            stringBuffer.append("rra[").append(n).append("].rows = ").append(((Archive)rrdUpdater).getRows()).append("\n");
            stringBuffer.append("rra[").append(n).append("].pdp_per_row = ").append(((Archive)rrdUpdater).getSteps()).append("\n");
            stringBuffer.append("rra[").append(n).append("].xff = ").append(((Archive)rrdUpdater).getXff()).append("\n");
            for (int i = 0; i < rrdDb.getDsCount(); ++i) {
                stringBuffer.append("rra[").append(n).append("].cdp_prep[").append(i).append("].value = ").append(((Archive)rrdUpdater).getArcState(i).getAccumValue()).append("\n");
                stringBuffer.append("rra[").append(n).append("].cdp_prep[").append(i).append("].unknown_datapoints = ").append(((Archive)rrdUpdater).getArcState(i).getNanSteps()).append("\n");
            }
        }
        return stringBuffer.toString();
    }
}

