/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;

public class RCData {
    public static final String DEFAULT_JDBC_DRIVER = "org.hsqldb.jdbcDriver";
    String id = null;
    String url = null;
    String username = null;
    String password = null;
    String driver = null;
    String charset = null;
    String truststore = null;

    public void report() {
        System.err.println("urlid: " + this.id + ", url: " + this.url + ", username: " + this.username + ", password: " + this.password);
    }

    public RCData(File file, String string) throws Exception {
        String string2;
        if (file == null) {
            throw new IllegalArgumentException("RC file name not specified");
        }
        if (!file.canRead()) {
            throw new IOException("Please set up authentication file '" + file + "'");
        }
        StringTokenizer stringTokenizer = null;
        boolean bl = false;
        int n = 0;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string2 = bufferedReader.readLine()) != null) {
            String string3;
            String string4;
            ++n;
            if ((string2 = string2.trim()).length() == 0 || string2.charAt(0) == '#') continue;
            stringTokenizer = new StringTokenizer(string2);
            if (stringTokenizer.countTokens() == 1) {
                string4 = stringTokenizer.nextToken();
                string3 = "";
            } else if (stringTokenizer.countTokens() > 1) {
                string4 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken("").trim();
            } else {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new Exception("Corrupt line " + n + " in '" + file + "':  " + string2);
            }
            if (string == null) {
                if (!string4.equals("urlid")) continue;
                System.out.println(string3);
                continue;
            }
            if (string4.equals("urlid")) {
                if (string3.equals(string)) {
                    if (this.id == null) {
                        this.id = string;
                        bl = true;
                        continue;
                    }
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw new Exception("Key '" + string + " redefined at" + " line " + n + " in '" + file);
                }
                bl = false;
                continue;
            }
            if (!bl) continue;
            if (string4.equals("url")) {
                this.url = string3;
                continue;
            }
            if (string4.equals("username")) {
                this.username = string3;
                continue;
            }
            if (string4.equals("driver")) {
                this.driver = string3;
                continue;
            }
            if (string4.equals("charset")) {
                this.charset = string3;
                continue;
            }
            if (string4.equals("truststore")) {
                this.truststore = string3;
                continue;
            }
            if (string4.equals("password")) {
                this.password = string3;
                continue;
            }
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new Exception("Bad line " + n + " in '" + file + "':  " + string2);
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (string == null) {
            return;
        }
        if (this.url == null || this.username == null || this.password == null) {
            throw new Exception("url or username or password not set for '" + string + "' in file '" + file + "'");
        }
    }

    public RCData(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws Exception {
        this.id = string;
        this.url = string2;
        this.username = string3;
        this.password = string4;
        this.driver = string5;
        this.charset = string6;
        this.truststore = string7;
        if (string == null || string2 == null || string3 == null || string4 == null) {
            throw new Exception("id, url, username, or password was not set");
        }
    }

    public Connection getConnection() throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        return this.getConnection(null, null, null);
    }

    public Connection getConnection(String string, String string2, String string3) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        Properties properties = System.getProperties();
        if (string == null) {
            String string4 = string = this.driver == null ? DEFAULT_JDBC_DRIVER : this.driver;
        }
        if (string2 == null && this.charset != null) {
            string2 = this.charset;
        }
        if (string3 == null && this.truststore != null) {
            string3 = this.truststore;
        }
        if (string2 == null) {
            properties.remove("sqlfile.charset");
        } else {
            properties.put("sqlfile.charset", string2);
        }
        if (string3 == null) {
            properties.remove("javax.net.ssl.trustStore");
        } else {
            properties.put("javax.net.ssl.trustStore", string3);
        }
        Class.forName(string).newInstance();
        return DriverManager.getConnection(this.url, this.username, this.password);
    }
}

