/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.dim;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.WritableByteChannel;
import net.kano.joscar.BinaryTools;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorOutputStream
extends OutputStream {
    @Nullable
    private final Selector selector;
    private final WritableByteChannel writable;
    private volatile int total = 0;

    private SelectorOutputStream(Channel chan) throws IOException {
        this((WritableByteChannel)chan, (SelectableChannel)chan);
    }

    public SelectorOutputStream(WritableByteChannel writable, SelectableChannel selectable) throws IOException {
        this.writable = writable;
        if (selectable != null) {
            this.selector = Selector.open();
            selectable.configureBlocking(false);
            selectable.register(this.selector, 4);
        } else {
            this.selector = null;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.write(BinaryTools.getUByte((int)b));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        ByteBuffer buf = ByteBuffer.wrap(b, off, len);
        while (buf.hasRemaining() && this.writable.isOpen() && (this.selector == null || this.selector.isOpen())) {
            if (this.selector != null) {
                this.selector.select(50L);
            }
            this.total += this.writable.write(buf);
        }
    }

    public int getTotalWritten() {
        return this.total;
    }

    @Override
    public void close() throws IOException {
        this.writable.close();
    }

    public static <C extends SelectableChannel> SelectorOutputStream getInstance(C chan) throws IOException {
        return new SelectorOutputStream(chan);
    }
}

