/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icq;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.kano.joscar.LEBinaryTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.icq.AbstractIcqCmd;
import net.kano.joscar.snaccmd.icq.AbstractInfoCmd;

public class MetaWorkInfoCmd
extends AbstractInfoCmd {
    private String workCity;
    private String workState;
    private String workPhone;
    private String workFax;
    private String workAddress;
    private String workZipCode;
    private int workCountryCode;
    private String workCompany;
    private String workDepartment;
    private String workPosition;
    private int workOccupationCode;
    private String workWebPage;

    protected MetaWorkInfoCmd(SnacPacket packet) {
        super(packet);
    }

    public MetaWorkInfoCmd(long uin, int id) {
        super(uin, AbstractIcqCmd.CMD_META_WORK_INFO_CMD, id);
    }

    protected void readInfo(InputStream is) throws IOException {
        String charset = "US-ASCII";
        this.workCity = LEBinaryTools.readUShortLengthString(is, charset);
        this.workState = LEBinaryTools.readUShortLengthString(is, charset);
        this.workPhone = LEBinaryTools.readUShortLengthString(is, charset);
        this.workFax = LEBinaryTools.readUShortLengthString(is, charset);
        this.workAddress = LEBinaryTools.readUShortLengthString(is, charset);
        this.workZipCode = LEBinaryTools.readUShortLengthString(is, charset);
        this.workCountryCode = LEBinaryTools.readUShort(is);
        this.workCompany = LEBinaryTools.readUShortLengthString(is, charset);
        this.workDepartment = LEBinaryTools.readUShortLengthString(is, charset);
        this.workPosition = LEBinaryTools.readUShortLengthString(is, charset);
        this.workOccupationCode = LEBinaryTools.readUShort(is);
        this.workWebPage = LEBinaryTools.readUShortLengthString(is, charset);
    }

    protected void writeInfo(OutputStream out) throws IOException {
        LEBinaryTools.writeUShortLengthString(out, this.workCity);
        LEBinaryTools.writeUShortLengthString(out, this.workState);
        LEBinaryTools.writeUShortLengthString(out, this.workPhone);
        LEBinaryTools.writeUShortLengthString(out, this.workFax);
        LEBinaryTools.writeUShortLengthString(out, this.workAddress);
        LEBinaryTools.writeUShortLengthString(out, this.workZipCode);
        LEBinaryTools.writeUShort(out, this.workCountryCode);
        LEBinaryTools.writeUShortLengthString(out, this.workCompany);
        LEBinaryTools.writeUShortLengthString(out, this.workDepartment);
        LEBinaryTools.writeUShortLengthString(out, this.workPosition);
        LEBinaryTools.writeUShort(out, this.workOccupationCode);
        LEBinaryTools.writeUShortLengthString(out, this.workWebPage);
    }

    public String getWorkCity() {
        return this.workCity;
    }

    public void setWorkCity(String workCity) {
        this.workCity = workCity;
    }

    public String getWorkState() {
        return this.workState;
    }

    public void setWorkState(String workState) {
        this.workState = workState;
    }

    public String getWorkPhone() {
        return this.workPhone;
    }

    public void setWorkPhone(String workPhone) {
        this.workPhone = workPhone;
    }

    public String getWorkFax() {
        return this.workFax;
    }

    public void setWorkFax(String workFax) {
        this.workFax = workFax;
    }

    public String getWorkAddress() {
        return this.workAddress;
    }

    public void setWorkAddress(String workAddress) {
        this.workAddress = workAddress;
    }

    public String getWorkZipCode() {
        return this.workZipCode;
    }

    public void setWorkZipCode(String workZipCode) {
        this.workZipCode = workZipCode;
    }

    public int getWorkCountryCode() {
        return this.workCountryCode;
    }

    public void setWorkCountryCode(int workCountryCode) {
        this.workCountryCode = workCountryCode;
    }

    public String getWorkCompany() {
        return this.workCompany;
    }

    public void setWorkCompany(String workCompany) {
        this.workCompany = workCompany;
    }

    public String getWorkDepartment() {
        return this.workDepartment;
    }

    public void setWorkDepartment(String workDepartment) {
        this.workDepartment = workDepartment;
    }

    public String getWorkPosition() {
        return this.workPosition;
    }

    public void setWorkPosition(String workPosition) {
        this.workPosition = workPosition;
    }

    public int getWorkOccupationCode() {
        return this.workOccupationCode;
    }

    public void setWorkOccupationCode(int workOccupationCode) {
        this.workOccupationCode = workOccupationCode;
    }

    public String getWorkWebPage() {
        return this.workWebPage;
    }

    public void setWorkWebPage(String workWebPage) {
        this.workWebPage = workWebPage;
    }

    public String toString() {
        return "MetaWorkInfoCmd: city=" + this.getWorkCity() + " state=" + this.getWorkState() + " phone=" + this.getWorkPhone() + " fax=" + this.getWorkFax() + " address=" + this.getWorkAddress() + " zipCode=" + this.getWorkZipCode() + " countryCode=" + this.getWorkCountryCode() + " company=" + this.getWorkCompany() + " department=" + this.getWorkDepartment() + " position=" + this.getWorkPosition() + " occupationCode=" + this.getWorkOccupationCode() + " webpage=" + this.getWorkWebPage() + " in: " + super.toString();
    }
}

