/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.screens;

import com.install4j.runtime.installer.config.ServiceConfig;
import com.install4j.runtime.installer.frontend.InstallerWizard;
import com.install4j.runtime.installer.frontend.screens.ServiceScreen;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.JCheckBox;

public class Win32ServiceScreen
extends ServiceScreen {
    public Win32ServiceScreen(InstallerWizard installerWizard) {
        super(installerWizard);
    }

    protected ServiceScreen.SingleServicePanel createSingleServicePanel(ServiceConfig serviceConfig) {
        return new Win32SingleServicePanel(serviceConfig);
    }

    protected String getTitle() {
        return this.messages.getString("WindowsServicesTitle");
    }

    protected String getSubTitle() {
        return this.messages.getString("WindowsServicesSubtitle");
    }

    protected class Win32SingleServicePanel
    extends ServiceScreen.SingleServicePanel
    implements ActionListener {
        private JCheckBox chkInstall;
        private JCheckBox chkAutoStart;

        public Win32SingleServicePanel(ServiceConfig serviceConfig) {
            super(serviceConfig);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(3, 5, 0, 10);
            this.chkInstall = new JCheckBox(MessageFormat.format(Win32ServiceScreen.this.messages.getString("WindowsServiceInstallCheckbox"), serviceConfig.getName()), serviceConfig.isInstall());
            this.chkAutoStart = new JCheckBox(Win32ServiceScreen.this.messages.getString("WindowsServiceStartOnBootupCheckbox"), serviceConfig.getStartupType().equals("auto"));
            this.add((Component)this.chkInstall, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets.top = 0;
            gridBagConstraints.insets.left += CHECKBOX_WIDTH;
            this.add((Component)this.chkAutoStart, gridBagConstraints);
            this.chkInstall.addActionListener(this);
            this.checkEnabled();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.chkInstall) {
                this.checkEnabled();
            }
        }

        public void save() {
            ServiceConfig serviceConfig = this.getServiceConfig();
            serviceConfig.setInstall(this.chkInstall.isSelected());
            serviceConfig.setStartupType(this.chkAutoStart.isSelected() ? "auto" : "manual");
        }

        private void checkEnabled() {
            this.chkAutoStart.setEnabled(this.chkInstall.isSelected());
        }
    }
}

