/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectParser;
import org.bouncycastle.asn1.BERNull;
import org.bouncycastle.asn1.BEROctetStringParser;
import org.bouncycastle.asn1.BERSequenceParser;
import org.bouncycastle.asn1.BERSetParser;
import org.bouncycastle.asn1.BERTaggedObjectParser;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DefiniteLengthInputStream;
import org.bouncycastle.asn1.IndefiniteLengthInputStream;

public class ASN1StreamParser {
    InputStream _in;
    private int _limit;
    private boolean _eofFound;

    public ASN1StreamParser(InputStream inputStream) {
        this(inputStream, Integer.MAX_VALUE);
    }

    public ASN1StreamParser(InputStream inputStream, int n) {
        this._in = inputStream;
        this._limit = n;
    }

    public ASN1StreamParser(byte[] byArray) {
        this(new ByteArrayInputStream(byArray), byArray.length);
    }

    InputStream getParentStream() {
        return this._in;
    }

    private int readLength() throws IOException {
        int n = this._in.read();
        if (n < 0) {
            throw new EOFException("EOF found when length expected");
        }
        if (n == 128) {
            return -1;
        }
        if (n > 127) {
            int n2 = n & 0x7F;
            if (n2 > 4) {
                throw new IOException("DER length more than 4 bytes");
            }
            n = 0;
            for (int i = 0; i < n2; ++i) {
                int n3 = this._in.read();
                if (n3 < 0) {
                    throw new EOFException("EOF found reading length");
                }
                n = (n << 8) + n3;
            }
            if (n < 0) {
                throw new IOException("corrupted steam - negative length found");
            }
            if (n >= this._limit) {
                throw new IOException("corrupted steam - out of bounds length found");
            }
        }
        return n;
    }

    public DEREncodable readObject() throws IOException {
        int n;
        int n2;
        int n3 = this._in.read();
        if (n3 == -1) {
            if (this._eofFound) {
                throw new EOFException("attempt to read past end of file.");
            }
            this._eofFound = true;
            return null;
        }
        if (this._in instanceof IndefiniteLengthInputStream) {
            ((IndefiniteLengthInputStream)this._in).setEofOn00(false);
        }
        int n4 = n2 = n3 & 0xFFFFFFDF;
        if ((n3 & 0x80) != 0 && (n4 = n3 & 0x1F) == 31) {
            n4 = 0;
            n = this._in.read();
            while (n >= 0 && (n & 0x80) != 0) {
                n4 |= n & 0x7F;
                n4 <<= 7;
                n = this._in.read();
            }
            if (n < 0) {
                this._eofFound = true;
                throw new EOFException("EOF encountered inside tag value.");
            }
            n4 |= n & 0x7F;
        }
        if ((n = this.readLength()) < 0) {
            IndefiniteLengthInputStream indefiniteLengthInputStream = new IndefiniteLengthInputStream(this._in);
            if (n2 == 5) {
                return BERNull.INSTANCE;
            }
            switch (n2) {
                case 4: {
                    return new BEROctetStringParser(new ASN1ObjectParser(n3, n4, indefiniteLengthInputStream));
                }
                case 16: {
                    return new BERSequenceParser(new ASN1ObjectParser(n3, n4, indefiniteLengthInputStream));
                }
                case 17: {
                    return new BERSetParser(new ASN1ObjectParser(n3, n4, indefiniteLengthInputStream));
                }
            }
            return new BERTaggedObjectParser(n3, n4, indefiniteLengthInputStream);
        }
        DefiniteLengthInputStream definiteLengthInputStream = new DefiniteLengthInputStream(this._in, n);
        switch (n2) {
            case 2: {
                return new DERInteger(definiteLengthInputStream.toByteArray());
            }
            case 5: {
                return DERNull.INSTANCE;
            }
            case 6: {
                return new DERObjectIdentifier(definiteLengthInputStream.toByteArray());
            }
            case 4: {
                return new DEROctetString(definiteLengthInputStream.toByteArray());
            }
            case 16: {
                return new DERSequence(this.loadVector(definiteLengthInputStream.toByteArray())).parser();
            }
            case 17: {
                return new DERSet(this.loadVector(definiteLengthInputStream.toByteArray())).parser();
            }
        }
        return new BERTaggedObjectParser(n3, n4, definiteLengthInputStream);
    }

    private ASN1EncodableVector loadVector(byte[] byArray) throws IOException {
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        DERObject dERObject = aSN1InputStream.readObject();
        while (dERObject != null) {
            aSN1EncodableVector.add(dERObject);
            dERObject = aSN1InputStream.readObject();
        }
        return aSN1EncodableVector;
    }
}

