/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefensiveTools {
    private DefensiveTools() {
    }

    public static void checkRange(int n, String string, int n2) throws IllegalArgumentException {
        if (n < n2) {
            throw new IllegalArgumentException(string + " (" + n + ") must " + "be >= " + n2);
        }
    }

    public static void checkRange(int n, String string, int n2, int n3) throws IllegalArgumentException {
        if (n < n2 || n > n3) {
            throw new IllegalArgumentException(string + " (" + n + ") must " + "be >=" + n2 + " and <=" + n3);
        }
    }

    public static void checkRange(long l, String string, long l2) throws IllegalArgumentException {
        if (l < l2) {
            throw new IllegalArgumentException(string + " (" + l + ") must " + "be >= " + l2);
        }
    }

    public static void checkRange(long l, String string, long l2, long l3) {
        if (l < l2 || l > l3) {
            throw new IllegalArgumentException(string + " (" + l + ") must " + "be >=" + l2 + " and <=" + l3);
        }
    }

    public static void checkNull(Object object, String string) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException("value of " + string + " cannot be null");
        }
    }

    public static void checkNullElements(Object[] objectArray, String string) throws IllegalArgumentException {
        DefensiveTools.checkNull(objectArray, string);
        DefensiveTools.checkNullElements(objectArray, string, 0, objectArray.length);
    }

    public static void checkNullElements(Object[] objectArray, String string, int n, int n2) throws IllegalArgumentException {
        DefensiveTools.checkNull(objectArray, string);
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            if (objectArray[i] != null) continue;
            throw new IllegalArgumentException("'" + string + "' array must not contain any null elements at " + "indices " + n + " through " + (n + n2) + " (" + string + "[" + i + "] == null)");
        }
    }

    public static void checkNullElements(List<?> list, String string, int n, int n2) {
        DefensiveTools.checkNull(list, string);
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            if (list.get(i) != null) continue;
            throw new IllegalArgumentException("'" + string + "' array must not contain any null elements at " + "indices " + n + " through " + (n + n2) + " (" + string + "[" + i + "] == null)");
        }
    }

    public static <E> E[] getSafeArrayCopy(E[] EArray, String string) throws IllegalArgumentException {
        if (EArray == null) {
            return null;
        }
        Object[] objectArray = (Object[])EArray.clone();
        DefensiveTools.checkNullElements(objectArray, string);
        return objectArray;
    }

    public static <E> E[] getSafeNonnullArrayCopy(E[] EArray, String string) throws IllegalArgumentException {
        DefensiveTools.checkNull(EArray, string);
        Object[] objectArray = (Object[])EArray.clone();
        DefensiveTools.checkNullElements(objectArray, string);
        return objectArray;
    }

    public static int[] getSafeMinArrayCopy(int[] nArray, String string, int n) {
        DefensiveTools.checkNull(nArray, string);
        int[] nArray2 = (int[])nArray.clone();
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray2[i] >= n) continue;
            throw new IllegalArgumentException(string + " elements must " + "be >= " + n + " (" + string + "[" + i + "] is " + nArray2[i] + ")");
        }
        return nArray2;
    }

    public static <E> List<E> getSafeNonnullListCopy(Collection<? extends E> collection, String string) {
        DefensiveTools.checkNull(collection, string);
        List<? extends E> list = DefensiveTools.getUnmodifiableCopy(collection);
        DefensiveTools.checkNullElements(list, string);
        return list;
    }

    public static void checkNullElements(List<?> list, String string) {
        DefensiveTools.checkNullElements(list, string, 0, list.size());
    }

    public static <E> List<E> getUnmodifiableCopy(Collection<? extends E> collection) {
        if (collection == null) {
            return null;
        }
        return Collections.unmodifiableList(new ArrayList<E>(collection));
    }

    public static <E> List<E> getUnmodifiable(List<E> list) {
        return Collections.unmodifiableList(list);
    }

    public static <E> List<E> getSafeListCopy(Collection<? extends E> collection, String string) {
        if (collection == null) {
            return null;
        }
        List<? extends E> list = DefensiveTools.getUnmodifiableCopy(collection);
        DefensiveTools.checkNullElements(list, string);
        return list;
    }

    public static <E> List<E> asUnmodifiableList(E ... EArray) {
        return DefensiveTools.getUnmodifiable(Arrays.asList(EArray));
    }

    public static <E> List<E> emptyList() {
        return Collections.EMPTY_LIST;
    }

    public static <E> Set<E> getUnmodifiableSetCopy(Collection<? extends E> collection) {
        return Collections.unmodifiableSet(new LinkedHashSet<E>(collection));
    }
}

