/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.component;

import org.mortbay.component.LifeCycle;
import org.mortbay.log.Log;

public abstract class AbstractLifeCycle
implements LifeCycle {
    private final int FAILED = -1;
    private final int STOPPED = 0;
    private final int STARTING = 1;
    private final int STARTED = 2;
    private final int STOPPING = 3;
    private transient int _state = 0;

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    public final void start() throws Exception {
        try {
            if (this._state == 2) {
                return;
            }
            this._state = 1;
            this.doStart();
            Log.debug("started {}", this);
            this._state = 2;
        }
        catch (Exception e) {
            Log.warn("failed {}", this);
            this._state = -1;
            throw e;
        }
        catch (Error e) {
            Log.warn("failed {}", this);
            this._state = -1;
            throw e;
        }
    }

    public final void stop() throws Exception {
        try {
            if (this._state < 1) {
                return;
            }
            this._state = 3;
            this.doStop();
            Log.debug("stopped {}", this);
            this._state = 0;
        }
        catch (Exception e) {
            Log.debug("failed {}", this);
            this._state = -1;
            throw e;
        }
        catch (Error e) {
            Log.debug("failed {}", this);
            this._state = -1;
            throw e;
        }
    }

    public boolean isRunning() {
        return this._state == 2 || this._state == 1;
    }

    public boolean isStarted() {
        return this._state == 2;
    }

    public boolean isStarting() {
        return this._state == 1;
    }

    public boolean isStopping() {
        return this._state == 3;
    }

    public boolean isFailed() {
        return this._state == -1;
    }
}

