/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.jetty.HttpOnlyCookie;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.SessionIdManager;
import org.mortbay.jetty.SessionManager;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.servlet.HashSessionIdManager;
import org.mortbay.jetty.servlet.SessionHandler;
import org.mortbay.log.Log;
import org.mortbay.util.LazyList;

public abstract class AbstractSessionManager
extends AbstractLifeCycle
implements SessionManager {
    private static final HttpSessionContext __nullSessionContext = new NullSessionContext();
    public static final int __distantFuture = 628992000;
    private int _dftMaxIdleSecs = -1;
    protected boolean _httpOnly = false;
    protected int _maxSessions = 0;
    protected int _minSessions = 0;
    private int _scavengePeriodMs = 30000;
    private SessionIdManager _sessionIdManager;
    private SessionHandler _sessionHandler;
    private Thread _scavenger = null;
    protected boolean _secureCookies = false;
    protected Object _sessionAttributeListeners;
    protected Object _sessionListeners;
    protected Map _sessions;
    private boolean _usingCookies = true;
    protected ClassLoader _loader;
    protected ContextHandler.Context _context;
    protected String _sessionCookie;
    protected String _sessionURL;
    protected String _sessionURLPrefix;
    protected String _sessionDomain;
    protected String _sessionPath;
    protected int _maxSessionCookieAge = Integer.parseInt("-1");
    protected boolean _maxAgeSet = false;

    public void setSessionCookie(String cookieName) {
        this._sessionCookie = cookieName;
    }

    public String getSessionCookie() {
        return this._sessionCookie;
    }

    public void setSessionURL(String url) {
        this._sessionURL = url;
    }

    public String getSessionURL() {
        return this._sessionURL;
    }

    public String getSessionURLPrefix() {
        return this._sessionURLPrefix;
    }

    public void setSessionDomain(String domain) {
        this._sessionDomain = domain;
    }

    public String getSessionDomain() {
        return this._sessionDomain;
    }

    public void setSessionPath(String path) {
        this._sessionPath = path;
    }

    public String getSessionPath() {
        return this._sessionPath;
    }

    public void setMaxSessionCookieAge(int maxCookieAge) {
        this._maxSessionCookieAge = maxCookieAge;
        this._maxAgeSet = true;
    }

    public int getMaxCookieAge() {
        return this._maxSessionCookieAge;
    }

    public void clearEventListeners() {
        this._sessionAttributeListeners = null;
        this._sessionListeners = null;
    }

    public void addEventListener(EventListener listener) {
        if (listener instanceof HttpSessionAttributeListener) {
            this._sessionAttributeListeners = LazyList.add((Object)this._sessionAttributeListeners, (Object)listener);
        }
        if (listener instanceof HttpSessionListener) {
            this._sessionListeners = LazyList.add((Object)this._sessionListeners, (Object)listener);
        }
    }

    public SessionIdManager getMetaManager() {
        return this._sessionIdManager;
    }

    public void setMetaManager(SessionIdManager metaManager) {
        this._sessionIdManager = metaManager;
    }

    public boolean getHttpOnly() {
        return this._httpOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpSession getHttpSession(String id) {
        AbstractSessionManager abstractSessionManager = this;
        synchronized (abstractSessionManager) {
            return (HttpSession)this._sessions.get(id);
        }
    }

    public int getMaxInactiveInterval() {
        return this._dftMaxIdleSecs;
    }

    public int getMaxSessions() {
        return this._maxSessions;
    }

    public int getMinSessions() {
        return this._minSessions;
    }

    public int getScavengePeriod() {
        return this._scavengePeriodMs / 1000;
    }

    public boolean getSecureCookies() {
        return this._secureCookies;
    }

    public Cookie getSessionCookie(HttpSession session, String contextPath, boolean requestIsSecure) {
        if (this.isUsingCookies()) {
            HttpOnlyCookie cookie = this.getHttpOnly() ? new HttpOnlyCookie(this._sessionCookie, session.getId()) : new Cookie(this._sessionCookie, session.getId());
            cookie.setPath(contextPath == null || contextPath.length() == 0 ? "/" : contextPath);
            cookie.setMaxAge(this._maxSessionCookieAge);
            cookie.setSecure(requestIsSecure && this.getSecureCookies());
            if (this._sessionDomain != null) {
                cookie.setDomain(this._sessionDomain);
            }
            if (this._sessionPath != null) {
                cookie.setPath(this._sessionPath);
            }
            return cookie;
        }
        return null;
    }

    public Map getSessionMap() {
        return Collections.unmodifiableMap(this._sessions);
    }

    public int getSessions() {
        return this._sessions.size();
    }

    public boolean isUsingCookies() {
        return this._usingCookies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpSession newHttpSession(HttpServletRequest request) {
        Session session = this.newSession(request);
        session.setMaxInactiveInterval(this._dftMaxIdleSecs);
        SessionIdManager sessionIdManager = this._sessionIdManager;
        synchronized (sessionIdManager) {
            AbstractSessionManager abstractSessionManager = this;
            synchronized (abstractSessionManager) {
                this._sessions.put(session.getId(), session);
                this._sessionIdManager.addSession(session);
                if (this._sessions.size() > this._maxSessions) {
                    this._maxSessions = this._sessions.size();
                }
            }
        }
        HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
        for (int i = 0; i < LazyList.size((Object)this._sessionListeners); ++i) {
            ((HttpSessionListener)LazyList.get((Object)this._sessionListeners, (int)i)).sessionCreated(event);
        }
        return session;
    }

    protected abstract Session newSession(HttpServletRequest var1);

    public void removeEventListener(EventListener listener) {
        if (listener instanceof HttpSessionAttributeListener) {
            this._sessionAttributeListeners = LazyList.remove((Object)this._sessionAttributeListeners, (Object)listener);
        }
        if (listener instanceof HttpSessionListener) {
            this._sessionListeners = LazyList.remove((Object)this._sessionListeners, (Object)listener);
        }
    }

    public void resetStats() {
        this._minSessions = this._sessions.size();
        this._maxSessions = this._sessions.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scavenge() {
        Thread thread = Thread.currentThread();
        ClassLoader old_loader = thread.getContextClassLoader();
        try {
            if (this._loader != null) {
                thread.setContextClassLoader(this._loader);
            }
            long now = System.currentTimeMillis();
            Object stale = null;
            AbstractSessionManager abstractSessionManager = this;
            synchronized (abstractSessionManager) {
                Iterator i = this._sessions.values().iterator();
                while (i.hasNext()) {
                    Session session = (Session)i.next();
                    long idleTime = session._maxIdleMs;
                    if (idleTime <= 0L || session._accessed + idleTime >= now) continue;
                    stale = LazyList.add(stale, (Object)session);
                }
            }
            int i = LazyList.size(stale);
            while (i-- > 0) {
                Session session = (Session)LazyList.get(stale, (int)i);
                long idleTime = session._maxIdleMs;
                if (idleTime <= 0L || session._accessed + idleTime >= System.currentTimeMillis()) continue;
                session.invalidate();
                int nbsess = this._sessions.size();
                if (nbsess >= this._minSessions) continue;
                this._minSessions = nbsess;
            }
        }
        finally {
            thread.setContextClassLoader(old_loader);
        }
    }

    public void setHttpOnly(boolean httpOnly) {
        this._httpOnly = httpOnly;
    }

    public void setMaxInactiveInterval(int seconds) {
        this._dftMaxIdleSecs = seconds;
        if (this._dftMaxIdleSecs > 0 && this._scavengePeriodMs > this._dftMaxIdleSecs * 1000) {
            this.setScavengePeriod((this._dftMaxIdleSecs + 9) / 10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScavengePeriod(int seconds) {
        if (seconds == 0) {
            seconds = 60;
        }
        int old_period = this._scavengePeriodMs;
        int period = seconds * 1000;
        if (period > 60000) {
            period = 60000;
        }
        if (period < 1000) {
            period = 1000;
        }
        if (period != old_period) {
            AbstractSessionManager abstractSessionManager = this;
            synchronized (abstractSessionManager) {
                this._scavengePeriodMs = period;
                if (this._scavenger != null) {
                    this._scavenger.interrupt();
                }
            }
        }
    }

    public void setSecureCookies(boolean secureCookies) {
        this._secureCookies = secureCookies;
    }

    public void setUsingCookies(boolean usingCookies) {
        this._usingCookies = usingCookies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() throws Exception {
        String str;
        this._context = ContextHandler.getCurrentContext();
        this._loader = Thread.currentThread().getContextClassLoader();
        if (this._sessions == null) {
            this._sessions = new HashMap();
        }
        if (this._sessionIdManager == null) {
            Server server;
            Server server2 = server = this.getSessionHandler().getServer();
            synchronized (server2) {
                this._sessionIdManager = server.getSessionIdManager();
                if (this._sessionIdManager == null) {
                    this._sessionIdManager = new HashSessionIdManager();
                    server.setSessionIdManager(this._sessionIdManager);
                }
            }
        }
        if (!this._sessionIdManager.isStarted()) {
            this._sessionIdManager.start();
        }
        if (this._sessionCookie == null) {
            str = null;
            if (this._context != null) {
                str = this._context.getInitParameter("org.mortbay.jetty.servlet.SessionCookie");
            }
            String string = this._sessionCookie = str == null ? SessionManager.__SessionCookieSystemProperty : str;
        }
        if (this._sessionURL == null) {
            str = null;
            if (this._context != null) {
                str = this._context.getInitParameter("org.mortbay.jetty.servlet.SessionURL");
            }
            this._sessionURL = str == null ? SessionManager.__SessionURLSystemProperty : str;
        }
        this._sessionURLPrefix = ";" + this._sessionURL + "=";
        if (!this._maxAgeSet) {
            str = null;
            if (this._context != null) {
                str = this._context.getInitParameter("org.mortbay.jetty.servlet.MaxAge");
            }
            str = str == null ? SessionManager.__MaxAgeSystemProperty : str;
            this._maxSessionCookieAge = Integer.parseInt(str.trim());
            this._maxAgeSet = true;
        }
        if (this._sessionDomain == null && this._context != null) {
            this._sessionDomain = this._context.getInitParameter("org.mortbay.jetty.servlet.SessionDomain");
        }
        if (this._sessionPath == null && this._context != null) {
            this._sessionPath = this._context.getInitParameter("org.mortbay.jetty.servlet.SessionPath");
        }
        super.doStart();
        this._sessionHandler.getServer().getThreadPool().dispatch((Runnable)new SessionScavenger());
    }

    public void doStop() throws Exception {
        super.doStop();
        ArrayList sessions = new ArrayList(this._sessions.values());
        Iterator i = sessions.iterator();
        while (i.hasNext()) {
            Session session = (Session)i.next();
            session.invalidate();
        }
        this._sessions.clear();
        Thread scavenger = this._scavenger;
        this._scavenger = null;
        if (scavenger != null) {
            scavenger.interrupt();
        }
        this._loader = null;
    }

    public void access(HttpSession session) {
        ((Session)session).access();
    }

    public void complete(HttpSession session) {
    }

    public boolean isValid(HttpSession session) {
        return ((Session)session).isValid();
    }

    public SessionHandler getSessionHandler() {
        return this._sessionHandler;
    }

    public void setSessionHandler(SessionHandler sessionHandler) {
        this._sessionHandler = sessionHandler;
    }

    public static class NullSessionContext
    implements HttpSessionContext {
        private NullSessionContext() {
        }

        public Enumeration getIds() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        public HttpSession getSession(String id) {
            return null;
        }
    }

    class SessionScavenger
    implements Runnable {
        SessionScavenger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            AbstractSessionManager.this._scavenger = Thread.currentThread();
            String name = Thread.currentThread().getName();
            if (AbstractSessionManager.this._context != null) {
                Thread.currentThread().setName(name + " - Invalidator - " + AbstractSessionManager.this._context.getContextPath());
            }
            int period = -1;
            try {
                do {
                    try {
                        if (period != AbstractSessionManager.this._scavengePeriodMs) {
                            if (Log.isDebugEnabled()) {
                                Log.debug((String)("Session scavenger period = " + AbstractSessionManager.this._scavengePeriodMs / 1000 + "s"));
                            }
                            period = AbstractSessionManager.this._scavengePeriodMs;
                        }
                        Thread.sleep(period > 1000 ? (long)period : 1000L);
                        AbstractSessionManager.this.scavenge();
                    }
                    catch (InterruptedException ex) {
                    }
                    catch (Error e) {
                        Log.warn((String)"EXCEPTION ", (Throwable)e);
                    }
                    catch (Exception e) {
                        Log.warn((String)"EXCEPTION ", (Throwable)e);
                    }
                } while (AbstractSessionManager.this.isStarted());
            }
            finally {
                AbstractSessionManager.this._scavenger = null;
                String exit = "Session scavenger exited";
                if (AbstractSessionManager.this.isStarted()) {
                    Log.warn((String)exit);
                } else {
                    Log.debug((String)exit);
                }
                Thread.currentThread().setName(name);
            }
        }
    }

    public abstract class Session
    implements HttpSession {
        long _created;
        long _accessed;
        String _id;
        boolean _invalid;
        long _maxIdleMs;
        boolean _newSession;
        Map _values;

        protected Session(HttpServletRequest request) {
            this._accessed = this._created = System.currentTimeMillis();
            this._invalid = false;
            this._maxIdleMs = AbstractSessionManager.this._dftMaxIdleSecs * 1000;
            this._newSession = true;
            this._id = AbstractSessionManager.this._sessionIdManager.newSessionId(request, this._created);
            if (AbstractSessionManager.this._dftMaxIdleSecs >= 0) {
                this._maxIdleMs = AbstractSessionManager.this._dftMaxIdleSecs * 1000;
            }
        }

        void access() {
            this._newSession = false;
            this._accessed = System.currentTimeMillis();
        }

        private void bindValue(String name, Object value) {
            if (value != null && value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent((HttpSession)this, name));
            }
        }

        public synchronized Object getAttribute(String name) {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            if (this._values == null) {
                return null;
            }
            return this._values.get(name);
        }

        public synchronized Enumeration getAttributeNames() {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            List<Object> names = this._values == null ? Collections.EMPTY_LIST : new ArrayList(this._values.keySet());
            return Collections.enumeration(names);
        }

        public long getCreationTime() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return this._created;
        }

        public String getId() throws IllegalStateException {
            return this._id;
        }

        public long getLastAccessedTime() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return this._accessed;
        }

        public int getMaxInactiveInterval() {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return (int)(this._maxIdleMs / 1000L);
        }

        public ServletContext getServletContext() {
            return AbstractSessionManager.this._context;
        }

        public HttpSessionContext getSessionContext() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return __nullSessionContext;
        }

        public Object getValue(String name) throws IllegalStateException {
            return this.getAttribute(name);
        }

        public synchronized String[] getValueNames() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            if (this._values == null) {
                return new String[0];
            }
            String[] a = new String[this._values.size()];
            return this._values.keySet().toArray(a);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidate() throws IllegalStateException {
            Object object;
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Invalidate session " + this.getId()));
            }
            try {
                object = this;
                synchronized (object) {
                    if (this._invalid) {
                        throw new IllegalStateException();
                    }
                    if (AbstractSessionManager.this._sessionListeners != null) {
                        HttpSessionEvent event = new HttpSessionEvent((HttpSession)this);
                        int i = LazyList.size((Object)AbstractSessionManager.this._sessionListeners);
                        while (i-- > 0) {
                            ((HttpSessionListener)LazyList.get((Object)AbstractSessionManager.this._sessionListeners, (int)i)).sessionDestroyed(event);
                        }
                    }
                    if (this._values != null) {
                        Iterator iter = this._values.keySet().iterator();
                        while (iter.hasNext()) {
                            String key = (String)iter.next();
                            Object value = this._values.get(key);
                            iter.remove();
                            this.unbindValue(key, value);
                            if (AbstractSessionManager.this._sessionAttributeListeners == null) continue;
                            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, key, value);
                            for (int i = 0; i < LazyList.size((Object)AbstractSessionManager.this._sessionAttributeListeners); ++i) {
                                ((HttpSessionAttributeListener)LazyList.get((Object)AbstractSessionManager.this._sessionAttributeListeners, (int)i)).attributeRemoved(event);
                            }
                        }
                    }
                }
            }
            finally {
                object = AbstractSessionManager.this._sessionIdManager;
                synchronized (object) {
                    String id = this.getId();
                    Map map = AbstractSessionManager.this._sessions;
                    synchronized (map) {
                        this._invalid = true;
                        AbstractSessionManager.this._sessions.remove(id);
                    }
                    AbstractSessionManager.this._sessionIdManager.invalidateAll(id);
                }
            }
        }

        public boolean isNew() throws IllegalStateException {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            return this._newSession;
        }

        boolean isValid() {
            return !this._invalid;
        }

        protected abstract Map newAttributeMap();

        public void putValue(String name, Object value) throws IllegalStateException {
            this.setAttribute(name, value);
        }

        public synchronized void removeAttribute(String name) {
            if (this._invalid) {
                throw new IllegalStateException();
            }
            if (this._values == null) {
                return;
            }
            Object old = this._values.remove(name);
            if (old != null) {
                this.unbindValue(name, old);
                if (AbstractSessionManager.this._sessionAttributeListeners != null) {
                    HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name, old);
                    for (int i = 0; i < LazyList.size((Object)AbstractSessionManager.this._sessionAttributeListeners); ++i) {
                        ((HttpSessionAttributeListener)LazyList.get((Object)AbstractSessionManager.this._sessionAttributeListeners, (int)i)).attributeRemoved(event);
                    }
                }
            }
        }

        public void removeValue(String name) throws IllegalStateException {
            this.removeAttribute(name);
        }

        public synchronized void setAttribute(String name, Object value) {
            if (value == null) {
                this.removeAttribute(name);
                return;
            }
            if (this._invalid) {
                throw new IllegalStateException();
            }
            if (this._values == null) {
                this._values = this.newAttributeMap();
            }
            Object oldValue = this._values.put(name, value);
            if (value == null || !value.equals(oldValue)) {
                this.unbindValue(name, oldValue);
                this.bindValue(name, value);
                if (AbstractSessionManager.this._sessionAttributeListeners != null) {
                    HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name, oldValue == null ? value : oldValue);
                    for (int i = 0; i < LazyList.size((Object)AbstractSessionManager.this._sessionAttributeListeners); ++i) {
                        HttpSessionAttributeListener l = (HttpSessionAttributeListener)LazyList.get((Object)AbstractSessionManager.this._sessionAttributeListeners, (int)i);
                        if (oldValue == null) {
                            l.attributeAdded(event);
                            continue;
                        }
                        if (value == null) {
                            l.attributeRemoved(event);
                            continue;
                        }
                        l.attributeReplaced(event);
                    }
                }
            }
        }

        public void setMaxInactiveInterval(int secs) {
            this._maxIdleMs = (long)secs * 1000L;
            if (this._maxIdleMs > 0L && this._maxIdleMs / 10L < (long)AbstractSessionManager.this._scavengePeriodMs) {
                AbstractSessionManager.this.setScavengePeriod((secs + 9) / 10);
            }
        }

        private void unbindValue(String name, Object value) {
            if (value != null && value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name));
            }
        }

        public String toString() {
            return this.getClass().getName() + ":" + this.getId() + "@" + this.hashCode();
        }
    }
}

