/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network;

import java.io.IOException;
import java.net.SocketException;
import java.util.Queue;
import org.openymsg.network.ServiceType;
import org.openymsg.network.Session;
import org.openymsg.network.YMSG9BadFormatException;
import org.openymsg.network.YMSG9Packet;
import org.openymsg.network.YahooConference;
import org.openymsg.network.event.SessionConferenceEvent;

public class InputThread
extends Thread {
    private volatile boolean quit = false;
    private final Session parentSession;

    public InputThread(Session session) {
        super("jYMSG Network Input thread");
        this.parentSession = session;
    }

    public void stopMe() {
        this.quit = true;
    }

    public void run() {
        while (!this.quit) {
            try {
                this.process(this.parentSession.network.receivePacket());
            }
            catch (Exception exception) {
                if (this.quit && exception instanceof SocketException) {
                    return;
                }
                exception.printStackTrace();
                try {
                    this.parentSession.sendExceptionEvent(exception, "Source: InputThread");
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
                if (!(exception instanceof IOException)) continue;
                this.quit = true;
            }
        }
    }

    private void process(YMSG9Packet yMSG9Packet) throws Exception {
        if (yMSG9Packet == null) {
            this.quit = true;
            return;
        }
        if (yMSG9Packet.sessionId != 0L) {
            this.parentSession.sessionId = yMSG9Packet.sessionId;
        }
        if (yMSG9Packet.status == -1L && this.processError(yMSG9Packet)) {
            return;
        }
        switch (yMSG9Packet.service) {
            case ADDIGNORE: {
                this.parentSession.receiveAddIgnore(yMSG9Packet);
                break;
            }
            case AUTH: {
                this.parentSession.receiveAuth(yMSG9Packet);
                break;
            }
            case AUTHRESP: {
                this.parentSession.receiveAuthResp(yMSG9Packet);
                break;
            }
            case CHATCONNECT: {
                this.parentSession.receiveChatConnect(yMSG9Packet);
                break;
            }
            case CHATDISCONNECT: {
                this.parentSession.receiveChatDisconnect(yMSG9Packet);
                break;
            }
            case CHATEXIT: {
                this.parentSession.receiveChatExit(yMSG9Packet);
                break;
            }
            case CHATJOIN: {
                this.parentSession.receiveChatJoin(yMSG9Packet);
                break;
            }
            case CHATMSG: {
                this.parentSession.receiveChatMsg(yMSG9Packet);
                break;
            }
            case CHATPM: {
                this.parentSession.receiveChatPM(yMSG9Packet);
                break;
            }
            case CONFADDINVITE: {
                this.receiveConfAddInvite(yMSG9Packet);
                break;
            }
            case CONFDECLINE: {
                this.parentSession.receiveConfDecline(yMSG9Packet);
                break;
            }
            case CONFINVITE: {
                this.receiveConfInvite(yMSG9Packet);
                break;
            }
            case CONFLOGOFF: {
                this.parentSession.receiveConfLogoff(yMSG9Packet);
                break;
            }
            case CONFLOGON: {
                this.parentSession.receiveConfLogon(yMSG9Packet);
                break;
            }
            case CONFMSG: {
                this.parentSession.receiveConfMsg(yMSG9Packet);
                break;
            }
            case CONTACTIGNORE: {
                this.parentSession.receiveContactIgnore(yMSG9Packet);
                break;
            }
            case CONTACTNEW: {
                this.parentSession.receiveContactNew(yMSG9Packet);
                break;
            }
            case FILETRANSFER: {
                this.parentSession.receiveFileTransfer(yMSG9Packet);
                break;
            }
            case FRIENDADD: {
                this.parentSession.receiveFriendAdd(yMSG9Packet);
                break;
            }
            case FRIENDREMOVE: {
                this.parentSession.receiveFriendRemove(yMSG9Packet);
                break;
            }
            case GOTGROUPRENAME: {
                this.parentSession.receiveGroupRename(yMSG9Packet);
                break;
            }
            case IDACT: {
                this.parentSession.receiveIdAct(yMSG9Packet);
                break;
            }
            case IDDEACT: {
                this.parentSession.receiveIdDeact(yMSG9Packet);
                break;
            }
            case ISAWAY: {
                this.parentSession.receiveIsAway(yMSG9Packet);
                break;
            }
            case ISBACK: {
                this.parentSession.receiveIsBack(yMSG9Packet);
                break;
            }
            case LIST: {
                this.parentSession.receiveList(yMSG9Packet);
                break;
            }
            case LOGOFF: {
                this.parentSession.receiveLogoff(yMSG9Packet);
                break;
            }
            case LOGON: {
                this.parentSession.receiveLogon(yMSG9Packet);
                break;
            }
            case MESSAGE: {
                this.parentSession.receiveMessage(yMSG9Packet);
                break;
            }
            case NEWMAIL: {
                this.parentSession.receiveNewMail(yMSG9Packet);
                break;
            }
            case NOTIFY: {
                this.parentSession.receiveNotify(yMSG9Packet);
                break;
            }
            case USERSTAT: {
                this.parentSession.receiveUserStat(yMSG9Packet);
                break;
            }
            case Y6_STATUS_UPDATE: {
                this.parentSession.receiveStatusUpdate(yMSG9Packet);
                break;
            }
            default: {
                throw new IllegalArgumentException("Don't know how to handle service type '" + (Object)((Object)yMSG9Packet.service) + "'. The original packet was: " + yMSG9Packet.toString());
            }
        }
    }

    private boolean processError(YMSG9Packet yMSG9Packet) throws Exception {
        switch (yMSG9Packet.service) {
            case AUTHRESP: {
                this.parentSession.receiveAuthResp(yMSG9Packet);
                return true;
            }
            case CHATJOIN: {
                this.parentSession.receiveChatJoin(yMSG9Packet);
                return true;
            }
            case LOGOFF: {
                this.parentSession.receiveLogoff(yMSG9Packet);
                return true;
            }
        }
        this.parentSession.errorMessage(yMSG9Packet, null);
        return yMSG9Packet.body.length <= 2;
    }

    private void receiveConfAddInvite(YMSG9Packet yMSG9Packet) {
        this.receiveConfInvite(yMSG9Packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveConfInvite(YMSG9Packet yMSG9Packet) {
        try {
            YahooConference yahooConference = this.parentSession.getOrCreateConference(yMSG9Packet);
            String[] stringArray = yMSG9Packet.getValues("52");
            SessionConferenceEvent sessionConferenceEvent = new SessionConferenceEvent(this, yMSG9Packet.getValue("1"), yMSG9Packet.getValue("50"), yMSG9Packet.getValue("58"), yahooConference, this.parentSession.userStore.toUserArray(stringArray));
            yahooConference.addUsers(stringArray);
            yahooConference.addUser(sessionConferenceEvent.getFrom());
            if (!yahooConference.isClosed()) {
                this.parentSession.fire(sessionConferenceEvent, ServiceType.CONFINVITE);
            }
            YahooConference yahooConference2 = yahooConference;
            synchronized (yahooConference2) {
                Queue<YMSG9Packet> queue = yahooConference.inviteReceived();
                for (YMSG9Packet yMSG9Packet2 : queue) {
                    this.process(yMSG9Packet2);
                }
            }
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("conference invite", yMSG9Packet, exception);
        }
    }
}

