/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import uk.ltd.getahead.dwr.InboundVariable;
import uk.ltd.getahead.dwr.TypeHintContext;
import uk.ltd.getahead.dwr.util.Logger;

public final class InboundContext {
    private LinkedList contexts = new LinkedList();
    private int paramCount = 0;
    private final Map variables = new HashMap();
    private final Map converted = new HashMap();
    private static final Logger log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("uk.ltd.getahead.dwr.InboundContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger(clazz);
    }

    public void pushContext(TypeHintContext context) {
        this.contexts.addFirst(context);
    }

    public void popContext() {
        this.contexts.removeFirst();
    }

    public TypeHintContext getCurrentTypeHintContext() {
        return (TypeHintContext)this.contexts.getFirst();
    }

    public void createInboundVariable(int callNum, String key, String type, String value) {
        int i;
        String paramPrefix;
        InboundVariable cte = new InboundVariable(this, key, type, value);
        InboundVariable old = this.variables.put(key, cte);
        if (old != null) {
            log.warn("Duplicate variable called: " + key);
        }
        if (key.startsWith(paramPrefix = "c" + callNum + "-" + "param") && (i = Integer.parseInt(key.substring(paramPrefix.length())) + 1) > this.paramCount) {
            this.paramCount = i;
        }
    }

    public InboundVariable getInboundVariable(String name) {
        return (InboundVariable)this.variables.get(name);
    }

    public void clearConverted() {
        this.converted.clear();
    }

    public void addConverted(InboundVariable iv, Class type, Object bean) {
        Conversion conversion = new Conversion(iv, type);
        Object old = this.converted.put(conversion, bean);
        if (old != null) {
            log.warn("Duplicate variable conversion called: " + conversion);
        }
    }

    public Object getConverted(InboundVariable iv, Class type) {
        Conversion conversion = new Conversion(iv, type);
        return this.converted.get(conversion);
    }

    public int getParameterCount() {
        return this.paramCount;
    }

    public int getParameterCount(int callNum) {
        int count = 0;
        String prefix = "c" + callNum + "-" + "param";
        Iterator it = this.variables.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.startsWith(prefix)) continue;
            ++count;
        }
        return count;
    }

    public InboundVariable getParameter(int callNum, int index) {
        String key = "c" + callNum + "-" + "param" + index;
        return (InboundVariable)this.variables.get(key);
    }

    public Iterator getInboundVariableNames() {
        return this.variables.keySet().iterator();
    }

    protected static class Conversion {
        protected InboundVariable inboundVariable;
        protected Class type;

        protected Conversion(InboundVariable inboundVariable, Class type) {
            this.inboundVariable = inboundVariable;
            this.type = type;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Conversion)) {
                return false;
            }
            Conversion that = (Conversion)obj;
            if (!this.type.equals(that.type)) {
                return false;
            }
            return this.inboundVariable.equals(that.inboundVariable);
        }

        public int hashCode() {
            return this.inboundVariable.hashCode() + this.type.hashCode();
        }

        public String toString() {
            return "Conversion[" + this.inboundVariable + "," + this.type.getName() + "]";
        }
    }
}

