/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.MapService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.AbstractOperation;
import java.io.IOException;

public class AddInterceptorOperation
extends AbstractOperation {
    MapService mapService;
    String id;
    MapInterceptor mapInterceptor;
    String mapName;

    public AddInterceptorOperation(String id, MapInterceptor mapInterceptor, String mapName) {
        this.id = id;
        this.mapInterceptor = mapInterceptor;
        this.mapName = mapName;
    }

    public AddInterceptorOperation() {
    }

    @Override
    public void run() {
        this.mapService = (MapService)this.getService();
        this.mapService.getMapServiceContext().getMapContainer(this.mapName).addInterceptor(this.id, this.mapInterceptor);
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public Object getResponse() {
        return true;
    }

    @Override
    public void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.mapName = in.readUTF();
        this.id = in.readUTF();
        this.mapInterceptor = (MapInterceptor)in.readObject();
    }

    @Override
    public void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.mapName);
        out.writeUTF(this.id);
        out.writeObject(this.mapInterceptor);
    }

    public String toString() {
        return "AddInterceptorOperation{}";
    }
}

