/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock.client;

import com.hazelcast.client.impl.client.KeyBasedClientRequest;
import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.concurrent.lock.InternalLockNamespace;
import com.hazelcast.concurrent.lock.client.LockPortableHook;
import com.hazelcast.concurrent.lock.operations.AwaitOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.LockPermission;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;

public class AwaitRequest
extends KeyBasedClientRequest
implements Portable,
SecureRequest {
    private ObjectNamespace namespace;
    private String name;
    private long timeout;
    private long threadId;
    private String conditionId;

    public AwaitRequest() {
    }

    public AwaitRequest(ObjectNamespace namespace, String name, long timeout, long threadId, String conditionId) {
        this.namespace = namespace;
        this.name = name;
        this.timeout = timeout;
        this.threadId = threadId;
        this.conditionId = conditionId;
    }

    @Override
    protected Object getKey() {
        return this.name;
    }

    @Override
    protected Operation prepareOperation() {
        Data key = this.serializationService.toData(this.name);
        return new AwaitOperation(this.namespace, key, this.threadId, this.timeout, this.conditionId);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:lockService";
    }

    @Override
    public int getFactoryId() {
        return LockPortableHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 8;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeLong("tout", this.timeout);
        writer.writeLong("tid", this.threadId);
        writer.writeUTF("cid", this.conditionId);
        ObjectDataOutput out = writer.getRawDataOutput();
        this.namespace.writeData(out);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.timeout = reader.readLong("tout");
        this.threadId = reader.readLong("tid");
        this.conditionId = reader.readUTF("cid");
        ObjectDataInput in = reader.getRawDataInput();
        this.namespace = new InternalLockNamespace();
        this.namespace.readData(in);
    }

    @Override
    public Permission getRequiredPermission() {
        return new LockPermission(this.namespace.getObjectName(), "lock");
    }
}

