/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.ft;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.DefaultTransferredFileFactory;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.TransferredFile;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.TransferredFileImpl;

public class DefaultTransferredFileFactoryTest
extends TestCase {
    private DefaultTransferredFileFactory factory;

    public void testDirectChild() throws IOException {
        TransferredFile file = this.factory.getTransferredFileFromRoot(new File("x" + File.separator + "y"), new File("x"), null);
        DefaultTransferredFileFactoryTest.assertEquals((String)"y", (String)file.getTransferredName());
    }

    public void testDirectChildWithFolderName() throws IOException {
        TransferredFile file = this.factory.getTransferredFileFromRoot(new File("x" + File.separator + "y"), new File("x"), "d/c");
        DefaultTransferredFileFactoryTest.assertEquals((String)"d/c/y", (String)file.getTransferredName());
    }

    public void testDirectChildWithFolderNameTrailingSlash() throws IOException {
        TransferredFile file = this.factory.getTransferredFileFromRoot(new File("x" + File.separator + "y"), new File("x"), "d/c/");
        DefaultTransferredFileFactoryTest.assertEquals((String)"d/c/y", (String)file.getTransferredName());
    }

    public void testSecondChild() throws IOException {
        TransferredFile file = this.factory.getTransferredFileFromRoot(new File("x" + File.separator + "y" + File.separator + "z"), new File("x"), null);
        DefaultTransferredFileFactoryTest.assertEquals((String)("y" + File.separator + "z"), (String)file.getTransferredName());
    }

    public void testNotChild() throws IOException {
        this.assertFails(new File("z"), new File("x"));
    }

    private void assertFails(File file, File root) throws IOException {
        try {
            TransferredFile tfile = this.factory.getTransferredFileFromRoot(file, root, null);
            DefaultTransferredFileFactoryTest.fail((String)("Should fail, but got name " + tfile.getTransferredName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testFileIsRoot() throws IOException {
        this.assertFails(new File("x"), new File("x"));
    }

    protected void setUp() throws Exception {
        this.factory = new DefaultTransferredFileFactory(){

            protected TransferredFileImpl createInitialTransferredFile(File file, String name) throws IOException {
                return new TransferredFileImpl(null, 0L, file, name, 0L){};
            }
        };
    }
}

