/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snac;

import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;

public final class MutableSnacPacket {
    private int family;
    private int command;
    private long reqid;
    private short flag1;
    private short flag2;
    private ByteBlock data;
    private boolean changed = false;

    public MutableSnacPacket(SnacPacket snacPacket) {
        DefensiveTools.checkNull(snacPacket, "packet");
        this.family = snacPacket.getFamily();
        this.command = snacPacket.getCommand();
        this.reqid = snacPacket.getReqid();
        this.flag1 = snacPacket.getFlag1();
        this.flag2 = snacPacket.getFlag2();
        this.data = snacPacket.getData();
    }

    public final int getFamily() {
        return this.family;
    }

    public final int getCommand() {
        return this.command;
    }

    public final long getReqid() {
        return this.reqid;
    }

    public final short getFlag1() {
        return this.flag1;
    }

    public final short getFlag2() {
        return this.flag2;
    }

    public final ByteBlock getData() {
        return this.data;
    }

    public void setFamily(int n) {
        DefensiveTools.checkRange(n, "family", 0);
        if (!this.changed) {
            this.changed = n != this.family;
        }
        this.family = n;
    }

    public void setCommand(int n) {
        DefensiveTools.checkRange(n, "command", 0);
        if (!this.changed) {
            this.changed = n != this.command;
        }
        this.command = n;
    }

    public void setReqid(long l) {
        DefensiveTools.checkRange(l, "reqid", 0);
        if (!this.changed) {
            this.changed = l != this.reqid;
        }
        this.reqid = l;
    }

    public void setFlag1(short s) {
        DefensiveTools.checkRange(s, "flag1", 0);
        if (!this.changed) {
            this.changed = s != this.flag1;
        }
        this.flag1 = s;
    }

    public void setFlag2(short s) {
        DefensiveTools.checkRange(s, "flag2", 0);
        if (!this.changed) {
            this.changed = s != this.flag2;
        }
        this.flag2 = s;
    }

    public void setData(ByteBlock byteBlock) {
        DefensiveTools.checkNull(byteBlock, "data");
        if (!this.changed) {
            this.changed = byteBlock != this.data;
        }
        this.data = byteBlock;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public SnacPacket toSnacPacket() {
        return new SnacPacket(this.family, this.command, this.reqid, this.flag1, this.flag2, this.data);
    }

    public String toString() {
        return "MutableSnacPacket type 0x" + Integer.toHexString(this.family) + "/0x" + Integer.toHexString(this.command) + (this.flag1 == 0 ? "" : ", flag1=0x" + Integer.toHexString(this.flag1)) + (this.flag2 == 0 ? "" : ", flag2=0x" + Integer.toHexString(this.flag2)) + ": " + (this.data == null ? null : this.data.getLength() + " bytes") + " (id=" + this.reqid + ")";
    }
}

