/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.HostPort;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.LogWriter;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.SIPMessageStack;
import gov.nist.javax.sip.stack.TLSMessageChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;

public class TLSMessageProcessor
extends MessageProcessor {
    protected Thread thread;
    protected int port;
    protected int nConnections;
    private boolean isRunning;
    private Hashtable tlsMessageChannels;
    private SSLServerSocket sock;
    protected int useCount = 0;
    protected SIPMessageStack sipStack;

    protected TLSMessageProcessor(SIPMessageStack sipStack, int port) {
        this.sipStack = sipStack;
        this.port = port;
        this.tlsMessageChannels = new Hashtable();
    }

    public void start() throws IOException {
        this.thread = new Thread(this);
        this.thread.setName("TLSMessageProcessorThread");
        this.thread.setDaemon(true);
        this.sock = this.sipStack.getNetworkLayer().createSSLServerSocket(this.port, 0, this.sipStack.savedStackInetAddress);
        this.isRunning = true;
        this.thread.start();
    }

    public Thread getThread() {
        return this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.isRunning) {
            try {
                TLSMessageProcessor tLSMessageProcessor = this;
                synchronized (tLSMessageProcessor) {
                    while (this.isRunning && this.sipStack.maxConnections != -1 && this.nConnections >= this.sipStack.maxConnections) {
                        try {
                            this.wait();
                            if (this.isRunning) continue;
                            return;
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                            break;
                        }
                    }
                    ++this.nConnections;
                }
                SSLSocket newsock = (SSLSocket)this.sock.accept();
                if (LogWriter.needsLogging) {
                    this.getSIPStack().logWriter.logMessage("Accepting new connection!");
                }
                TLSMessageChannel tLSMessageChannel = new TLSMessageChannel(newsock, this.sipStack, this);
            }
            catch (SocketException ex) {
                this.isRunning = false;
            }
            catch (IOException ex) {
                if (!LogWriter.needsLogging) continue;
                this.getSIPStack().logWriter.logException(ex);
            }
            catch (Exception ex) {
                InternalErrorHandler.handleException(ex);
            }
        }
    }

    public String getTransport() {
        return "tls";
    }

    public int getPort() {
        return this.port;
    }

    public SIPMessageStack getSIPStack() {
        return this.sipStack;
    }

    public synchronized void stop() {
        this.isRunning = false;
        this.listeningPoint = null;
        try {
            this.sock.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Collection en = this.tlsMessageChannels.values();
        Iterator it = en.iterator();
        while (it.hasNext()) {
            TLSMessageChannel next = (TLSMessageChannel)it.next();
            next.close();
        }
        this.notify();
    }

    protected synchronized void remove(TLSMessageChannel tlsMessageChannel) {
        String key = tlsMessageChannel.getKey();
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage(Thread.currentThread() + " removing " + key);
        }
        if (this.tlsMessageChannels.get(key) == tlsMessageChannel) {
            this.tlsMessageChannels.remove(key);
        }
    }

    public synchronized MessageChannel createMessageChannel(HostPort targetHostPort) throws IOException {
        String key = MessageChannel.getKey(targetHostPort, "TLS");
        if (this.tlsMessageChannels.get(key) != null) {
            return (TLSMessageChannel)this.tlsMessageChannels.get(key);
        }
        TLSMessageChannel retval = new TLSMessageChannel(targetHostPort.getInetAddress(), targetHostPort.getPort(), this.sipStack, this);
        this.tlsMessageChannels.put(key, retval);
        retval.isCached = true;
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("key " + key);
            this.sipStack.logWriter.logMessage("Creating " + retval);
        }
        return retval;
    }

    protected synchronized void cacheMessageChannel(TLSMessageChannel messageChannel) {
        String key = messageChannel.getKey();
        TLSMessageChannel currentChannel = (TLSMessageChannel)this.tlsMessageChannels.get(key);
        if (currentChannel != null) {
            if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logMessage("Closing " + key);
            }
            currentChannel.close();
        }
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("Caching " + key);
        }
        this.tlsMessageChannels.put(key, messageChannel);
    }

    public synchronized MessageChannel createMessageChannel(InetAddress host, int port) throws IOException {
        try {
            String key = MessageChannel.getKey(host, port, "TLS");
            if (this.tlsMessageChannels.get(key) != null) {
                return (TLSMessageChannel)this.tlsMessageChannels.get(key);
            }
            TLSMessageChannel retval = new TLSMessageChannel(host, port, this.sipStack, this);
            this.tlsMessageChannels.put(key, retval);
            retval.isCached = true;
            if (LogWriter.needsLogging) {
                this.sipStack.logMessage("key " + key);
                this.sipStack.logMessage("Creating " + retval);
            }
            return retval;
        }
        catch (UnknownHostException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public int getMaximumMessageSize() {
        return Integer.MAX_VALUE;
    }

    public String getNAPTRService() {
        return "SIPS+D2T";
    }

    public String getSRVPrefix() {
        return "_sip._tls.";
    }

    public boolean inUse() {
        return this.useCount != 0;
    }

    public int getDefaultTargetPort() {
        return 5061;
    }

    public boolean isSecure() {
        return true;
    }
}

