/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.HostPort;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.LogWriter;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.SIPMessageStack;
import gov.nist.javax.sip.stack.UDPMessageChannel;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.LinkedList;

public class UDPMessageProcessor
extends MessageProcessor {
    private int port;
    private int mappedPort;
    protected LinkedList messageQueue;
    protected LinkedList messageChannels;
    protected int threadPoolSize;
    protected static final int MAX_DATAGRAM_SIZE = 8192;
    protected SIPMessageStack sipStack;
    protected Thread thread;
    public DatagramSocket sock;
    protected boolean isRunning;

    protected UDPMessageProcessor(SIPMessageStack sipStack, int port) throws IOException {
        this.sipStack = sipStack;
        this.messageQueue = new LinkedList();
        this.port = port;
        this.mappedPort = port;
        try {
            this.sock = sipStack.getNetworkLayer().createDatagramSocket(port, sipStack.stackInetAddress);
            this.sock.setReceiveBufferSize(8192);
        }
        catch (SocketException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public Thread getThread() {
        return this.thread;
    }

    public int getPort() {
        return this.mappedPort;
    }

    public void start() throws IOException {
        if (this.sipStack.stunServerAddress != null) {
            try {
                String stunServer = this.sipStack.stunServerAddress;
                Class<?> stunAddressClass = Class.forName("net.java.stun4j.StunAddress");
                Class[] parm = new Class[]{String.class, Integer.TYPE};
                Constructor<?> cons = stunAddressClass.getConstructor(parm);
                Object[] ca = new Object[]{this.sipStack.stunServerAddress, new Integer(this.sipStack.stunServerPort)};
                Object stunAddress = cons.newInstance(ca);
                Class<?> sadClass = Class.forName("net.java.stun4j.client.SimpleAddressDetector");
                Class[] parms = new Class[]{stunAddressClass};
                cons = sadClass.getConstructor(parms);
                Object[] cargs = new Object[]{stunAddress};
                Object simpleAddressDetector = cons.newInstance(cargs);
                Method meth = sadClass.getMethod("start", null);
                meth.invoke(simpleAddressDetector, null);
                Class[] parms1 = new Class[]{DatagramSocket.class};
                meth = sadClass.getMethod("getMappingFor", parms1);
                Object[] args = new Object[]{this.sock};
                stunAddress = meth.invoke(simpleAddressDetector, args);
                meth = stunAddressClass.getMethod("getHostName", null);
                String hostName = (String)meth.invoke(stunAddress, null);
                meth = stunAddressClass.getMethod("getPort", null);
                Character port = (Character)meth.invoke(stunAddress, null);
                this.mappedPort = port.charValue();
                this.sipStack.setHostAddress(hostName);
            }
            catch (Throwable ex) {
                if (LogWriter.needsLogging) {
                    this.sipStack.getLogWriter().logMessage("Stun initializationFailed");
                    this.sipStack.getLogWriter().logException(ex);
                }
                System.out.println("Stun stack initialization failed!");
            }
        }
        this.isRunning = true;
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.thread.setName("UDPMessageProcessorThread");
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.messageChannels = new LinkedList();
        if (this.sipStack.threadPoolSize != -1) {
            for (int i = 0; i < this.sipStack.threadPoolSize; ++i) {
                UDPMessageChannel channel = new UDPMessageChannel(this.sipStack, this);
                this.messageChannels.add(channel);
            }
        }
        while (this.isRunning) {
            try {
                int bufsize = this.sock.getReceiveBufferSize();
                byte[] message = new byte[bufsize];
                DatagramPacket packet = new DatagramPacket(message, bufsize);
                this.sock.receive(packet);
                if (this.sipStack.threadPoolSize != -1) {
                    LinkedList linkedList = this.messageQueue;
                    synchronized (linkedList) {
                        this.messageQueue.addLast(packet);
                        this.messageQueue.notify();
                        continue;
                    }
                }
                new UDPMessageChannel(this.sipStack, this, packet);
            }
            catch (SocketException ex) {
                if (LogWriter.needsLogging) {
                    this.getSIPStack().logWriter.logMessage("UDPMessageProcessor: Stopping");
                }
                this.isRunning = false;
                LinkedList linkedList = this.messageQueue;
                synchronized (linkedList) {
                    this.messageQueue.notifyAll();
                }
            }
            catch (IOException ex) {
                this.isRunning = false;
                ex.printStackTrace();
                if (!LogWriter.needsLogging) continue;
                this.getSIPStack().logWriter.logMessage("UDPMessageProcessor: Got an IO Exception");
            }
            catch (Exception ex) {
                if (LogWriter.needsLogging) {
                    this.getSIPStack().logWriter.logMessage("UDPMessageProcessor: Unexpected Exception - quitting");
                }
                InternalErrorHandler.handleException(ex);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LinkedList linkedList = this.messageQueue;
        synchronized (linkedList) {
            this.isRunning = false;
            this.messageQueue.notifyAll();
            this.listeningPoint = null;
            this.sock.close();
        }
    }

    public String getTransport() {
        return "udp";
    }

    public SIPMessageStack getSIPStack() {
        return this.sipStack;
    }

    public MessageChannel createMessageChannel(HostPort targetHostPort) throws UnknownHostException {
        return new UDPMessageChannel(targetHostPort.getInetAddress(), targetHostPort.getPort(), this.sipStack, this);
    }

    public MessageChannel createMessageChannel(InetAddress host, int port) throws IOException {
        return new UDPMessageChannel(host, port, this.sipStack, this);
    }

    public int getDefaultTargetPort() {
        return 5060;
    }

    public boolean isSecure() {
        return false;
    }

    public int getMaximumMessageSize() {
        return 8192;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inUse() {
        LinkedList linkedList = this.messageQueue;
        synchronized (linkedList) {
            return this.messageQueue.size() != 0;
        }
    }
}

