/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml;

import net.sf.jml.MsnProtocol;

public final class MsnClientId {
    private int id;
    private static final int RUNNING_ON_MOBILE_DEVICE = 1;
    private static final int SUPPORT_GIF_INK_MESSAGE = 4;
    private static final int SUPPORT_ISF_INK_MESSAGE = 8;
    private static final int SUPPORT_VIDEO_CONVERSATION = 16;
    private static final int SUPPORT_MULTI_PACKET_MESSAGE = 32;
    private static final int RUNNING_ON_MSN_MOBILE_DEVICE = 64;
    private static final int RUNNING_ON_MSN_DIRECT_DEVICE = 128;
    private static final int RUNNING_ON_WEB = 512;
    private static final int SUPPORT_DIRECT_IM = 16384;
    private static final int SUPPORT_WINKS = 32768;
    private static final int SUPPORT_MSN_SEARCH = 65536;
    private static final int SUPPORT_RECEIVE_VOICE_CLIP = 262144;
    private static final int SUPPORT_PROTOCOL = 0x10000000;
    public static final int SUPPORT_UP_TO_MSNC0 = 0;
    public static final int SUPPORT_UP_TO_MSNC1 = 1;
    public static final int SUPPORT_UP_TO_MSNC2 = 2;
    public static final int SUPPORT_UP_TO_MSNC3 = 3;
    public static final int SUPPORT_UP_TO_MSNC4 = 4;
    public static final int SUPPORT_UP_TO_MSNC5 = 5;

    public static MsnClientId getDefaultSupportedClientId(MsnProtocol msnProtocol) {
        MsnClientId msnClientId = new MsnClientId(0);
        msnClientId.setRunningOnMobileDevice(false);
        msnClientId.setSupportGifInkMessage(true);
        msnClientId.setSupportIsfInkMessage(true);
        msnClientId.setSupportVideoConversation(false);
        msnClientId.setSupportMultiPacketMessage(true);
        msnClientId.setRunningOnMsnMobileDevice(false);
        msnClientId.setRunningOnMsnDirectDevice(false);
        msnClientId.setRunningOnWeb(false);
        msnClientId.setSupportDirectIM(false);
        msnClientId.setSupportMsnSearch(false);
        if (msnProtocol == MsnProtocol.MSNP8) {
            msnClientId.setSupportedClientProtocol(0);
        } else if (msnProtocol == MsnProtocol.MSNP9) {
            msnClientId.setSupportedClientProtocol(1);
        } else if (msnProtocol == MsnProtocol.MSNP10) {
            msnClientId.setSupportedClientProtocol(1);
        } else if (msnProtocol.after(MsnProtocol.MSNP10)) {
            msnClientId.setSupportedClientProtocol(5);
            msnClientId.setSupportWinks(true);
            msnClientId.setSupportReceiveVoiceClip(true);
        }
        return msnClientId;
    }

    public static MsnClientId parseInt(int n) {
        return new MsnClientId(n);
    }

    private MsnClientId(int n) {
        this.setId(n);
    }

    public int getId() {
        return this.id;
    }

    private void setId(int n) {
        this.id = n;
    }

    private boolean isSupportSomeFlag(int n) {
        return (this.id & n) != 0;
    }

    private void setSupportSomeFlag(int n, boolean bl) {
        this.id = bl ? (this.id |= n) : (this.id &= ~n);
    }

    public int getSupportedClientProtocol() {
        return this.id / 0x10000000;
    }

    private void setSupportedClientProtocol(int n) {
        this.id = this.id % 0x10000000 + 0x10000000 * n;
    }

    public boolean isRunningOnMobileDevice() {
        return this.isSupportSomeFlag(1);
    }

    private void setRunningOnMobileDevice(boolean bl) {
        this.setSupportSomeFlag(1, bl);
    }

    public boolean isSupportGifInkMessage() {
        return this.isSupportSomeFlag(4);
    }

    private void setSupportGifInkMessage(boolean bl) {
        this.setSupportSomeFlag(4, bl);
    }

    public boolean isSupportIsfInkMessage() {
        return this.isSupportSomeFlag(8);
    }

    private void setSupportIsfInkMessage(boolean bl) {
        this.setSupportSomeFlag(8, bl);
    }

    public boolean isSupportVideoConversation() {
        return this.isSupportSomeFlag(16);
    }

    private void setSupportVideoConversation(boolean bl) {
        this.setSupportSomeFlag(16, bl);
    }

    public boolean isSupportMultiPacketMessage() {
        return this.isSupportSomeFlag(32);
    }

    private void setSupportMultiPacketMessage(boolean bl) {
        this.setSupportSomeFlag(32, bl);
    }

    public boolean getRunningOnMsnMobileDevice() {
        return this.isSupportSomeFlag(64);
    }

    private void setRunningOnMsnMobileDevice(boolean bl) {
        this.setSupportSomeFlag(64, bl);
    }

    public boolean getRunningOnMsnDirectDevice() {
        return this.isSupportSomeFlag(128);
    }

    private void setRunningOnMsnDirectDevice(boolean bl) {
        this.setSupportSomeFlag(128, bl);
    }

    public boolean isRunningOnWeb() {
        return this.isSupportSomeFlag(512);
    }

    private void setRunningOnWeb(boolean bl) {
        this.setSupportSomeFlag(512, bl);
    }

    public boolean isSupportDirectIM() {
        return this.isSupportSomeFlag(16384);
    }

    private void setSupportDirectIM(boolean bl) {
        this.setSupportSomeFlag(16384, bl);
    }

    public boolean isSupportWinks() {
        return this.isSupportSomeFlag(32768);
    }

    private void setSupportWinks(boolean bl) {
        this.setSupportSomeFlag(32768, bl);
    }

    public boolean isSupportMsnSearch() {
        return this.isSupportSomeFlag(65536);
    }

    private void setSupportMsnSearch(boolean bl) {
        this.setSupportSomeFlag(65536, bl);
    }

    public boolean isSupportReceiveVoiceClip() {
        return this.isSupportSomeFlag(262144);
    }

    private void setSupportReceiveVoiceClip(boolean bl) {
        this.setSupportSomeFlag(262144, bl);
    }

    public String toString() {
        return String.valueOf(this.id);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MsnClientId)) {
            return false;
        }
        MsnClientId msnClientId = (MsnClientId)object;
        return msnClientId.id == this.id;
    }

    public int hashCode() {
        return 31 * this.id;
    }
}

