/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cindy.util;

import net.sf.cindy.util.Utils;

public final class ElapsedTime {
    private static final boolean SUPPORT_NANO_TIME = !Utils.isJdk14();
    private long startTime = SUPPORT_NANO_TIME ? System.nanoTime() : System.currentTimeMillis();

    public long getElapsedTime() {
        if (SUPPORT_NANO_TIME) {
            return (long)((double)(System.nanoTime() - this.startTime) / 1000000.0);
        }
        long l = System.currentTimeMillis();
        if (l > this.startTime) {
            return l - this.startTime;
        }
        return 0L;
    }

    public long reset() {
        long l;
        long l2;
        if (SUPPORT_NANO_TIME) {
            l2 = System.nanoTime();
            l = (long)((double)(l2 - this.startTime) / 1000000.0);
        } else {
            l2 = System.currentTimeMillis();
            l = l2 > this.startTime ? l2 - this.startTime : 0L;
        }
        this.startTime = l2;
        return l;
    }
}

