/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.rest;

import java.io.IOException;
import java.util.List;
import java.util.Random;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import org.eclipse.jetty.server.Request;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.videobridge.SctpConnection;
import org.jitsi.videobridge.Videobridge;

public class Health {
    private static final MediaType[] MEDIA_TYPES = new MediaType[]{MediaType.AUDIO, MediaType.VIDEO};
    private static Random RANDOM = Videobridge.RANDOM;

    private static void check(Conference conference) throws Exception {
        Endpoint[] endpoints = new Endpoint[2];
        for (int i = 0; i < endpoints.length; ++i) {
            Endpoint endpoint = conference.getOrCreateEndpoint(Health.generateEndpointID());
            if (endpoint == null) {
                throw new NullPointerException();
            }
            endpoints[i] = endpoint;
            String channelBundleId = null;
            Boolean initiator = i % 2 == 0;
            for (MediaType mediaType : MEDIA_TYPES) {
                Content content = conference.getOrCreateContent(mediaType.toString());
                RtpChannel rtpChannel = content.createRtpChannel(channelBundleId, null, initiator);
                if (rtpChannel == null) {
                    throw new NullPointerException();
                }
                SctpConnection sctpConnection = content.createSctpConnection(endpoint, RANDOM.nextInt(), channelBundleId, initiator);
                if (sctpConnection != null) continue;
                throw new NullPointerException();
            }
        }
        Health.interconnect(endpoints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void check(Videobridge videobridge) throws Exception {
        Conference conference = videobridge.createConference(null);
        if (conference == null) {
            throw new NullPointerException();
        }
        try {
            Health.check(conference);
            Object var3_2 = null;
            conference.expire();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            conference.expire();
            throw throwable;
        }
    }

    private static void connect(Endpoint a, Endpoint b) throws Exception {
        for (MediaType mediaType : MEDIA_TYPES) {
            List<RtpChannel> bRtpChannels;
            List<RtpChannel> aRtpChannels = a.getChannels(mediaType);
            int count = aRtpChannels.size();
            if (count != (bRtpChannels = b.getChannels(mediaType)).size()) {
                throw new IllegalStateException("Endpoint#getChannels(MediaType)");
            }
            for (int i = 0; i < count; ++i) {
                Health.connect(aRtpChannels.get(i), bRtpChannels.get(i));
            }
        }
        SctpConnection aSctpConnection = a.getSctpConnection();
        if (aSctpConnection == null) {
            throw new NullPointerException();
        }
        SctpConnection bSctpConnection = b.getSctpConnection();
        if (bSctpConnection == null) {
            throw new NullPointerException();
        }
        Health.connect(aSctpConnection, bSctpConnection);
    }

    private static void connect(Channel a, Channel b) throws Exception {
        IceUdpTransportPacketExtension aTransport = Health.describeTransportManager(a);
        if (aTransport == null) {
            throw new NullPointerException();
        }
        IceUdpTransportPacketExtension bTransport = Health.describeTransportManager(b);
        if (bTransport == null) {
            throw new NullPointerException();
        }
        b.setTransport(aTransport);
        a.setTransport(bTransport);
    }

    private static IceUdpTransportPacketExtension describeTransportManager(Channel channel) {
        ColibriConferenceIQ.SctpConnection iq = channel instanceof SctpConnection ? new ColibriConferenceIQ.SctpConnection() : new ColibriConferenceIQ.Channel();
        channel.getTransportManager().describe((ColibriConferenceIQ.ChannelCommon)iq);
        return iq.getTransport();
    }

    private static String generateEndpointID() {
        return Long.toHexString(System.currentTimeMillis() + RANDOM.nextLong());
    }

    static void getJSON(Videobridge videobridge, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        int status;
        try {
            Health.check(videobridge);
            status = 200;
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof ServletException) {
                throw (ServletException)ex;
            }
            status = 500;
        }
        response.setStatus(status);
    }

    private static void interconnect(Endpoint[] endpoints) throws Exception {
        int i = 0;
        while (i < endpoints.length) {
            Health.connect(endpoints[i++], endpoints[i++]);
        }
    }
}

