/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jitsi.util.Logger;
import org.jitsi.videobridge.Endpoint;
import org.json.simple.JSONValue;

public class EndpointRecorder {
    private static final Logger logger = Logger.getLogger(EndpointRecorder.class);
    private final File file;
    private boolean closed;
    private final Map<String, EndpointInfo> endpoints = new HashMap<String, EndpointInfo>();

    public EndpointRecorder(String filename) throws IOException {
        this.file = new File(filename);
        if (!this.file.createNewFile()) {
            throw new IOException("File exists or cannot be created: " + this.file);
        }
        if (!this.file.canWrite()) {
            throw new IOException("Cannot write to file: " + this.file);
        }
        this.closed = false;
    }

    public void updateEndpoint(Endpoint endpoint) {
        String id = endpoint.getID();
        EndpointInfo endpointInfo = this.endpoints.get(id);
        if (endpointInfo == null) {
            endpointInfo = new EndpointInfo(endpoint);
            this.endpoints.put(id, endpointInfo);
        } else {
            endpointInfo.displayName = endpoint.getDisplayName();
        }
        this.writeEndpoints();
    }

    public void close() {
        this.writeEndpoints();
        this.closed = true;
    }

    private void writeEndpoints() {
        if (this.closed) {
            return;
        }
        try {
            FileWriter writer = new FileWriter(this.file, false);
            writer.write("[\n");
            int size = this.endpoints.size();
            int idx = 0;
            for (EndpointInfo endpointInfo : this.endpoints.values()) {
                writer.write("    ");
                writer.write(endpointInfo.getJSON());
                if (++idx != size) {
                    writer.write(",");
                }
                writer.write("\n");
            }
            writer.write("]\n");
            writer.close();
        }
        catch (IOException ioe) {
            logger.warn((Object)("Failed to write endpoints: " + ioe));
        }
    }

    private static class EndpointInfo {
        private final String id;
        String displayName;

        private EndpointInfo(Endpoint endpoint) {
            this.id = endpoint.getID();
            this.displayName = endpoint.getDisplayName();
        }

        private String getJSON() {
            return "{\"id\":\"" + JSONValue.escape((String)this.id) + "\",\"displayName\":\"" + JSONValue.escape((String)this.displayName) + "\"}";
        }
    }
}

