/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.attribute;

import java.util.Arrays;
import java.util.Random;
import org.ice4j.StunException;
import org.ice4j.attribute.Attribute;

public class ReservationTokenAttribute
extends Attribute {
    public static final String NAME = "RESERVATION-TOKEN";
    private byte[] reservationToken = new byte[8];
    private int hashCode = 0;
    private static final Random random = new Random(System.currentTimeMillis());

    protected ReservationTokenAttribute() {
        super('\"');
    }

    void decodeAttributeBody(byte[] attributeValue, char offset, char length) throws StunException {
        if (length != '\b') {
            throw new StunException("Length mismatch!");
        }
        this.reservationToken = new byte[8];
        System.arraycopy(attributeValue, offset, this.reservationToken, 0, 8);
    }

    public byte[] encode() {
        char type = this.getAttributeType();
        byte[] binValue = new byte[12];
        binValue[0] = (byte)(type >> 8);
        binValue[1] = (byte)(type & 0xFF);
        binValue[2] = 0;
        binValue[3] = 8;
        System.arraycopy(this.reservationToken, 0, binValue, 4, 8);
        return binValue;
    }

    public String getName() {
        return NAME;
    }

    public byte[] getReservationToken() {
        if (this.reservationToken == null) {
            return null;
        }
        byte[] copy = new byte[this.reservationToken.length];
        System.arraycopy(this.reservationToken, 0, copy, 0, this.reservationToken.length);
        return this.reservationToken;
    }

    public void setReservationToken(byte[] reservationToken) {
        if (reservationToken == null) {
            this.reservationToken = null;
            return;
        }
        this.reservationToken = new byte[reservationToken.length];
        System.arraycopy(reservationToken, 0, this.reservationToken, 0, reservationToken.length);
    }

    public char getDataLength() {
        return (char)this.reservationToken.length;
    }

    public static ReservationTokenAttribute createNewReservationTokenAttribute() {
        ReservationTokenAttribute token = new ReservationTokenAttribute();
        ReservationTokenAttribute.generateReservationTokenAttribute(token, 8);
        return token;
    }

    private static void generateReservationTokenAttribute(ReservationTokenAttribute token, int nb) {
        long left = System.currentTimeMillis();
        long right = random.nextLong();
        int b = nb / 2;
        for (int i = 0; i < b; ++i) {
            token.reservationToken[i] = (byte)(left >> i * 8 & 0xFFL);
            token.reservationToken[i + b] = (byte)(right >> i * 8 & 0xFFL);
        }
        token.hashCode = token.reservationToken[3] << 24 & 0xFF000000 | token.reservationToken[2] << 16 & 0xFF0000 | token.reservationToken[1] << 8 & 0xFF00 | token.reservationToken[0] & 0xFF;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ReservationTokenAttribute) || obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ReservationTokenAttribute att = (ReservationTokenAttribute)obj;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && Arrays.equals(att.reservationToken, this.reservationToken);
    }

    public String toString() {
        return ReservationTokenAttribute.toString(this.reservationToken);
    }

    public static String toString(byte[] reservationToken) {
        StringBuilder idStr = new StringBuilder();
        idStr.append("0x");
        for (int i = 0; i < reservationToken.length; ++i) {
            if ((reservationToken[i] & 0xFF) <= 15) {
                idStr.append("0");
            }
            idStr.append(Integer.toHexString(reservationToken[i] & 0xFF).toUpperCase());
        }
        return idStr.toString();
    }

    public int hashCode() {
        return this.hashCode;
    }
}

