/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.util.account;

import java.util.Iterator;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.globalstatus.GlobalStatusService;
import net.java.sip.communicator.util.ServiceUtils;
import net.java.sip.communicator.util.UtilActivator;

public class AccountStatusUtils {
    private static GlobalStatusService globalStatusService;

    public static Object getProtocolProviderLastStatus(ProtocolProviderService protocolProvider) {
        if (AccountStatusUtils.getProtocolPresenceOpSet(protocolProvider) != null) {
            return AccountStatusUtils.getLastPresenceStatus(protocolProvider);
        }
        return AccountStatusUtils.getGlobalStatusService().getLastStatusString(protocolProvider);
    }

    public static OperationSetPresence getProtocolPresenceOpSet(ProtocolProviderService protocolProvider) {
        OperationSet opSet = protocolProvider.getOperationSet(OperationSetPresence.class);
        return opSet instanceof OperationSetPresence ? (OperationSetPresence)opSet : null;
    }

    public static PresenceStatus getLastPresenceStatus(ProtocolProviderService protocolProvider) {
        if (AccountStatusUtils.getGlobalStatusService() != null) {
            return AccountStatusUtils.getGlobalStatusService().getLastPresenceStatus(protocolProvider);
        }
        return null;
    }

    public static PresenceStatus getPresenceStatus(ProtocolProviderService protocolProvider) {
        PresenceStatus status = null;
        OperationSetPresence opSet = (OperationSetPresence)protocolProvider.getOperationSet(OperationSetPresence.class);
        if (opSet != null) {
            status = opSet.getPresenceStatus();
        }
        return status;
    }

    public static PresenceStatus getOnlineStatus(ProtocolProviderService protocolProvider) {
        PresenceStatus onlineStatus = null;
        OperationSetPresence presence = (OperationSetPresence)protocolProvider.getOperationSet(OperationSetPresence.class);
        if (presence != null) {
            Iterator statusIterator = presence.getSupportedStatusSet();
            while (statusIterator.hasNext()) {
                PresenceStatus status = (PresenceStatus)statusIterator.next();
                int connectivity = status.getStatus();
                if ((onlineStatus == null || onlineStatus.getStatus() >= connectivity) && (onlineStatus != null || connectivity <= 50 || connectivity >= 80)) continue;
                onlineStatus = status;
            }
        }
        return onlineStatus;
    }

    public static PresenceStatus getOfflineStatus(ProtocolProviderService protocolProvider) {
        PresenceStatus offlineStatus = null;
        OperationSetPresence presence = (OperationSetPresence)protocolProvider.getOperationSet(OperationSetPresence.class);
        if (presence != null) {
            Iterator statusIterator = presence.getSupportedStatusSet();
            while (statusIterator.hasNext()) {
                PresenceStatus status = (PresenceStatus)statusIterator.next();
                int connectivity = status.getStatus();
                if (connectivity >= 1) continue;
                offlineStatus = status;
            }
        }
        return offlineStatus;
    }

    public String getLastStatusString(ProtocolProviderService protocolProvider) {
        return AccountStatusUtils.getGlobalStatusService().getLastStatusString(protocolProvider);
    }

    public static GlobalStatusService getGlobalStatusService() {
        if (globalStatusService == null) {
            globalStatusService = ServiceUtils.getService(UtilActivator.bundleContext, GlobalStatusService.class);
        }
        return globalStatusService;
    }
}

