/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser;

import gov.nist.javax.sip.header.StatusLine;
import gov.nist.javax.sip.parser.Lexer;
import gov.nist.javax.sip.parser.Parser;
import java.text.ParseException;

public class StatusLineParser
extends Parser {
    public StatusLineParser(String statusLine) {
        this.lexer = new Lexer("status_lineLexer", statusLine);
    }

    public StatusLineParser(Lexer lexer) {
        this.lexer = lexer;
        this.lexer.selectLexer("status_lineLexer");
    }

    protected int statusCode() throws ParseException {
        int n;
        block5: {
            String scode = this.lexer.number();
            if (debug) {
                this.dbg_enter("statusCode");
            }
            try {
                int retval;
                n = retval = Integer.parseInt(scode);
                Object var5_5 = null;
                if (!debug) break block5;
            }
            catch (NumberFormatException ex) {
                try {
                    throw new ParseException(this.lexer.getBuffer() + ":" + ex.getMessage(), this.lexer.getPtr());
                }
                catch (Throwable throwable) {
                    block6: {
                        Object var5_6 = null;
                        if (!debug) break block6;
                        this.dbg_leave("statusCode");
                    }
                    throw throwable;
                }
            }
            this.dbg_leave("statusCode");
        }
        return n;
    }

    protected String reasonPhrase() throws ParseException {
        return this.lexer.getRest().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusLine parse() throws ParseException {
        StatusLine statusLine;
        block3: {
            try {
                if (debug) {
                    this.dbg_enter("parse");
                }
                StatusLine retval = new StatusLine();
                String version = this.sipVersion();
                retval.setSipVersion(version);
                this.lexer.SPorHT();
                int scode = this.statusCode();
                retval.setStatusCode(scode);
                this.lexer.SPorHT();
                String rp = this.reasonPhrase();
                retval.setReasonPhrase(rp);
                this.lexer.SPorHT();
                statusLine = retval;
                Object var7_6 = null;
                if (!debug) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var7_7 = null;
                    if (!debug) break block4;
                    this.dbg_leave("parse");
                }
                throw throwable;
            }
            this.dbg_leave("parse");
        }
        return statusLine;
    }
}

