/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.utility;

import com.lti.utils.StringUtils;
import java.util.ArrayList;
import javax.media.Buffer;
import javax.media.Format;

public final class LoggingStringUtils {
    public static String bufferFlagsToStr(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((n & 1) != 0) {
            arrayList.add("FLAG_EOM");
        }
        if ((n & 2) != 0) {
            arrayList.add("FLAG_DISCARD");
        }
        if ((n & 4) != 0) {
            arrayList.add("FLAG_SILENCE");
        }
        if ((n & 8) != 0) {
            arrayList.add("FLAG_SID");
        }
        if ((n & 0x10) != 0) {
            arrayList.add("FLAG_KEY_FRAME");
        }
        if ((n & 0x40) != 0) {
            arrayList.add("FLAG_NO_WAIT");
        }
        if ((n & 0x60) != 0) {
            arrayList.add("FLAG_NO_SYNC");
        }
        if ((n & 0x80) != 0) {
            arrayList.add("FLAG_SYSTEM_TIME");
        }
        if ((n & 0x100) != 0) {
            arrayList.add("FLAG_RELATIVE_TIME");
        }
        if ((n & 0x200) != 0) {
            arrayList.add("FLAG_FLUSH");
        }
        if ((n & 0x400) != 0) {
            arrayList.add("FLAG_SYSTEM_MARKER");
        }
        if ((n & 0x800) != 0) {
            arrayList.add("FLAG_RTP_MARKER");
        }
        if ((n & 0x1000) != 0) {
            arrayList.add("FLAG_RTP_TIME");
        }
        if ((n & 0x2000) != 0) {
            arrayList.add("FLAG_BUF_OVERFLOWN");
        }
        if ((n & 0x4000) != 0) {
            arrayList.add("FLAG_BUF_UNDERFLOWN");
        }
        if ((n & 0x8000) != 0) {
            arrayList.add("FLAG_LIVE_DATA");
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append((String)arrayList.get(i));
        }
        return stringBuffer.toString();
    }

    public static String bufferToStr(Buffer buffer) {
        if (buffer == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(buffer);
        stringBuffer.append(" seq=" + buffer.getSequenceNumber());
        stringBuffer.append(" off=" + buffer.getOffset());
        stringBuffer.append(" len=" + buffer.getLength());
        stringBuffer.append(" flags=[" + LoggingStringUtils.bufferFlagsToStr(buffer.getFlags()) + "]");
        stringBuffer.append(" fmt=[" + buffer.getFormat() + "]");
        if (buffer.getData() != null && buffer.getData() instanceof byte[]) {
            stringBuffer.append(" data=[" + buffer.getData() + " " + StringUtils.byteArrayToHexString((byte[])buffer.getData(), buffer.getLength(), buffer.getOffset()) + "]");
        } else if (buffer.getData() != null) {
            stringBuffer.append(" data=[" + buffer.getData() + "]");
        } else {
            stringBuffer.append(" data=[null]");
        }
        return stringBuffer.toString();
    }

    public static String formatToStr(Format format) {
        return "" + format;
    }

    public static String plugInResultToStr(int n) {
        switch (n) {
            case 0: {
                return "BUFFER_PROCESSED_OK";
            }
            case 1: {
                return "BUFFER_PROCESSED_FAILED";
            }
            case 2: {
                return "INPUT_BUFFER_NOT_CONSUMED";
            }
            case 4: {
                return "OUTPUT_BUFFER_NOT_FILLED";
            }
            case 8: {
                return "PLUGIN_TERMINATED";
            }
        }
        return "" + n;
    }

    private LoggingStringUtils() {
    }
}

