/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.util.Vector;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.RemoteListener;
import javax.media.rtp.SendStreamListener;
import javax.media.rtp.SessionListener;
import javax.media.rtp.event.RTPEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.event.RemoteEvent;
import javax.media.rtp.event.SendStreamEvent;
import javax.media.rtp.event.SessionEvent;
import net.sf.fmj.media.rtp.RTPSessionMgr;
import net.sf.fmj.media.rtp.util.RTPMediaThread;

public class RTPEventHandler
extends RTPMediaThread {
    private RTPSessionMgr sm;
    private Vector<RTPEvent> eventQueue = new Vector();
    private boolean killed = false;

    public RTPEventHandler(RTPSessionMgr rTPSessionMgr) {
        super("RTPEventHandler");
        this.sm = rTPSessionMgr;
        this.useControlPriority();
        this.setDaemon(true);
        this.start();
    }

    public synchronized void close() {
        this.killed = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvents() {
        RTPEvent rTPEvent;
        RTPEventHandler rTPEventHandler = this;
        synchronized (rTPEventHandler) {
            try {
                while (this.eventQueue.size() == 0 && !this.killed) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.killed) {
                return;
            }
            rTPEvent = this.eventQueue.elementAt(0);
            this.eventQueue.removeElementAt(0);
        }
        this.processEvent(rTPEvent);
    }

    public synchronized void postEvent(RTPEvent rTPEvent) {
        this.eventQueue.addElement(rTPEvent);
        this.notifyAll();
    }

    protected void processEvent(RTPEvent rTPEvent) {
        if (rTPEvent instanceof SessionEvent) {
            for (int i = 0; i < this.sm.sessionlistener.size(); ++i) {
                SessionListener sessionListener = (SessionListener)this.sm.sessionlistener.elementAt(i);
                if (sessionListener == null) continue;
                sessionListener.update((SessionEvent)rTPEvent);
            }
            return;
        }
        if (rTPEvent instanceof RemoteEvent) {
            for (int i = 0; i < this.sm.remotelistener.size(); ++i) {
                RemoteListener remoteListener = (RemoteListener)this.sm.remotelistener.elementAt(i);
                if (remoteListener == null) continue;
                remoteListener.update((RemoteEvent)rTPEvent);
            }
            return;
        }
        if (rTPEvent instanceof ReceiveStreamEvent) {
            for (int i = 0; i < this.sm.streamlistener.size(); ++i) {
                ReceiveStreamListener receiveStreamListener = (ReceiveStreamListener)this.sm.streamlistener.elementAt(i);
                if (receiveStreamListener == null) continue;
                receiveStreamListener.update((ReceiveStreamEvent)rTPEvent);
            }
            return;
        }
        if (rTPEvent instanceof SendStreamEvent) {
            for (int i = 0; i < this.sm.sendstreamlistener.size(); ++i) {
                SendStreamListener sendStreamListener = (SendStreamListener)this.sm.sendstreamlistener.elementAt(i);
                if (sendStreamListener == null) continue;
                sendStreamListener.update((SendStreamEvent)rTPEvent);
            }
        }
    }

    public void run() {
        while (!this.killed) {
            this.dispatchEvents();
        }
    }
}

