/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.fmj.media.rtp.DefaultRTCPReportBuilderImpl;
import net.sf.fmj.media.rtp.OverallStats;
import net.sf.fmj.media.rtp.RTCPBYEPacket;
import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.RTCPRawSender;
import net.sf.fmj.media.rtp.RTCPReportBuilder;
import net.sf.fmj.media.rtp.SSRCCache;
import net.sf.fmj.media.rtp.SSRCInfo;
import net.sf.fmj.media.rtp.SendSSRCInfo;
import net.sf.fmj.media.rtp.util.UDPPacketSender;

public class RTCPTransmitter {
    private static final Logger logger = Logger.getLogger(RTCPTransmitter.class.getName());
    RTCPRawSender sender;
    OverallStats stats = null;
    public SSRCCache cache;
    RTCPReportBuilder reportBuilder;
    public SSRCInfo ssrcInfo = null;

    public RTCPTransmitter(SSRCCache sSRCCache) {
        this.cache = sSRCCache;
        this.stats = sSRCCache.sm.defaultstats;
    }

    public RTCPTransmitter(SSRCCache sSRCCache, int n, String string) throws UnknownHostException, IOException {
        this(sSRCCache, new RTCPRawSender(n, string));
    }

    public RTCPTransmitter(SSRCCache sSRCCache, int n, String string, UDPPacketSender uDPPacketSender) throws UnknownHostException, IOException {
        this(sSRCCache, new RTCPRawSender(n, string, uDPPacketSender));
    }

    public RTCPTransmitter(SSRCCache sSRCCache, RTCPRawSender rTCPRawSender) {
        this(sSRCCache);
        this.setSender(rTCPRawSender);
        this.stats = sSRCCache.sm.defaultstats;
    }

    public void bye(int n, byte[] byArray) {
        double d;
        RTCPPacket[] rTCPPacketArray;
        RTCPPacket[] rTCPPacketArray2;
        if (!this.cache.rtcpsent) {
            return;
        }
        this.cache.byestate = true;
        RTCPReportBuilder rTCPReportBuilder = this.getReportBuilder();
        try {
            rTCPPacketArray2 = rTCPReportBuilder.makeReports();
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "makeReports() crashed", exception);
            rTCPPacketArray2 = new RTCPPacket[]{};
        }
        if (rTCPPacketArray2 == null || rTCPPacketArray2.length == 0) {
            rTCPPacketArray = new RTCPPacket[1];
        } else {
            rTCPPacketArray = new RTCPPacket[rTCPPacketArray2.length + 1];
            System.arraycopy(rTCPPacketArray2, 0, rTCPPacketArray, 0, rTCPPacketArray2.length);
        }
        int[] nArray = new int[]{n};
        RTCPBYEPacket rTCPBYEPacket = new RTCPBYEPacket(nArray, byArray);
        rTCPPacketArray[rTCPPacketArray.length - 1] = rTCPBYEPacket;
        RTCPCompoundPacket rTCPCompoundPacket = new RTCPCompoundPacket(rTCPPacketArray);
        if (this.cache.aliveCount() > 50) {
            this.cache.reset(rTCPBYEPacket.length);
            d = this.cache.calcReportInterval(this.ssrcInfo.sender, false);
        } else {
            d = 0.0;
        }
        try {
            Thread.sleep((long)d);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.transmit(rTCPCompoundPacket);
        rTCPReportBuilder.reset();
    }

    public void bye(String string) {
        if (string != null) {
            this.bye(this.ssrcInfo.ssrc, string.getBytes());
        } else {
            this.bye(this.ssrcInfo.ssrc, null);
        }
    }

    public void close() {
        if (this.sender != null) {
            this.sender.closeConsumer();
        }
    }

    public RTCPRawSender getSender() {
        return this.sender;
    }

    public void report() {
        RTCPPacket[] rTCPPacketArray;
        try {
            rTCPPacketArray = this.getReportBuilder().makeReports();
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "makeReports() crashed", exception);
            rTCPPacketArray = null;
        }
        if (rTCPPacketArray != null && rTCPPacketArray.length != 0) {
            RTCPCompoundPacket rTCPCompoundPacket = new RTCPCompoundPacket(rTCPPacketArray);
            this.transmit(rTCPCompoundPacket);
        }
    }

    public void setSender(RTCPRawSender rTCPRawSender) {
        this.sender = rTCPRawSender;
    }

    public void setSSRCInfo(SSRCInfo sSRCInfo) {
        this.ssrcInfo = sSRCInfo;
    }

    protected void transmit(RTCPCompoundPacket rTCPCompoundPacket) {
        try {
            this.sender.sendTo(rTCPCompoundPacket);
        }
        catch (IOException iOException) {
            this.stats.update(6, 1);
            ++this.cache.sm.transstats.transmit_failed;
            return;
        }
        this.onRTCPCompoundPacketSent(rTCPCompoundPacket);
    }

    public void onRTCPCompoundPacketSent(RTCPCompoundPacket rTCPCompoundPacket) {
        if (this.ssrcInfo instanceof SendSSRCInfo) {
            ++((SendSSRCInfo)this.ssrcInfo).stats.total_rtcp;
            ++this.cache.sm.transstats.rtcp_sent;
        }
        this.cache.updateavgrtcpsize(rTCPCompoundPacket.length);
        if (this.cache.initial) {
            this.cache.initial = false;
        }
        if (!this.cache.rtcpsent) {
            this.cache.rtcpsent = true;
        }
    }

    public void setReportBuilder(RTCPReportBuilder rTCPReportBuilder) {
        this.reportBuilder = rTCPReportBuilder;
        if (this.reportBuilder != null) {
            try {
                this.reportBuilder.setRTCPTransmitter(this);
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "The report builder did not accept the RTCPTransmitter", exception);
            }
        }
    }

    private RTCPReportBuilder getReportBuilder() {
        if (this.reportBuilder == null) {
            this.setReportBuilder(new DefaultRTCPReportBuilderImpl());
        }
        return this.reportBuilder;
    }
}

