/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.SessionManager;
import javax.media.rtp.event.ActiveReceiveStreamEvent;
import javax.media.rtp.event.ApplicationEvent;
import javax.media.rtp.event.ByeEvent;
import javax.media.rtp.event.NewParticipantEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.event.ReceiverReportEvent;
import javax.media.rtp.event.SenderReportEvent;
import javax.media.rtp.event.StreamMappedEvent;
import javax.media.rtp.rtcp.ReceiverReport;
import javax.media.rtp.rtcp.SenderReport;
import net.sf.fmj.media.rtp.PassiveSSRCInfo;
import net.sf.fmj.media.rtp.RTCPAPPPacket;
import net.sf.fmj.media.rtp.RTCPBYEPacket;
import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.RTCPRRPacket;
import net.sf.fmj.media.rtp.RTCPRawReceiver;
import net.sf.fmj.media.rtp.RTCPReportBlock;
import net.sf.fmj.media.rtp.RTCPSDES;
import net.sf.fmj.media.rtp.RTCPSDESPacket;
import net.sf.fmj.media.rtp.RTCPSRPacket;
import net.sf.fmj.media.rtp.RTPSourceInfo;
import net.sf.fmj.media.rtp.RecvSSRCInfo;
import net.sf.fmj.media.rtp.SSRCCache;
import net.sf.fmj.media.rtp.SSRCInfo;
import net.sf.fmj.media.rtp.StreamSynch;
import net.sf.fmj.media.rtp.util.Packet;
import net.sf.fmj.media.rtp.util.PacketConsumer;
import net.sf.fmj.media.rtp.util.PacketForwarder;
import net.sf.fmj.media.rtp.util.PacketSource;
import net.sf.fmj.media.rtp.util.UDPPacket;

public class RTCPReceiver
implements PacketConsumer {
    private boolean rtcpstarted = false;
    SSRCCache cache;
    private int type = 0;

    public RTCPReceiver(SSRCCache sSRCCache) {
        this.cache = sSRCCache;
        sSRCCache.lookup(sSRCCache.ourssrc.ssrc);
    }

    public RTCPReceiver(SSRCCache sSRCCache, DatagramSocket datagramSocket, StreamSynch streamSynch) {
        this(sSRCCache, new RTCPRawReceiver(datagramSocket, sSRCCache.sm.defaultstats, streamSynch));
    }

    public RTCPReceiver(SSRCCache sSRCCache, int n, String string, StreamSynch streamSynch) throws UnknownHostException, IOException {
        this(sSRCCache, new RTCPRawReceiver(n | 1, string, sSRCCache.sm.defaultstats, streamSynch));
    }

    public RTCPReceiver(SSRCCache sSRCCache, PacketSource packetSource) {
        this(sSRCCache);
        PacketForwarder packetForwarder = new PacketForwarder(packetSource, this);
        packetForwarder.startPF();
    }

    public void closeConsumer() {
    }

    public String consumerString() {
        return "RTCP Packet Receiver/Collector";
    }

    public void sendTo(Packet packet) {
        this.sendTo((RTCPPacket)packet);
    }

    public void sendTo(RTCPPacket rTCPPacket) {
        Object object;
        int n;
        Object object2;
        Object object3;
        SSRCInfo sSRCInfo = null;
        boolean bl = this.cache.sm.isUnicast();
        if (bl) {
            object3 = ((UDPPacket)rTCPPacket.base).remoteAddress;
            if (!this.rtcpstarted) {
                this.cache.sm.startRTCPReports((InetAddress)object3);
                this.rtcpstarted = true;
                object2 = this.cache.sm.controladdress.getAddress();
                n = object2[3] & 0xFF;
                if ((n & 0xFF) == 255) {
                    this.cache.sm.addUnicastAddr(this.cache.sm.controladdress);
                } else {
                    try {
                        object = InetAddress.getLocalHost();
                    }
                    catch (UnknownHostException unknownHostException) {
                        object = null;
                    }
                    if (object != null) {
                        this.cache.sm.addUnicastAddr((InetAddress)object);
                    }
                }
            } else if (!this.cache.sm.isSenderDefaultAddr((InetAddress)object3)) {
                this.cache.sm.addUnicastAddr((InetAddress)object3);
            }
        }
        switch (rTCPPacket.type) {
            default: {
                break;
            }
            case -1: {
                object3 = (RTCPCompoundPacket)rTCPPacket;
                this.cache.updateavgrtcpsize(((RTCPCompoundPacket)object3).length);
                for (int i = 0; i < ((RTCPCompoundPacket)object3).packets.length; ++i) {
                    this.sendTo(((RTCPCompoundPacket)object3).packets[i]);
                }
                if (this.cache.sm.cleaner == null) break;
                this.cache.sm.cleaner.setClean();
                break;
            }
            case 200: {
                object2 = (RTCPSRPacket)rTCPPacket;
                this.type = 1;
                sSRCInfo = rTCPPacket.base instanceof UDPPacket ? this.cache.get(((RTCPSRPacket)object2).ssrc, ((UDPPacket)rTCPPacket.base).remoteAddress, ((UDPPacket)rTCPPacket.base).remotePort, this.type) : this.cache.get(((RTCPSRPacket)object2).ssrc, null, 0, this.type);
                if (sSRCInfo == null) break;
                sSRCInfo.setAlive(true);
                sSRCInfo.lastSRntptimestamp = (((RTCPSRPacket)object2).ntptimestampmsw << 32) + ((RTCPSRPacket)object2).ntptimestamplsw;
                sSRCInfo.lastSRrtptimestamp = ((RTCPSRPacket)object2).rtptimestamp;
                sSRCInfo.lastSRreceiptTime = ((RTCPSRPacket)object2).receiptTime;
                sSRCInfo.lastRTCPreceiptTime = ((RTCPSRPacket)object2).receiptTime;
                sSRCInfo.lastHeardFrom = ((RTCPSRPacket)object2).receiptTime;
                if (sSRCInfo.quiet) {
                    sSRCInfo.quiet = false;
                    ActiveReceiveStreamEvent activeReceiveStreamEvent = new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, sSRCInfo.sourceInfo, sSRCInfo instanceof ReceiveStream ? (ReceiveStream)((Object)sSRCInfo) : null);
                    this.cache.eventhandler.postEvent(activeReceiveStreamEvent);
                }
                sSRCInfo.lastSRpacketcount = ((RTCPSRPacket)object2).packetcount;
                sSRCInfo.lastSRoctetcount = ((RTCPSRPacket)object2).octetcount;
                for (n = 0; n < ((RTCPSRPacket)object2).reports.length; ++n) {
                    ((RTCPSRPacket)object2).reports[n].receiptTime = ((RTCPSRPacket)object2).receiptTime;
                    int n2 = ((RTCPSRPacket)object2).reports[n].ssrc;
                    RTCPReportBlock[] rTCPReportBlockArray = sSRCInfo.reports.get(n2);
                    if (rTCPReportBlockArray == null) {
                        rTCPReportBlockArray = new RTCPReportBlock[2];
                        rTCPReportBlockArray[0] = ((RTCPSRPacket)object2).reports[n];
                        sSRCInfo.reports.put(n2, rTCPReportBlockArray);
                        continue;
                    }
                    rTCPReportBlockArray[1] = rTCPReportBlockArray[0];
                    rTCPReportBlockArray[0] = ((RTCPSRPacket)object2).reports[n];
                }
                if (sSRCInfo.probation > 0) break;
                if (!sSRCInfo.newpartsent && sSRCInfo.sourceInfo != null) {
                    NewParticipantEvent newParticipantEvent = new NewParticipantEvent(this.cache.sm, sSRCInfo.sourceInfo);
                    this.cache.eventhandler.postEvent(newParticipantEvent);
                    sSRCInfo.newpartsent = true;
                }
                if (!sSRCInfo.recvstrmap && sSRCInfo.sourceInfo != null) {
                    sSRCInfo.recvstrmap = true;
                    StreamMappedEvent streamMappedEvent = new StreamMappedEvent(this.cache.sm, (ReceiveStream)((Object)sSRCInfo), sSRCInfo.sourceInfo);
                    this.cache.eventhandler.postEvent(streamMappedEvent);
                }
                SenderReportEvent senderReportEvent = new SenderReportEvent(this.cache.sm, (SenderReport)((Object)sSRCInfo));
                this.cache.eventhandler.postEvent(senderReportEvent);
                break;
            }
            case 201: {
                object = (RTCPRRPacket)rTCPPacket;
                this.type = 2;
                sSRCInfo = rTCPPacket.base instanceof UDPPacket ? this.cache.get(((RTCPRRPacket)object).ssrc, ((UDPPacket)rTCPPacket.base).remoteAddress, ((UDPPacket)rTCPPacket.base).remotePort, this.type) : this.cache.get(((RTCPRRPacket)object).ssrc, null, 0, this.type);
                if (sSRCInfo == null) break;
                sSRCInfo.setAlive(true);
                sSRCInfo.lastRTCPreceiptTime = ((RTCPRRPacket)object).receiptTime;
                sSRCInfo.lastHeardFrom = ((RTCPRRPacket)object).receiptTime;
                if (sSRCInfo.quiet) {
                    sSRCInfo.quiet = false;
                    ActiveReceiveStreamEvent activeReceiveStreamEvent = null;
                    activeReceiveStreamEvent = sSRCInfo instanceof ReceiveStream ? new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, sSRCInfo.sourceInfo, (ReceiveStream)((Object)sSRCInfo)) : new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, sSRCInfo.sourceInfo, null);
                    this.cache.eventhandler.postEvent(activeReceiveStreamEvent);
                }
                for (int i = 0; i < ((RTCPRRPacket)object).reports.length; ++i) {
                    ((RTCPRRPacket)object).reports[i].receiptTime = ((RTCPRRPacket)object).receiptTime;
                    int n3 = ((RTCPRRPacket)object).reports[i].ssrc;
                    RTCPReportBlock[] rTCPReportBlockArray = sSRCInfo.reports.get(n3);
                    if (rTCPReportBlockArray == null) {
                        rTCPReportBlockArray = new RTCPReportBlock[2];
                        rTCPReportBlockArray[0] = ((RTCPRRPacket)object).reports[i];
                        sSRCInfo.reports.put(n3, rTCPReportBlockArray);
                        continue;
                    }
                    rTCPReportBlockArray[1] = rTCPReportBlockArray[0];
                    rTCPReportBlockArray[0] = ((RTCPRRPacket)object).reports[i];
                }
                if (!sSRCInfo.newpartsent && sSRCInfo.sourceInfo != null) {
                    NewParticipantEvent newParticipantEvent = new NewParticipantEvent(this.cache.sm, sSRCInfo.sourceInfo);
                    this.cache.eventhandler.postEvent(newParticipantEvent);
                    sSRCInfo.newpartsent = true;
                }
                ReceiverReportEvent receiverReportEvent = new ReceiverReportEvent(this.cache.sm, (ReceiverReport)((Object)sSRCInfo));
                this.cache.eventhandler.postEvent(receiverReportEvent);
                break;
            }
            case 202: {
                RTCPSDESPacket rTCPSDESPacket = (RTCPSDESPacket)rTCPPacket;
                for (int i = 0; i < rTCPSDESPacket.sdes.length; ++i) {
                    RTCPSDES rTCPSDES = rTCPSDESPacket.sdes[i];
                    if (this.type == 1 || this.type == 2) {
                        sSRCInfo = rTCPPacket.base instanceof UDPPacket ? this.cache.get(rTCPSDES.ssrc, ((UDPPacket)rTCPPacket.base).remoteAddress, ((UDPPacket)rTCPPacket.base).remotePort, this.type) : this.cache.get(rTCPSDES.ssrc, null, 0, this.type);
                    }
                    if (sSRCInfo == null) break;
                    sSRCInfo.setAlive(true);
                    sSRCInfo.lastHeardFrom = rTCPSDESPacket.receiptTime;
                    sSRCInfo.addSDESInfo(rTCPSDES);
                }
                if (sSRCInfo != null && !sSRCInfo.newpartsent && sSRCInfo.sourceInfo != null) {
                    NewParticipantEvent newParticipantEvent = new NewParticipantEvent(this.cache.sm, sSRCInfo.sourceInfo);
                    this.cache.eventhandler.postEvent(newParticipantEvent);
                    sSRCInfo.newpartsent = true;
                }
                if (sSRCInfo != null && !sSRCInfo.recvstrmap && sSRCInfo.sourceInfo != null && sSRCInfo instanceof RecvSSRCInfo) {
                    sSRCInfo.recvstrmap = true;
                    StreamMappedEvent streamMappedEvent = new StreamMappedEvent(this.cache.sm, (ReceiveStream)((Object)sSRCInfo), sSRCInfo.sourceInfo);
                    this.cache.eventhandler.postEvent(streamMappedEvent);
                }
                this.type = 0;
                break;
            }
            case 203: {
                boolean bl2;
                RTCPBYEPacket rTCPBYEPacket = (RTCPBYEPacket)rTCPPacket;
                SSRCInfo sSRCInfo2 = rTCPPacket.base instanceof UDPPacket ? this.cache.get(rTCPBYEPacket.ssrc[0], ((UDPPacket)rTCPPacket.base).remoteAddress, ((UDPPacket)rTCPPacket.base).remotePort) : this.cache.get(rTCPBYEPacket.ssrc[0], null, 0);
                for (bl2 = false; bl2 < rTCPBYEPacket.ssrc.length && (sSRCInfo2 = rTCPPacket.base instanceof UDPPacket ? this.cache.get(rTCPBYEPacket.ssrc[bl2], ((UDPPacket)rTCPPacket.base).remoteAddress, ((UDPPacket)rTCPPacket.base).remotePort) : this.cache.get(rTCPBYEPacket.ssrc[bl2], null, 0)) != null; bl2 += 1) {
                    if (this.cache.byestate) continue;
                    sSRCInfo2.setAlive(false);
                    sSRCInfo2.byeReceived = true;
                    sSRCInfo2.byeTime = rTCPPacket.receiptTime;
                    sSRCInfo2.lastHeardFrom = rTCPBYEPacket.receiptTime;
                }
                if (sSRCInfo2 == null) break;
                if (sSRCInfo2.quiet) {
                    sSRCInfo2.quiet = false;
                    ActiveReceiveStreamEvent activeReceiveStreamEvent = new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, sSRCInfo2.sourceInfo, sSRCInfo2 instanceof ReceiveStream ? (ReceiveStream)((Object)sSRCInfo2) : null);
                    this.cache.eventhandler.postEvent(activeReceiveStreamEvent);
                }
                sSRCInfo2.byereason = new String(rTCPBYEPacket.reason);
                if (sSRCInfo2.byeReceived) break;
                bl2 = false;
                RTPSourceInfo rTPSourceInfo = sSRCInfo2.sourceInfo;
                if (rTPSourceInfo != null && rTPSourceInfo.getStreamCount() == 0) {
                    bl2 = true;
                }
                ByeEvent byeEvent = null;
                if (sSRCInfo2 instanceof RecvSSRCInfo) {
                    byeEvent = new ByeEvent(this.cache.sm, sSRCInfo2.sourceInfo, (ReceiveStream)((Object)sSRCInfo2), new String(rTCPBYEPacket.reason), bl2);
                }
                if (sSRCInfo2 instanceof PassiveSSRCInfo) {
                    byeEvent = new ByeEvent(this.cache.sm, sSRCInfo2.sourceInfo, null, new String(rTCPBYEPacket.reason), bl2);
                }
                this.cache.eventhandler.postEvent(byeEvent);
                this.cache.remove(sSRCInfo2.ssrc);
                break;
            }
            case 204: {
                ReceiveStreamEvent receiveStreamEvent;
                RTCPAPPPacket rTCPAPPPacket = (RTCPAPPPacket)rTCPPacket;
                SSRCInfo sSRCInfo3 = rTCPPacket.base instanceof UDPPacket ? this.cache.get(rTCPAPPPacket.ssrc, ((UDPPacket)rTCPPacket.base).remoteAddress, ((UDPPacket)rTCPPacket.base).remotePort) : this.cache.get(rTCPAPPPacket.ssrc, null, 0);
                if (sSRCInfo3 == null) break;
                sSRCInfo3.lastHeardFrom = rTCPAPPPacket.receiptTime;
                if (sSRCInfo3.quiet) {
                    sSRCInfo3.quiet = false;
                    receiveStreamEvent = new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, sSRCInfo3.sourceInfo, sSRCInfo3 instanceof ReceiveStream ? (ReceiveStream)((Object)sSRCInfo3) : null);
                    this.cache.eventhandler.postEvent(receiveStreamEvent);
                }
                receiveStreamEvent = new ApplicationEvent(this.cache.sm, sSRCInfo3.sourceInfo, sSRCInfo3 instanceof ReceiveStream ? (ReceiveStream)((Object)sSRCInfo3) : null, rTCPAPPPacket.subtype, null, rTCPAPPPacket.data);
                this.cache.eventhandler.postEvent(receiveStreamEvent);
            }
        }
    }
}

