/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.renderer.audio;

import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.FloatControl;
import net.sf.fmj.media.AbstractGainControl;

class JavaSoundGainControl
extends AbstractGainControl {
    private final FloatControl masterGainControl;
    private final BooleanControl muteControl;
    private final float max;
    private final float min;
    private final float range;
    private final boolean gainUnitsDb;

    public JavaSoundGainControl(FloatControl floatControl, BooleanControl booleanControl) {
        this.masterGainControl = floatControl;
        this.muteControl = booleanControl;
        if (floatControl != null) {
            this.min = floatControl.getMinimum();
            this.max = floatControl.getMaximum();
            this.gainUnitsDb = floatControl.getUnits().equals("dB");
        } else {
            this.max = 0.0f;
            this.min = 0.0f;
            this.gainUnitsDb = false;
        }
        this.range = this.max - this.min;
    }

    public float getDB() {
        if (this.masterGainControl == null) {
            return 0.0f;
        }
        if (this.gainUnitsDb) {
            return this.masterGainControl.getValue();
        }
        return JavaSoundGainControl.levelToDb(this.getLevel());
    }

    public float getLevel() {
        if (this.masterGainControl == null) {
            return 0.0f;
        }
        if (this.gainUnitsDb) {
            return JavaSoundGainControl.dBToLevel(this.masterGainControl.getValue());
        }
        float f = this.masterGainControl.getValue();
        return (f - this.min) / this.range;
    }

    public boolean getMute() {
        if (this.muteControl == null) {
            return false;
        }
        return this.muteControl.getValue();
    }

    public float setDB(float f) {
        if (this.masterGainControl == null) {
            return 0.0f;
        }
        if (this.gainUnitsDb) {
            this.masterGainControl.setValue(f);
        } else {
            this.setLevel(JavaSoundGainControl.dBToLevel(f));
        }
        float f2 = this.getDB();
        this.notifyListenersGainChangeEvent();
        return f2;
    }

    public float setLevel(float f) {
        if (this.masterGainControl == null) {
            return 0.0f;
        }
        if (this.gainUnitsDb) {
            this.masterGainControl.setValue(JavaSoundGainControl.levelToDb(f));
        } else {
            f = this.min + f * this.range;
            this.masterGainControl.setValue(f);
        }
        float f2 = this.getLevel();
        this.notifyListenersGainChangeEvent();
        return f2;
    }

    public void setMute(boolean bl) {
        if (this.muteControl == null) {
            return;
        }
        this.muteControl.setValue(bl);
        this.notifyListenersGainChangeEvent();
    }
}

