/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.protocol;

import com.lti.utils.PathUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.MediaLocator;
import javax.media.Time;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.SourceCloneable;
import net.sf.fmj.media.MimeManager;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.URLUtils;

public class URLDataSource
extends PullDataSource
implements SourceCloneable {
    private static final Logger logger = LoggerSingleton.logger;
    protected URLConnection conn;
    protected boolean connected = false;
    private String contentTypeStr;
    private ContentDescriptor contentType;
    protected URLSourceStream[] sources;

    protected URLDataSource() {
    }

    public URLDataSource(URL uRL) {
        this.setLocator(new MediaLocator(uRL));
    }

    public void connect() throws IOException {
        Object object;
        URL uRL = this.getLocator().getURL();
        if (uRL.getProtocol().equals("file") && (object = URLUtils.createAbsoluteFileUrl(uRL.toExternalForm())) != null && !((String)object).toString().equals(uRL.toExternalForm())) {
            logger.warning("Changing file URL to absolute for URL.openConnection, from " + uRL.toExternalForm() + " to " + (String)object);
            uRL = new URL((String)object);
        }
        this.conn = uRL.openConnection();
        if (!uRL.getProtocol().equals("ftp") && this.conn.getURL().getProtocol().equals("ftp")) {
            logger.warning("URL.openConnection() morphed " + uRL + " to " + this.conn.getURL());
            throw new IOException("URL.openConnection() returned an FTP connection for a non-ftp url: " + uRL);
        }
        if (this.conn instanceof HttpURLConnection) {
            String string;
            String string2;
            object = (HttpURLConnection)this.conn;
            ((URLConnection)object).connect();
            int n = ((HttpURLConnection)object).getResponseCode();
            if (n < 200 || n >= 300) {
                ((HttpURLConnection)object).disconnect();
                throw new IOException("HTTP response code: " + n);
            }
            logger.finer("URL: " + uRL);
            logger.finer("Response code: " + n);
            logger.finer("Full content type: " + this.conn.getContentType());
            boolean bl = false;
            if (this.stripTrailer(this.conn.getContentType()).equals("text/plain") && (string2 = PathUtils.extractExtension(uRL.getPath())) != null && (string = MimeManager.getMimeType(string2)) != null) {
                this.contentTypeStr = ContentDescriptor.mimeTypeToPackageName(string);
                bl = true;
                logger.fine("Received content type " + this.conn.getContentType() + "; overriding based on extension, to: " + string);
            }
            if (!bl) {
                this.contentTypeStr = ContentDescriptor.mimeTypeToPackageName(this.stripTrailer(this.conn.getContentType()));
            }
        } else {
            this.conn.connect();
            this.contentTypeStr = ContentDescriptor.mimeTypeToPackageName(this.conn.getContentType());
        }
        this.contentType = new ContentDescriptor(this.contentTypeStr);
        this.sources = new URLSourceStream[1];
        this.sources[0] = new URLSourceStream();
        this.connected = true;
    }

    public DataSource createClone() {
        URLDataSource uRLDataSource;
        try {
            uRLDataSource = new URLDataSource(this.getLocator().getURL());
        }
        catch (MalformedURLException malformedURLException) {
            logger.log(Level.WARNING, "" + malformedURLException, malformedURLException);
            return null;
        }
        if (this.connected) {
            try {
                uRLDataSource.connect();
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "" + iOException, iOException);
                return null;
            }
        }
        return uRLDataSource;
    }

    public void disconnect() {
        if (!this.connected) {
            return;
        }
        if (this.conn != null && this.conn instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)this.conn;
            httpURLConnection.disconnect();
        }
        this.connected = false;
    }

    public String getContentType() {
        return this.contentTypeStr;
    }

    public Object getControl(String string) {
        return null;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Time getDuration() {
        return Time.TIME_UNKNOWN;
    }

    public PullSourceStream[] getStreams() {
        if (!this.connected) {
            throw new Error("Unconnected source.");
        }
        return this.sources;
    }

    public void start() throws IOException {
    }

    public void stop() throws IOException {
    }

    private String stripTrailer(String string) {
        int n = string.indexOf(";");
        if (n < 0) {
            return string;
        }
        String string2 = string.substring(0, n);
        return string2;
    }

    class URLSourceStream
    implements PullSourceStream {
        private boolean endOfStream = false;

        URLSourceStream() {
        }

        public boolean endOfStream() {
            return this.endOfStream;
        }

        public ContentDescriptor getContentDescriptor() {
            return URLDataSource.this.contentType;
        }

        public long getContentLength() {
            return URLDataSource.this.conn.getContentLength();
        }

        public Object getControl(String string) {
            return null;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = URLDataSource.this.conn.getInputStream().read(byArray, n, n2);
            if (n3 == -1) {
                this.endOfStream = true;
            }
            return n3;
        }

        public boolean willReadBlock() {
            try {
                return URLDataSource.this.conn.getInputStream().available() <= 0;
            }
            catch (IOException iOException) {
                return true;
            }
        }
    }
}

