/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.multiplexer.audio;

import com.lti.utils.UnsignedUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import javax.media.protocol.ContentDescriptor;
import net.sf.fmj.media.multiplexer.AbstractInputStreamMux;
import net.sf.fmj.utility.FormatArgUtils;
import net.sf.fmj.utility.LoggerSingleton;

public class CsvAudioMux
extends AbstractInputStreamMux {
    private static final Logger logger = LoggerSingleton.logger;
    private boolean headerWritten = false;
    private boolean trailerWritten = false;

    public static void audioBufferToStream(AudioFormat audioFormat, Buffer buffer, OutputStream outputStream) throws IOException {
        byte[] byArray = (byte[])buffer.getData();
        int n = audioFormat.getSampleSizeInBits() / 8;
        if (n * 8 != audioFormat.getSampleSizeInBits()) {
            throw new RuntimeException("Sample size in bytes must be divisible by 8");
        }
        int n2 = n * audioFormat.getChannels();
        int n3 = buffer.getLength() / n2;
        if (buffer.getLength() != n3 * n2) {
            throw new RuntimeException("Length of buffer not an integral number of samples");
        }
        long l = (1L << audioFormat.getSampleSizeInBits()) - 1L;
        long l2 = (1L << audioFormat.getSampleSizeInBits() - 1) - 1L;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < audioFormat.getChannels(); ++j) {
                long l3;
                int n4 = buffer.getOffset() + i * n2 + j * n;
                int n5 = CsvAudioMux.getSample(byArray, n4, n, audioFormat.getEndian());
                long l4 = UnsignedUtils.uIntToLong(n5);
                if (audioFormat.getSigned() == 0) {
                    l3 = l4;
                } else if (audioFormat.getSigned() == 1) {
                    l3 = l4 > l2 ? l4 - l - 1L : l4;
                } else {
                    throw new RuntimeException("input format signed not specified");
                }
                if (j > 0) {
                    outputStream.write(",".getBytes());
                }
                outputStream.write(("" + l3).getBytes());
            }
            outputStream.write("\n".getBytes());
        }
    }

    private static int getSample(byte[] byArray, int n, int n2, int n3) {
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5 = n3 == 1 ? i : n2 - 1 - i;
            byte by = byArray[n + n5];
            n4 <<= 8;
            n4 |= by & 0xFF;
        }
        return n4;
    }

    public CsvAudioMux() {
        super(new ContentDescriptor("audio.csv"));
    }

    public void close() {
        if (!this.trailerWritten) {
            try {
                this.outputTrailer(this.getOutputStream());
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "" + iOException, iOException);
                throw new RuntimeException(iOException);
            }
            this.trailerWritten = true;
        }
        super.close();
    }

    protected void doProcess(Buffer buffer, int n, OutputStream outputStream) throws IOException {
        if (!this.headerWritten) {
            this.outputHeader(outputStream);
            this.headerWritten = true;
        }
        if (buffer.isEOM()) {
            if (!this.trailerWritten) {
                this.outputTrailer(outputStream);
                this.trailerWritten = true;
            }
            outputStream.close();
            return;
        }
        if (buffer.isDiscard()) {
            return;
        }
        CsvAudioMux.audioBufferToStream((AudioFormat)this.inputFormats[0], buffer, outputStream);
    }

    public Format[] getSupportedInputFormats() {
        return new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)};
    }

    public void open() throws ResourceUnavailableException {
        super.open();
        if (!this.headerWritten) {
            try {
                this.outputHeader(this.getOutputStream());
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "" + iOException, iOException);
                throw new ResourceUnavailableException("" + iOException);
            }
            this.headerWritten = true;
        }
    }

    private void outputHeader(OutputStream outputStream) throws IOException {
        outputStream.write(FormatArgUtils.toString(this.inputFormats[0]).getBytes());
        outputStream.write("\n".getBytes());
    }

    private void outputTrailer(OutputStream outputStream) throws IOException {
    }

    public Format setInputFormat(Format format, int n) {
        logger.finer("setInputFormat " + format + " " + n);
        boolean bl = false;
        for (Format format2 : this.getSupportedInputFormats()) {
            if (!format.matches(format2)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            logger.warning("Input format does not match any supported input format: " + format);
            return null;
        }
        if (this.inputFormats != null) {
            this.inputFormats[n] = format;
        }
        return format;
    }
}

