/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.multiplexer;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import net.sf.fmj.media.AbstractMultiplexer;
import net.sf.fmj.media.BufferQueueInputStream;
import net.sf.fmj.media.multiplexer.StreamCopyPushDataSource;
import net.sf.fmj.utility.LoggerSingleton;

public abstract class AbstractStreamCopyMux
extends AbstractMultiplexer {
    private static final Logger logger = LoggerSingleton.logger;
    private BufferQueueInputStream[] bufferQueueInputStreams;
    private StreamCopyPushDataSource dataOutput;
    private final ContentDescriptor contentDescriptor;

    public AbstractStreamCopyMux(ContentDescriptor contentDescriptor) {
        this.contentDescriptor = contentDescriptor;
    }

    public void close() {
        logger.finer(this.getClass().getSimpleName() + " close");
        super.close();
        if (this.dataOutput != null) {
            try {
                this.dataOutput.stop();
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "" + iOException, iOException);
            }
            this.dataOutput.disconnect();
        }
    }

    protected StreamCopyPushDataSource createInputStreamPushDataSource(ContentDescriptor contentDescriptor, int n, InputStream[] inputStreamArray, Format[] formatArray) {
        return new StreamCopyPushDataSource(contentDescriptor, n, inputStreamArray, formatArray);
    }

    public DataSource getDataOutput() {
        if (this.dataOutput == null) {
            this.dataOutput = this.createInputStreamPushDataSource(this.outputContentDescriptor, this.numTracks, this.bufferQueueInputStreams, this.inputFormats);
        }
        logger.finer(this.getClass().getSimpleName() + " getDataOutput");
        return this.dataOutput;
    }

    public abstract Format[] getSupportedInputFormats();

    public ContentDescriptor[] getSupportedOutputContentDescriptors(Format[] formatArray) {
        return new ContentDescriptor[]{this.contentDescriptor};
    }

    public void open() throws ResourceUnavailableException {
        logger.finer(this.getClass().getSimpleName() + " open");
        super.open();
    }

    public int process(Buffer buffer, int n) {
        logger.finer(this.getClass().getSimpleName() + " process " + buffer + " " + n + " length " + buffer.getLength());
        if (buffer.isEOM()) {
            logger.finer("processing EOM buffer for track: " + n);
        }
        if (!this.bufferQueueInputStreams[n].put(buffer)) {
            return 2;
        }
        try {
            if (buffer.isEOM()) {
                logger.fine("EOM, waitUntilFinished...");
                if (this.dataOutput != null) {
                    this.dataOutput.waitUntilFinished();
                }
                logger.fine("EOM, finished.");
            }
            if (this.dataOutput != null) {
                this.dataOutput.notifyDataAvailable(n);
            }
            return 0;
        }
        catch (InterruptedException interruptedException) {
            logger.log(Level.WARNING, "" + interruptedException, interruptedException);
            return 1;
        }
    }

    public int setNumTracks(int n) {
        n = super.setNumTracks(n);
        this.bufferQueueInputStreams = new BufferQueueInputStream[n];
        for (int i = 0; i < n; ++i) {
            this.bufferQueueInputStreams[i] = new BufferQueueInputStream();
        }
        return n;
    }
}

