/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.datasink;

import java.util.Vector;
import javax.media.DataSink;
import javax.media.datasink.DataSinkErrorEvent;
import javax.media.datasink.DataSinkEvent;
import javax.media.datasink.DataSinkListener;
import javax.media.datasink.EndOfStreamEvent;

public abstract class BasicDataSink
implements DataSink {
    protected final Vector<DataSinkListener> listeners = new Vector(1);

    public void addDataSinkListener(DataSinkListener dataSinkListener) {
        if (dataSinkListener != null && !this.listeners.contains(dataSinkListener)) {
            this.listeners.addElement(dataSinkListener);
        }
    }

    protected void removeAllListeners() {
        this.listeners.removeAllElements();
    }

    public void removeDataSinkListener(DataSinkListener dataSinkListener) {
        if (dataSinkListener != null) {
            this.listeners.removeElement(dataSinkListener);
        }
    }

    protected final void sendDataSinkErrorEvent(String string) {
        this.sendEvent(new DataSinkErrorEvent(this, string));
    }

    protected final void sendEndofStreamEvent() {
        this.sendEvent(new EndOfStreamEvent(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendEvent(DataSinkEvent dataSinkEvent) {
        if (!this.listeners.isEmpty()) {
            Vector<DataSinkListener> vector = this.listeners;
            synchronized (vector) {
                for (DataSinkListener dataSinkListener : this.listeners) {
                    dataSinkListener.dataSinkUpdate(dataSinkEvent);
                }
            }
        }
    }
}

