/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.audio.ulaw;

public class MuLawDecoderUtil {
    private static short[] muLawToPcmMap = new short[256];

    private static short decode(byte by) {
        by = ~by;
        int n = by & 0x80;
        int n2 = (by & 0x70) >> 4;
        int n3 = by & 0xF;
        n3 |= 0x10;
        n3 <<= 1;
        ++n3;
        n3 <<= n2 + 2;
        return (short)(n == 0 ? n3 : -(n3 -= 132));
    }

    public static void muLawDecode(boolean bl, byte[] byArray, int n, int n2, byte[] byArray2) {
        if (bl) {
            MuLawDecoderUtil.muLawDecodeBigEndian(byArray, n, n2, byArray2);
        } else {
            MuLawDecoderUtil.muLawDecodeLittleEndian(byArray, n, n2, byArray2);
        }
    }

    public static short muLawDecode(byte by) {
        return muLawToPcmMap[by & 0xFF];
    }

    public static void muLawDecodeBigEndian(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3 = n2;
        for (int i = 0; i < n3; ++i) {
            byArray2[2 * i + 1] = (byte)(muLawToPcmMap[byArray[n + i] & 0xFF] & 0xFF);
            byArray2[2 * i] = (byte)(muLawToPcmMap[byArray[n + i] & 0xFF] >> 8 & 0xFF);
        }
    }

    public static void muLawDecodeLittleEndian(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3 = n2;
        for (int i = 0; i < n3; ++i) {
            byArray2[2 * i] = (byte)(muLawToPcmMap[byArray[n + i] & 0xFF] & 0xFF);
            byArray2[2 * i + 1] = (byte)(muLawToPcmMap[byArray[n + i] & 0xFF] >> 8 & 0xFF);
        }
    }

    static {
        for (int n = 0; n < muLawToPcmMap.length; n = (int)((short)(n + 1))) {
            MuLawDecoderUtil.muLawToPcmMap[n] = MuLawDecoderUtil.decode((byte)n);
        }
    }
}

