/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.audio.alaw;

public class ALawDecoderUtil {
    private static short[] aLawToPcmMap = new short[256];

    public static void aLawDecode(boolean bl, byte[] byArray, int n, int n2, byte[] byArray2) {
        if (bl) {
            ALawDecoderUtil.aLawDecodeBigEndian(byArray, n, n2, byArray2);
        } else {
            ALawDecoderUtil.aLawDecodeLittleEndian(byArray, n, n2, byArray2);
        }
    }

    public static short aLawDecode(byte by) {
        return aLawToPcmMap[by & 0xFF];
    }

    public static void aLawDecodeBigEndian(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3 = n2;
        for (int i = 0; i < n3; ++i) {
            byArray2[2 * i + 1] = (byte)(aLawToPcmMap[byArray[n + i] & 0xFF] & 0xFF);
            byArray2[2 * i] = (byte)(aLawToPcmMap[byArray[n + i] & 0xFF] >> 8);
        }
    }

    public static void aLawDecodeLittleEndian(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3 = n2;
        for (int i = 0; i < n3; ++i) {
            byArray2[2 * i] = (byte)(aLawToPcmMap[byArray[n + i] & 0xFF] & 0xFF);
            byArray2[2 * i + 1] = (byte)(aLawToPcmMap[byArray[n + i] & 0xFF] >> 8);
        }
    }

    private static short decode(byte by) {
        by = (byte)(by ^ 0xD5);
        int n = by & 0x80;
        int n2 = (by & 0x70) >> 4;
        int n3 = by & 0xF;
        n3 <<= 4;
        n3 += 8;
        if (n2 != 0) {
            n3 += 256;
        }
        if (n2 > 1) {
            n3 <<= n2 - 1;
        }
        return (short)(n == 0 ? n3 : -n3);
    }

    static {
        for (int i = 0; i < aLawToPcmMap.length; ++i) {
            ALawDecoderUtil.aLawToPcmMap[i] = ALawDecoderUtil.decode((byte)i);
        }
    }
}

