/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import net.sf.fmj.media.BasicController;
import net.sf.fmj.media.util.MediaThread;

abstract class TimedActionThread
extends MediaThread {
    protected BasicController controller;
    protected long wakeupTime;
    protected boolean aborted = false;

    TimedActionThread(BasicController basicController, long l) {
        this.controller = basicController;
        this.useControlPriority();
        this.wakeupTime = l;
    }

    public synchronized void abort() {
        this.aborted = true;
        this.notify();
    }

    protected abstract void action();

    protected abstract long getTime();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long l;
        while ((l = this.getTime()) < this.wakeupTime && !this.aborted) {
            long l2 = this.wakeupTime - l;
            if (l2 > 1000000000L) {
                l2 = 1000000000L;
            }
            TimedActionThread timedActionThread = this;
            synchronized (timedActionThread) {
                try {
                    this.wait(l2 / 1000000L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
        if (!this.aborted) {
            this.action();
        }
    }
}

