/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import com.sun.media.controls.BitRateAdapter;
import com.sun.media.controls.FrameRateAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.io.IOException;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Clock;
import javax.media.ClockStoppedException;
import javax.media.Codec;
import javax.media.Control;
import javax.media.ControllerClosedEvent;
import javax.media.Demultiplexer;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.InternalErrorEvent;
import javax.media.Manager;
import javax.media.MediaTimeSetEvent;
import javax.media.NotRealizedError;
import javax.media.Owned;
import javax.media.PlugIn;
import javax.media.Renderer;
import javax.media.RestartingEvent;
import javax.media.SizeChangeEvent;
import javax.media.StartEvent;
import javax.media.StopAtTimeEvent;
import javax.media.StopByRequestEvent;
import javax.media.StopTimeChangeEvent;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.Track;
import javax.media.control.BitRateControl;
import javax.media.control.BufferControl;
import javax.media.control.FramePositioningControl;
import javax.media.control.FrameRateControl;
import javax.media.format.AudioFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.DataSource;
import javax.media.renderer.VideoRenderer;
import javax.media.renderer.VisualContainer;
import net.sf.fmj.filtergraph.GraphNode;
import net.sf.fmj.filtergraph.SimpleGraphBuilder;
import net.sf.fmj.media.BasicClock;
import net.sf.fmj.media.BasicController;
import net.sf.fmj.media.BasicFilterModule;
import net.sf.fmj.media.BasicModule;
import net.sf.fmj.media.BasicPlayer;
import net.sf.fmj.media.BasicRendererModule;
import net.sf.fmj.media.BasicSinkModule;
import net.sf.fmj.media.BasicSourceModule;
import net.sf.fmj.media.BasicTrackControl;
import net.sf.fmj.media.InputConnector;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.Module;
import net.sf.fmj.media.ModuleListener;
import net.sf.fmj.media.OutputConnector;
import net.sf.fmj.media.StateTransistor;
import net.sf.fmj.media.control.FramePositioningAdapter;
import net.sf.fmj.media.control.ProgressControl;
import net.sf.fmj.media.control.ProgressControlAdapter;
import net.sf.fmj.media.control.StringControlAdapter;
import net.sf.fmj.media.protocol.Streamable;
import net.sf.fmj.media.renderer.audio.AudioRenderer;
import net.sf.fmj.media.util.RTPInfo;
import net.sf.fmj.media.util.Resource;

public class PlaybackEngine
extends BasicController
implements ModuleListener {
    protected BasicPlayer player;
    protected DataSource dsource;
    protected Vector modules;
    protected Vector filters;
    protected Vector sinks;
    protected Vector waitPrefetched;
    protected Vector waitStopped;
    protected Vector waitEnded;
    protected Vector waitResetted;
    protected Track[] tracks;
    protected Demultiplexer parser;
    protected BasicSinkModule masterSink = null;
    protected BasicSourceModule source;
    protected SlaveClock slaveClock;
    private boolean internalErrorOccurred = false;
    protected boolean prefetched = false;
    protected boolean started = false;
    private boolean dataPathBlocked = false;
    private boolean useMoreRenderBuffer = false;
    private boolean deallocated = false;
    public boolean prefetchEnabled = true;
    protected static boolean needSavingDB = false;
    private Time timeBeforeAbortPrefetch = null;
    private float rate = 1.0f;
    protected BitRateControl bitRateControl;
    protected FrameRateControl frameRateControl;
    protected FramePositioningControl framePositioningControl = null;
    private long latency = 0L;
    protected Container container = null;
    public static boolean TRACE_ON = false;
    protected BasicTrackControl[] trackControls = new BasicTrackControl[0];
    protected ProgressControl progressControl;
    private long realizeTime;
    private long prefetchTime;
    static String NOT_CONFIGURED_ERROR = "cannot be called before configured";
    static String NOT_REALIZED_ERROR = "cannot be called before realized";
    static String STARTED_ERROR = "cannot be called after started";
    String configError = "Failed to configure: " + this;
    String configIntError = "  The configure process is being interrupted.\n";
    String configInt2Error = "interrupted while the Processor is being configured.";
    String parseError = "failed to parse the input media.";
    protected String realizeError = "Failed to realize: " + this;
    protected String timeBaseError = "  Cannot manage the different time bases.\n";
    protected String genericProcessorError = "cannot handle the customized options set on the Processor.\nCheck the logs for full details.";
    String prefetchError = "Failed to prefetch: " + this;
    RTPInfo rtpInfo = null;
    boolean testedRTP = false;
    boolean prefetchLogged = false;
    long markedDataStartTime = 0L;
    boolean reportOnce = false;
    long lastBitRate = 0L;
    long lastStatsTime = 0L;
    static boolean USE_MASTER = true;
    static boolean USE_BACKUP = false;

    public static void setMemoryTrace(boolean bl) {
        TRACE_ON = bl;
    }

    static boolean isRawVideo(Format format) {
        return format instanceof RGBFormat || format instanceof YUVFormat;
    }

    static void profile(String string, long l) {
        Log.profile("Profile: " + string + ": " + (System.currentTimeMillis() - l) + " ms\n");
    }

    public PlaybackEngine(BasicPlayer basicPlayer) {
        long l = System.currentTimeMillis();
        this.player = basicPlayer;
        this.createProgressControl();
        this.slaveClock = new SlaveClock();
        this.setClock(this.slaveClock);
        this.stopThreadEnabled = false;
        PlaybackEngine.profile("instantiation", l);
    }

    protected synchronized void abortConfigure() {
        if (this.source != null) {
            this.source.abortRealize();
        }
    }

    protected synchronized void abortPrefetch() {
        this.timeBeforeAbortPrefetch = this.getMediaTime();
        this.doReset();
        int n = this.modules.size();
        for (int i = 0; i < n; ++i) {
            StateTransistor stateTransistor = (StateTransistor)this.modules.elementAt(i);
            stateTransistor.abortPrefetch();
        }
        this.deallocated = true;
    }

    protected synchronized void abortRealize() {
        int n = this.modules.size();
        for (int i = 0; i < n; ++i) {
            StateTransistor stateTransistor = (StateTransistor)this.modules.elementAt(i);
            stateTransistor.abortRealize();
        }
    }

    public boolean audioEnabled() {
        for (int i = 0; i < this.trackControls.length; ++i) {
            if (!this.trackControls[i].isEnabled() || !(this.trackControls[i].getOriginalFormat() instanceof AudioFormat)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bufferPrefetched(Module module) {
        if (!this.prefetchEnabled) {
            return;
        }
        if (module instanceof BasicSinkModule) {
            Vector vector = this.waitPrefetched;
            synchronized (vector) {
                if (this.waitPrefetched.contains(module)) {
                    this.waitPrefetched.removeElement(module);
                }
                if (this.waitPrefetched.isEmpty()) {
                    this.waitPrefetched.notifyAll();
                    if (!this.prefetchLogged) {
                        PlaybackEngine.profile("prefetch", this.prefetchTime);
                        this.prefetchLogged = true;
                    }
                    if (this.getState() != 600 && this.getTargetState() != 600) {
                        this.source.pause();
                    }
                    this.prefetched = true;
                }
            }
        }
    }

    protected GraphNode buildTrackFromGraph(BasicTrackControl basicTrackControl, GraphNode graphNode) {
        BasicModule basicModule = null;
        BasicModule basicModule2 = null;
        InputConnector inputConnector = null;
        OutputConnector outputConnector = null;
        boolean bl = true;
        Vector vector = new Vector(5);
        int n = 0;
        if (graphNode.plugin == null) {
            return null;
        }
        Log.setIndent(n++);
        while (graphNode != null && graphNode.plugin != null) {
            basicModule = this.createModule(graphNode, vector);
            if (basicModule == null) {
                Log.error("Internal error: buildTrackFromGraph");
                graphNode.failed = true;
                return graphNode;
            }
            if (bl) {
                if (basicModule instanceof BasicRendererModule) {
                    basicTrackControl.rendererModule = (BasicRendererModule)basicModule;
                    if (this.useMoreRenderBuffer && basicTrackControl.rendererModule.getRenderer() instanceof AudioRenderer) {
                        this.setRenderBufferSize(basicTrackControl.rendererModule.getRenderer());
                    }
                } else if (basicModule instanceof BasicFilterModule) {
                    basicTrackControl.lastOC = basicModule.getOutputConnector(null);
                    basicTrackControl.lastOC.setFormat(graphNode.output);
                }
                bl = false;
            }
            inputConnector = basicModule.getInputConnector(null);
            inputConnector.setFormat(graphNode.input);
            if (basicModule2 != null) {
                outputConnector = basicModule.getOutputConnector(null);
                inputConnector = basicModule2.getInputConnector(null);
                outputConnector.setFormat(inputConnector.getFormat());
            }
            basicModule.setController(this);
            if (!basicModule.doRealize()) {
                Log.setIndent(n--);
                graphNode.failed = true;
                return graphNode;
            }
            if (outputConnector != null && inputConnector != null) {
                this.connectModules(outputConnector, inputConnector, basicModule2);
            }
            basicModule2 = basicModule;
            graphNode = graphNode.prev;
        }
        basicModule2 = basicModule;
        do {
            basicModule2.setModuleListener(this);
            this.modules.addElement(basicModule2);
            basicTrackControl.modules.addElement(basicModule2);
            if (basicModule2 instanceof BasicFilterModule) {
                this.filters.addElement(basicModule2);
                continue;
            }
            if (!(basicModule2 instanceof BasicSinkModule)) continue;
            this.sinks.addElement(basicModule2);
        } while ((outputConnector = basicModule2.getOutputConnector(null)) != null && (inputConnector = outputConnector.getInputConnector()) != null && (basicModule2 = (BasicModule)inputConnector.getModule()) != null);
        basicTrackControl.firstOC.setFormat(basicTrackControl.getOriginalFormat());
        inputConnector = basicModule.getInputConnector(null);
        Format format = inputConnector.getFormat();
        if (format == null || !format.equals(basicTrackControl.getOriginalFormat())) {
            inputConnector.setFormat(basicTrackControl.getOriginalFormat());
        }
        this.connectModules(basicTrackControl.firstOC, inputConnector, basicModule);
        Log.setIndent(n--);
        return null;
    }

    protected void connectModules(OutputConnector outputConnector, InputConnector inputConnector, BasicModule basicModule) {
        if (basicModule instanceof BasicRendererModule) {
            outputConnector.setProtocol(inputConnector.getProtocol());
        } else {
            inputConnector.setProtocol(outputConnector.getProtocol());
        }
        outputConnector.connectTo(inputConnector, inputConnector.getFormat());
    }

    protected BasicModule createModule(GraphNode graphNode, Vector vector) {
        PlugIn plugIn;
        BasicModule basicModule = null;
        if (graphNode.plugin == null) {
            return null;
        }
        if (vector.contains(graphNode.plugin)) {
            if (graphNode.cname == null || (plugIn = SimpleGraphBuilder.createPlugIn(graphNode.cname, -1)) == null) {
                Log.write("Failed to instantiate " + graphNode.cname);
                return null;
            }
        } else {
            plugIn = graphNode.plugin;
            vector.addElement(plugIn);
        }
        if ((graphNode.type == -1 || graphNode.type == 4) && plugIn instanceof Renderer) {
            basicModule = new BasicRendererModule((Renderer)plugIn);
        } else if ((graphNode.type == -1 || graphNode.type == 2) && plugIn instanceof Codec) {
            basicModule = new BasicFilterModule((Codec)plugIn);
        }
        return basicModule;
    }

    public void createProgressControl() {
        StringControlAdapter stringControlAdapter = new StringControlAdapter();
        stringControlAdapter.setValue(" N/A");
        StringControlAdapter stringControlAdapter2 = new StringControlAdapter();
        stringControlAdapter2.setValue(" N/A");
        StringControlAdapter stringControlAdapter3 = new StringControlAdapter();
        stringControlAdapter3.setValue(" N/A");
        StringControlAdapter stringControlAdapter4 = new StringControlAdapter();
        stringControlAdapter4.setValue(" N/A");
        StringControlAdapter stringControlAdapter5 = new StringControlAdapter();
        stringControlAdapter5.setValue(" N/A");
        StringControlAdapter stringControlAdapter6 = new StringControlAdapter();
        stringControlAdapter6.setValue(" N/A");
        this.progressControl = new ProgressControlAdapter(stringControlAdapter, stringControlAdapter2, stringControlAdapter3, stringControlAdapter4, stringControlAdapter6, stringControlAdapter5);
    }

    protected Component createVisualContainer(Vector vector) {
        Boolean bl = (Boolean)Manager.getHint(3);
        if (this.container == null) {
            this.container = bl == null || bl == false ? new HeavyPanel(vector) : new LightPanel(vector);
            this.container.setLayout(new FlowLayout());
            this.container.setBackground(Color.black);
            for (int i = 0; i < vector.size(); ++i) {
                Component component = (Component)vector.elementAt(i);
                this.container.add(component);
                component.setSize(component.getPreferredSize());
            }
        }
        return this.container;
    }

    public void dataBlocked(Module module, boolean bl) {
        this.dataPathBlocked = bl;
        if (bl) {
            this.resetPrefetchedList();
            this.resetResettedList();
        }
        if (this.getTargetState() != 600) {
            return;
        }
        if (bl) {
            this.localStop();
            this.setTargetState(600);
            this.sendEvent(new RestartingEvent(this, 600, 400, 600, this.getMediaTime()));
        } else {
            this.sendEvent(new StartEvent(this, 500, 600, 600, this.getMediaTime(), this.getTimeBase().getTime()));
        }
    }

    protected synchronized void doClose() {
        if (this.modules == null) {
            if (this.source != null) {
                this.source.doClose();
            }
            return;
        }
        if (this.getState() == 600) {
            this.localStop();
        }
        if (this.getState() == 500) {
            this.doReset();
        }
        int n = this.modules.size();
        for (int i = 0; i < n; ++i) {
            StateTransistor stateTransistor = (StateTransistor)this.modules.elementAt(i);
            stateTransistor.doClose();
        }
        if (needSavingDB) {
            Resource.saveDB();
            needSavingDB = false;
        }
    }

    protected boolean doConfigure() {
        if (!this.doConfigure1()) {
            return false;
        }
        String[] stringArray = this.source.getOutputConnectorNames();
        this.trackControls = new BasicTrackControl[this.tracks.length];
        for (int i = 0; i < this.tracks.length; ++i) {
            this.trackControls[i] = new PlayerTControl(this, this.tracks[i], this.source.getOutputConnector(stringArray[i]));
        }
        return this.doConfigure2();
    }

    protected boolean doConfigure1() {
        long l = System.currentTimeMillis();
        this.modules = new Vector();
        this.filters = new Vector();
        this.sinks = new Vector();
        this.waitPrefetched = new Vector();
        this.waitStopped = new Vector();
        this.waitEnded = new Vector();
        this.waitResetted = new Vector();
        this.source.setModuleListener(this);
        this.source.setController(this);
        this.modules.addElement(this.source);
        if (!this.source.doRealize()) {
            Log.error(this.configError);
            if (this.source.errMsg != null) {
                Log.error("  " + this.source.errMsg + "\n");
            }
            this.player.processError = this.parseError;
            return false;
        }
        if (this.isInterrupted()) {
            Log.error(this.configError);
            Log.error(this.configIntError);
            this.player.processError = this.configInt2Error;
            return false;
        }
        this.parser = this.source.getDemultiplexer();
        if (this.parser == null) {
            Log.error(this.configError);
            Log.error("  Cannot obtain demultiplexer for the source.\n");
            this.player.processError = this.parseError;
            return false;
        }
        try {
            this.tracks = this.parser.getTracks();
        }
        catch (Exception exception) {
            Log.error(this.configError);
            Log.error("  Cannot obtain tracks from the demultiplexer: " + exception + "\n");
            this.player.processError = this.parseError;
            return false;
        }
        if (this.isInterrupted()) {
            Log.error(this.configError);
            Log.error(this.configIntError);
            this.player.processError = this.configInt2Error;
            return false;
        }
        PlaybackEngine.profile("parsing", l);
        return true;
    }

    protected boolean doConfigure2() {
        Track track;
        if (this.parser.isPositionable() && this.parser.isRandomAccess() && (track = FramePositioningAdapter.getMasterTrack(this.tracks)) != null) {
            this.framePositioningControl = new FramePositioningAdapter(this.player, track);
        }
        return true;
    }

    protected void doDeallocate() {
    }

    protected synchronized void doFailedPrefetch() {
        int n = this.modules.size();
        for (int i = 0; i < n; ++i) {
            StateTransistor stateTransistor = (StateTransistor)this.modules.elementAt(i);
            stateTransistor.doFailedPrefetch();
        }
        super.doFailedPrefetch();
    }

    protected synchronized void doFailedRealize() {
        int n = this.modules.size();
        for (int i = 0; i < n; ++i) {
            StateTransistor stateTransistor = (StateTransistor)this.modules.elementAt(i);
            stateTransistor.doFailedRealize();
        }
        super.doFailedRealize();
    }

    protected synchronized boolean doPrefetch() {
        if (this.prefetched) {
            return true;
        }
        return this.doPrefetch1() && this.doPrefetch2();
    }

    protected boolean doPrefetch1() {
        if (this.timeBeforeAbortPrefetch != null) {
            this.doSetMediaTime(this.timeBeforeAbortPrefetch);
            this.timeBeforeAbortPrefetch = null;
        }
        this.prefetchTime = System.currentTimeMillis();
        this.resetPrefetchedList();
        if (!this.source.doPrefetch()) {
            Log.error(this.prefetchError);
            if (this.dsource != null) {
                Log.error("  Cannot prefetch the source: " + this.dsource.getLocator() + "\n");
            }
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < this.trackControls.length; ++i) {
            boolean bl2 = this.trackControls[i].prefetchFailed;
            if (bl2 && this.getState() > 400) continue;
            if (this.trackControls[i].prefetchTrack()) {
                bl = true;
                if (!bl2) continue;
                if (!this.manageTimeBases()) {
                    Log.error(this.prefetchError);
                    Log.error(this.timeBaseError);
                    return false;
                }
                this.doSetMediaTime(this.getMediaTime());
                continue;
            }
            this.trackControls[i].prError();
            if (this.trackControls[i].isTimeBase() && !this.manageTimeBases()) {
                Log.error(this.prefetchError);
                Log.error(this.timeBaseError);
                this.player.processError = this.timeBaseError;
                return false;
            }
            if (!(this.trackControls[i].getFormat() instanceof AudioFormat) || !this.trackControls[i].rendererFailed) continue;
            this.player.processError = "cannot open the audio device.";
        }
        if (!bl) {
            Log.error(this.prefetchError);
            return false;
        }
        this.player.processError = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doPrefetch2() {
        if (this.prefetchEnabled) {
            Vector vector = this.waitPrefetched;
            synchronized (vector) {
                this.source.doStart();
                try {
                    if (!this.waitPrefetched.isEmpty()) {
                        this.waitPrefetched.wait(3000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.prefetched = true;
        this.deallocated = false;
        return true;
    }

    protected synchronized boolean doRealize() {
        return this.doRealize1() && this.doRealize2();
    }

    protected boolean doRealize1() {
        Log.comment("Building flow graph for: " + this.dsource.getLocator() + "\n");
        this.realizeTime = System.currentTimeMillis();
        boolean bl = false;
        int n = 0;
        int n2 = this.getNumTracks();
        for (int i = 0; i < this.trackControls.length; ++i) {
            if (!this.trackControls[i].isEnabled()) continue;
            Log.setIndent(0);
            Log.comment("Building Track: " + i);
            if (this.trackControls[i].buildTrack(n, n2)) {
                bl = true;
                this.trackControls[i].setEnabled(true);
            } else {
                if (this.trackControls[i].isCustomized()) {
                    Log.error(this.realizeError);
                    this.trackControls[i].prError();
                    this.player.processError = this.genericProcessorError;
                    return false;
                }
                this.trackControls[i].setEnabled(false);
                Log.warning("Failed to handle track " + i);
                this.trackControls[i].prError();
            }
            if (this.isInterrupted()) {
                Log.error(this.realizeError);
                Log.error("  The graph building process is being interrupted.\n");
                this.player.processError = "interrupted while the player is being constructed.";
                return false;
            }
            ++n;
            Log.write("\n");
        }
        if (!bl) {
            Log.error(this.realizeError);
            this.player.processError = "input media not supported: " + this.getCodecList();
            return false;
        }
        return true;
    }

    protected boolean doRealize2() {
        if (!this.manageTimeBases()) {
            Log.error(this.realizeError);
            Log.error(this.timeBaseError);
            this.player.processError = this.timeBaseError;
            return false;
        }
        Log.comment("Here's the completed flow graph:");
        this.traceGraph(this.source);
        Log.write("\n");
        PlaybackEngine.profile("graph building", this.realizeTime);
        this.realizeTime = System.currentTimeMillis();
        this.updateFormats();
        PlaybackEngine.profile("realize, post graph building", this.realizeTime);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doReset() {
        Vector vector = this.waitResetted;
        synchronized (vector) {
            int n;
            this.resetResettedList();
            int n2 = this.modules.size();
            for (int i = n2 - 1; i >= 0; --i) {
                BasicModule basicModule = (BasicModule)this.modules.elementAt(i);
                if (basicModule.prefetchFailed()) continue;
                basicModule.reset();
            }
            n2 = this.sinks.size();
            for (n = 0; n < n2; ++n) {
                BasicSinkModule basicSinkModule = (BasicSinkModule)this.sinks.elementAt(n);
                if (basicSinkModule.prefetchFailed()) continue;
                basicSinkModule.triggerReset();
            }
            if (!this.waitResetted.isEmpty()) {
                try {
                    this.waitResetted.wait(3000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            n2 = this.sinks.size();
            for (n = 0; n < n2; ++n) {
                BasicSinkModule basicSinkModule = (BasicSinkModule)this.sinks.elementAt(n);
                if (basicSinkModule.prefetchFailed()) continue;
                basicSinkModule.doneReset();
            }
        }
        this.prefetched = false;
    }

    protected void doSetMediaTime(Time time) {
        this.slaveClock.setMediaTime(time);
        Time time2 = this.source.setPosition(time, 0);
        if (time2 == null) {
            time2 = time;
        }
        int n = this.sinks.size();
        for (int i = 0; i < n; ++i) {
            BasicSinkModule basicSinkModule = (BasicSinkModule)this.sinks.elementAt(i);
            basicSinkModule.doSetMediaTime(time);
            basicSinkModule.setPreroll(time.getNanoseconds(), time2.getNanoseconds());
        }
    }

    public synchronized float doSetRate(float f) {
        if (f <= 0.0f) {
            f = 1.0f;
        }
        if (f == this.rate) {
            return f;
        }
        f = this.masterSink == null ? this.getClock().setRate(f) : this.masterSink.doSetRate(f);
        int n = this.modules.size();
        for (int i = 0; i < n; ++i) {
            BasicModule basicModule = (BasicModule)this.modules.elementAt(i);
            if (basicModule == this.masterSink) continue;
            basicModule.doSetRate(f);
        }
        this.rate = f;
        return f;
    }

    protected synchronized void doStart() {
        if (this.started) {
            return;
        }
        this.doStart1();
        this.doStart2();
    }

    protected void doStart1() {
        if (this.dsource instanceof CaptureDevice && !this.isRTP()) {
            this.reset();
        }
        this.resetPrefetchedList();
        this.resetStoppedList();
        this.resetEndedList();
        for (int i = 0; i < this.trackControls.length; ++i) {
            if (!this.trackControls[i].isEnabled()) continue;
            this.trackControls[i].startTrack();
        }
    }

    protected void doStart2() {
        this.source.doStart();
        this.started = true;
        this.prefetched = true;
    }

    protected synchronized void doStop() {
        if (!this.started) {
            return;
        }
        this.doStop1();
        this.doStop2();
    }

    protected void doStop1() {
        this.resetPrefetchedList();
        this.source.doStop();
        for (int i = 0; i < this.trackControls.length; ++i) {
            if (!this.trackControls[i].isEnabled()) continue;
            this.trackControls[i].stopTrack();
        }
    }

    protected void doStop2() {
        if (!this.prefetchEnabled) {
            this.source.pause();
        }
        this.started = false;
    }

    protected BasicSinkModule findMasterSink() {
        for (int i = 0; i < this.trackControls.length; ++i) {
            if (!this.trackControls[i].isEnabled() || this.trackControls[i].rendererModule == null || this.trackControls[i].rendererModule.getClock() == null) continue;
            return this.trackControls[i].rendererModule;
        }
        return null;
    }

    public void formatChanged(Module module, Format format, Format format2) {
        Log.comment(module + ": input format changed: " + format2);
        if (module instanceof BasicRendererModule && format instanceof VideoFormat && format2 instanceof VideoFormat) {
            Dimension dimension = ((VideoFormat)format).getSize();
            Dimension dimension2 = ((VideoFormat)format2).getSize();
            if (!(dimension2 == null || dimension != null && dimension.equals(dimension2))) {
                this.sendEvent(new SizeChangeEvent(this, dimension2.width, dimension2.height, 1.0f));
            }
        }
    }

    public void formatChangedFailure(Module module, Format format, Format format2) {
        if (!this.internalErrorOccurred) {
            this.sendEvent(new InternalErrorEvent(this, "Internal module " + module + ": failed to handle a data format change!"));
            this.internalErrorOccurred = true;
            this.close();
        }
    }

    public void framesBehind(Module module, float f, InputConnector inputConnector) {
        OutputConnector outputConnector;
        while (inputConnector != null && (outputConnector = inputConnector.getOutputConnector()) != null && (module = outputConnector.getModule()) != null && module instanceof BasicFilterModule) {
            BasicFilterModule basicFilterModule = (BasicFilterModule)module;
            basicFilterModule.setFramesBehind(f);
            inputConnector = module.getInputConnector(null);
        }
    }

    protected long getBitRate() {
        return this.source.getBitsRead();
    }

    public String getCNAME() {
        if (this.rtpInfo == null && (this.rtpInfo = (RTPInfo)this.dsource.getControl(RTPInfo.class.getName())) == null) {
            return null;
        }
        return this.rtpInfo.getCNAME();
    }

    String getCodecList() {
        String string = "";
        for (int i = 0; i < this.trackControls.length; ++i) {
            Format format = this.trackControls[i].getOriginalFormat();
            if (format == null || format.getEncoding() == null) continue;
            string = string + format.getEncoding();
            if (format instanceof VideoFormat) {
                string = string + " video";
            } else if (format instanceof AudioFormat) {
                string = string + " audio";
            }
            if (i + 1 >= this.trackControls.length) continue;
            string = string + ", ";
        }
        return string;
    }

    public Control[] getControls() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        int n2 = this.modules == null ? 0 : this.modules.size();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            Module module = (Module)this.modules.elementAt(n);
            Object[] objectArray = module.getControls();
            if (objectArray == null) continue;
            for (int i = 0; i < objectArray.length; ++i) {
                vector.addElement(objectArray[i]);
            }
        }
        n2 = vector.size();
        if (this.videoEnabled() && this.frameRateControl == null) {
            this.frameRateControl = new FrameRateAdapter(this.player, 0.0f, 0.0f, 30.0f, false){

                public Component getControlComponent() {
                    return null;
                }

                public Object getOwner() {
                    return PlaybackEngine.this.player;
                }

                public float setFrameRate(float f) {
                    this.value = f;
                    return -1.0f;
                }
            };
        }
        if (this.bitRateControl == null) {
            this.bitRateControl = new BitRateA(0, -1, -1, false);
        }
        if (this.frameRateControl != null) {
            ++n3;
        }
        if (this.bitRateControl != null) {
            ++n3;
        }
        if (this.framePositioningControl != null) {
            ++n3;
        }
        Control[] controlArray = new Control[n2 + n3 + this.trackControls.length];
        for (n = 0; n < n2; ++n) {
            controlArray[n] = (Control)vector.elementAt(n);
        }
        if (this.bitRateControl != null) {
            controlArray[n2++] = this.bitRateControl;
        }
        if (this.frameRateControl != null) {
            controlArray[n2++] = this.frameRateControl;
        }
        if (this.framePositioningControl != null) {
            controlArray[n2++] = this.framePositioningControl;
        }
        for (n = 0; n < this.trackControls.length; ++n) {
            controlArray[n2 + n] = this.trackControls[n];
        }
        return controlArray;
    }

    public Time getDuration() {
        return this.source.getDuration();
    }

    public GainControl getGainControl() {
        return (GainControl)this.getControl("javax.media.GainControl");
    }

    public long getLatency() {
        return this.latency;
    }

    int getNumTracks() {
        int n = 0;
        for (int i = 0; i < this.trackControls.length; ++i) {
            if (!this.trackControls[i].isEnabled()) continue;
            ++n;
        }
        return n;
    }

    protected PlugIn getPlugIn(BasicModule basicModule) {
        if (basicModule instanceof BasicSourceModule) {
            return ((BasicSourceModule)basicModule).getDemultiplexer();
        }
        if (basicModule instanceof BasicFilterModule) {
            return ((BasicFilterModule)basicModule).getCodec();
        }
        if (basicModule instanceof BasicRendererModule) {
            return ((BasicRendererModule)basicModule).getRenderer();
        }
        return null;
    }

    public Time getStartLatency() {
        if (this.state == 100 || this.state == 200) {
            this.throwError(new NotRealizedError("Cannot get start latency from an unrealized controller"));
        }
        return LATENCY_UNKNOWN;
    }

    public TimeBase getTimeBase() {
        return this.getClock().getTimeBase();
    }

    public Component getVisualComponent() {
        Vector<Component> vector = new Vector<Component>(1);
        if (this.modules == null) {
            return null;
        }
        for (int i = 0; i < this.modules.size(); ++i) {
            Component component;
            BasicModule basicModule = (BasicModule)this.modules.elementAt(i);
            PlugIn plugIn = this.getPlugIn(basicModule);
            if (!(plugIn instanceof VideoRenderer) || (component = ((VideoRenderer)plugIn).getComponent()) == null) continue;
            vector.addElement(component);
        }
        if (vector.size() == 0) {
            return null;
        }
        if (vector.size() == 1) {
            return (Component)vector.elementAt(0);
        }
        return this.createVisualContainer(vector);
    }

    public void internalErrorOccurred(Module module) {
        if (!this.internalErrorOccurred) {
            this.sendEvent(new InternalErrorEvent(this, "Internal module " + module + " failed!"));
            this.internalErrorOccurred = true;
            this.close();
        }
    }

    protected boolean isConfigurable() {
        return true;
    }

    public boolean isRTP() {
        if (this.testedRTP) {
            return this.rtpInfo != null;
        }
        this.rtpInfo = (RTPInfo)this.dsource.getControl(RTPInfo.class.getName());
        this.testedRTP = true;
        return this.rtpInfo != null;
    }

    protected BasicModule lastModule(BasicModule basicModule) {
        InputConnector inputConnector;
        OutputConnector outputConnector = basicModule.getOutputConnector(null);
        while (outputConnector != null && (inputConnector = outputConnector.getInputConnector()) != null) {
            basicModule = (BasicModule)inputConnector.getModule();
            outputConnector = basicModule.getOutputConnector(null);
        }
        return basicModule;
    }

    protected synchronized void localStop() {
        super.stop();
    }

    boolean manageTimeBases() {
        this.masterSink = this.findMasterSink();
        return this.updateMasterTimeBase();
    }

    public void markedDataArrived(Module module, Buffer buffer) {
        if (module instanceof BasicSourceModule) {
            this.markedDataStartTime = this.getMediaNanoseconds();
        } else {
            long l = this.getMediaNanoseconds() - this.markedDataStartTime;
            if (l > 0L && l < 1000000000L) {
                if (!this.reportOnce) {
                    Log.comment("Computed latency for video: " + l / 1000000L + " ms\n");
                    this.reportOnce = true;
                }
                this.latency = (l + this.latency) / 2L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mediaEnded(Module module) {
        if (module instanceof BasicSinkModule) {
            Vector vector = this.waitEnded;
            synchronized (vector) {
                if (this.waitEnded.contains(module)) {
                    this.waitEnded.removeElement(module);
                }
                if (this.waitEnded.isEmpty()) {
                    this.started = false;
                    this.stopControllerOnly();
                    this.sendEvent(new EndOfMediaEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
                    this.slaveClock.reset(USE_MASTER);
                } else if (module == this.masterSink) {
                    this.slaveClock.reset(USE_BACKUP);
                }
            }
        }
    }

    public void pluginTerminated(Module module) {
        if (!this.internalErrorOccurred) {
            this.sendEvent(new ControllerClosedEvent(this));
            this.internalErrorOccurred = true;
            this.close();
        }
    }

    protected synchronized void reset() {
        if (this.started || !this.prefetched || this.dataPathBlocked) {
            return;
        }
        this.doReset();
    }

    protected void resetBitRate() {
        this.source.resetBitsRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetEndedList() {
        Vector vector = this.waitEnded;
        synchronized (vector) {
            this.waitEnded.removeAllElements();
            int n = this.sinks.size();
            for (int i = 0; i < n; ++i) {
                BasicSinkModule basicSinkModule = (BasicSinkModule)this.sinks.elementAt(i);
                if (basicSinkModule.prefetchFailed()) continue;
                this.waitEnded.addElement(basicSinkModule);
            }
            this.waitEnded.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetPrefetchedList() {
        Vector vector = this.waitPrefetched;
        synchronized (vector) {
            this.waitPrefetched.removeAllElements();
            int n = this.sinks.size();
            for (int i = 0; i < n; ++i) {
                BasicSinkModule basicSinkModule = (BasicSinkModule)this.sinks.elementAt(i);
                if (basicSinkModule.prefetchFailed()) continue;
                this.waitPrefetched.addElement(basicSinkModule);
            }
            this.waitPrefetched.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetResettedList() {
        Vector vector = this.waitResetted;
        synchronized (vector) {
            this.waitResetted.removeAllElements();
            int n = this.sinks.size();
            for (int i = 0; i < n; ++i) {
                BasicSinkModule basicSinkModule = (BasicSinkModule)this.sinks.elementAt(i);
                if (basicSinkModule.prefetchFailed()) continue;
                this.waitResetted.addElement(basicSinkModule);
            }
            this.waitResetted.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetStoppedList() {
        Vector vector = this.waitStopped;
        synchronized (vector) {
            this.waitStopped.removeAllElements();
            int n = this.sinks.size();
            for (int i = 0; i < n; ++i) {
                BasicSinkModule basicSinkModule = (BasicSinkModule)this.sinks.elementAt(i);
                if (basicSinkModule.prefetchFailed()) continue;
                this.waitStopped.addElement(basicSinkModule);
            }
            this.waitStopped.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetted(Module module) {
        Vector vector = this.waitResetted;
        synchronized (vector) {
            if (this.waitResetted.contains(module)) {
                this.waitResetted.removeElement(module);
            }
            if (this.waitResetted.isEmpty()) {
                this.waitResetted.notifyAll();
            }
        }
    }

    public synchronized void setMediaTime(Time time) {
        if (this.state < 300) {
            this.throwError(new NotRealizedError("Cannot set media time on a unrealized controller"));
        }
        if (time.getNanoseconds() == this.getMediaNanoseconds()) {
            return;
        }
        this.reset();
        this.timeBeforeAbortPrefetch = null;
        this.doSetMediaTime(time);
        this.doPrefetch();
        this.sendEvent(new MediaTimeSetEvent(this, time));
    }

    public void setProgressControl(ProgressControl progressControl) {
        this.progressControl = progressControl;
    }

    protected void setRenderBufferSize(Renderer renderer) {
        BufferControl bufferControl = (BufferControl)renderer.getControl(BufferControl.class.getName());
        if (bufferControl != null) {
            bufferControl.setBufferLength(2000L);
        }
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        try {
            this.source = BasicSourceModule.createModule(dataSource);
        }
        catch (IOException iOException) {
            Log.warning("Input DataSource: " + dataSource);
            Log.warning("  Failed with IO exception: " + iOException.getMessage());
            throw iOException;
        }
        catch (IncompatibleSourceException incompatibleSourceException) {
            Log.warning("Input DataSource: " + dataSource);
            Log.warning("  is not compatible with the MediaEngine.");
            Log.warning("  It's likely that the DataSource is required to extend PullDataSource;");
            Log.warning("  and that its source streams implement the Seekable interface ");
            Log.warning("  and with random access capability.");
            throw incompatibleSourceException;
        }
        if (this.source == null) {
            throw new IncompatibleSourceException();
        }
        this.source.setController(this);
        this.dsource = dataSource;
        if (this.dsource instanceof Streamable && !((Streamable)((Object)this.dsource)).isPrefetchable()) {
            this.prefetchEnabled = false;
            this.dataPathBlocked = true;
        }
        if (this.dsource instanceof CaptureDevice) {
            this.prefetchEnabled = false;
        }
    }

    public void setStopTime(Time time) {
        if (this.getState() < 300) {
            this.throwError(new NotRealizedError("Cannot set stop time on an unrealized controller."));
        }
        if (this.getStopTime() != null && this.getStopTime().getNanoseconds() != time.getNanoseconds()) {
            this.sendEvent(new StopTimeChangeEvent(this, time));
        }
        if (this.getState() == 600 && time != Clock.RESET && time.getNanoseconds() < this.getMediaNanoseconds()) {
            this.localStop();
            this.setStopTime(Clock.RESET);
            this.sendEvent(new StopAtTimeEvent(this, this.getState(), 500, this.getTargetState(), this.getMediaTime()));
        } else {
            this.getClock().setStopTime(time);
            int n = this.sinks.size();
            for (int i = 0; i < n; ++i) {
                BasicSinkModule basicSinkModule = (BasicSinkModule)this.sinks.elementAt(i);
                basicSinkModule.setStopTime(time);
            }
        }
    }

    public void setTimeBase(TimeBase timeBase) throws IncompatibleTimeBaseException {
        this.getClock().setTimeBase(timeBase);
        if (this.sinks == null) {
            return;
        }
        int n = this.sinks.size();
        for (int i = 0; i < n; ++i) {
            BasicSinkModule basicSinkModule = (BasicSinkModule)this.sinks.elementAt(i);
            basicSinkModule.setTimeBase(timeBase);
        }
    }

    public synchronized void stop() {
        super.stop();
        this.sendEvent(new StopByRequestEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAtTime(Module module) {
        if (module instanceof BasicSinkModule) {
            Vector vector = this.waitStopped;
            synchronized (vector) {
                if (this.waitStopped.contains(module)) {
                    this.waitStopped.removeElement(module);
                }
                if (this.waitStopped.isEmpty() || this.waitEnded.size() == 1 && this.waitEnded.contains(module)) {
                    this.started = false;
                    this.stopControllerOnly();
                    this.setStopTime(Clock.RESET);
                    this.sendEvent(new StopAtTimeEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
                    this.slaveClock.reset(USE_MASTER);
                } else if (module == this.masterSink) {
                    this.slaveClock.reset(USE_BACKUP);
                }
            }
        }
    }

    void traceGraph(BasicModule basicModule) {
        String[] stringArray = basicModule.getOutputConnectorNames();
        for (int i = 0; i < stringArray.length; ++i) {
            Module module;
            OutputConnector outputConnector = basicModule.getOutputConnector(stringArray[i]);
            InputConnector inputConnector = outputConnector.getInputConnector();
            if (inputConnector == null || (module = inputConnector.getModule()) == null) continue;
            Log.write("  " + this.getPlugIn(basicModule));
            Log.write("     connects to: " + this.getPlugIn((BasicModule)module));
            Log.write("     format: " + outputConnector.getFormat());
            this.traceGraph((BasicModule)module);
        }
    }

    public void updateFormats() {
        for (int i = 0; i < this.trackControls.length; ++i) {
            this.trackControls[i].updateFormat();
        }
    }

    boolean updateMasterTimeBase() {
        int n = this.sinks.size();
        if (this.masterSink != null) {
            this.slaveClock.setMaster(this.masterSink.getClock());
        } else {
            this.slaveClock.setMaster(null);
        }
        for (int i = 0; i < n; ++i) {
            BasicSinkModule basicSinkModule = (BasicSinkModule)this.sinks.elementAt(i);
            if (basicSinkModule == this.masterSink || basicSinkModule.prefetchFailed()) continue;
            try {
                basicSinkModule.setTimeBase(this.slaveClock.getTimeBase());
                continue;
            }
            catch (IncompatibleTimeBaseException incompatibleTimeBaseException) {
                return false;
            }
        }
        return true;
    }

    public void updateRates() {
        if (this.getState() < 300) {
            return;
        }
        long l = System.currentTimeMillis();
        long l2 = l == this.lastStatsTime ? this.lastBitRate : (long)((double)this.getBitRate() * 8.0 / (double)(l - this.lastStatsTime) * 1000.0);
        long l3 = (this.lastBitRate + l2) / 2L;
        if (this.bitRateControl != null) {
            this.bitRateControl.setBitRate((int)l3);
        }
        this.lastBitRate = l2;
        this.lastStatsTime = l;
        this.resetBitRate();
        for (int i = 0; i < this.trackControls.length; ++i) {
            this.trackControls[i].updateRates(l);
        }
        this.source.checkLatency();
    }

    public boolean videoEnabled() {
        for (int i = 0; i < this.trackControls.length; ++i) {
            if (!this.trackControls[i].isEnabled() || !(this.trackControls[i].getOriginalFormat() instanceof VideoFormat)) continue;
            return true;
        }
        return false;
    }

    class SlaveClock
    implements Clock {
        Clock master;
        Clock current;
        BasicClock backup = new BasicClock();

        SlaveClock() {
            this.current = this.backup;
        }

        public long getMediaNanoseconds() {
            return this.current.getMediaNanoseconds();
        }

        public Time getMediaTime() {
            return this.current.getMediaTime();
        }

        public float getRate() {
            return this.current.getRate();
        }

        public Time getStopTime() {
            return this.backup.getStopTime();
        }

        public Time getSyncTime() {
            return this.current.getSyncTime();
        }

        public TimeBase getTimeBase() {
            return this.current.getTimeBase();
        }

        public Time mapToTimeBase(Time time) throws ClockStoppedException {
            return this.current.mapToTimeBase(time);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reset(boolean bl) {
            if (this.master != null && bl) {
                this.current = this.master;
            } else {
                if (this.master != null) {
                    BasicClock basicClock = this.backup;
                    synchronized (basicClock) {
                        boolean bl2 = false;
                        if (this.backup.getState() == 1) {
                            this.backup.stop();
                            bl2 = true;
                        }
                        this.backup.setMediaTime(this.master.getMediaTime());
                        if (bl2) {
                            this.backup.syncStart(this.backup.getTimeBase().getTime());
                        }
                    }
                }
                this.current = this.backup;
            }
        }

        public void setMaster(Clock clock) {
            this.master = clock;
            Clock clock2 = this.current = clock == null ? this.backup : clock;
            if (clock != null) {
                try {
                    this.backup.setTimeBase(clock.getTimeBase());
                }
                catch (IncompatibleTimeBaseException incompatibleTimeBaseException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setMediaTime(Time time) {
            BasicClock basicClock = this.backup;
            synchronized (basicClock) {
                if (this.backup.getState() == 1) {
                    this.backup.stop();
                    this.backup.setMediaTime(time);
                    this.backup.syncStart(this.backup.getTimeBase().getTime());
                } else {
                    this.backup.setMediaTime(time);
                }
            }
        }

        public float setRate(float f) {
            return this.backup.setRate(f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setStopTime(Time time) {
            BasicClock basicClock = this.backup;
            synchronized (basicClock) {
                this.backup.setStopTime(time);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTimeBase(TimeBase timeBase) throws IncompatibleTimeBaseException {
            BasicClock basicClock = this.backup;
            synchronized (basicClock) {
                this.backup.setTimeBase(timeBase);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            BasicClock basicClock = this.backup;
            synchronized (basicClock) {
                this.backup.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void syncStart(Time time) {
            BasicClock basicClock = this.backup;
            synchronized (basicClock) {
                if (this.backup.getState() != 1) {
                    this.backup.syncStart(time);
                }
            }
        }
    }

    class PlayerTControl
    extends BasicTrackControl
    implements Owned {
        protected PlayerGraphBuilder gb;

        public PlayerTControl(PlaybackEngine playbackEngine2, Track track, OutputConnector outputConnector) {
            super(playbackEngine2, track, outputConnector);
        }

        public boolean buildTrack(int n, int n2) {
            if (this.gb == null) {
                this.gb = new PlayerGraphBuilder(this.engine);
            } else {
                this.gb.reset();
            }
            boolean bl = this.gb.buildGraph(this);
            this.gb = null;
            return bl;
        }

        protected FrameRateControl frameRateControl() {
            return PlaybackEngine.this.frameRateControl;
        }

        public Object getOwner() {
            return PlaybackEngine.this.player;
        }

        public boolean isTimeBase() {
            for (int i = 0; i < this.modules.size(); ++i) {
                if (this.modules.elementAt(i) != PlaybackEngine.this.masterSink) continue;
                return true;
            }
            return false;
        }

        protected ProgressControl progressControl() {
            return PlaybackEngine.this.progressControl;
        }
    }

    class PlayerGraphBuilder
    extends SimpleGraphBuilder {
        protected PlaybackEngine engine;

        PlayerGraphBuilder(PlaybackEngine playbackEngine2) {
            this.engine = playbackEngine2;
        }

        protected GraphNode buildTrackFromGraph(BasicTrackControl basicTrackControl, GraphNode graphNode) {
            return this.engine.buildTrackFromGraph(basicTrackControl, graphNode);
        }
    }

    class LightPanel
    extends Container
    implements VisualContainer {
        public LightPanel(Vector vector) {
        }
    }

    class HeavyPanel
    extends Panel
    implements VisualContainer {
        public HeavyPanel(Vector vector) {
        }
    }

    class BitRateA
    extends BitRateAdapter
    implements Owned {
        public BitRateA(int n, int n2, int n3, boolean bl) {
            super(n, n2, n3, bl);
        }

        public Component getControlComponent() {
            return null;
        }

        public Object getOwner() {
            return PlaybackEngine.this.player;
        }

        public int setBitRate(int n) {
            this.value = n;
            return this.value;
        }
    }
}

