/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import com.sun.media.util.Registry;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Log {
    public static final boolean isEnabled;
    private static int indent;
    private static Logger logger;

    public static synchronized void comment(Object object) {
        if (isEnabled && logger.isLoggable(Level.FINE)) {
            logger.fine(object != null ? object.toString() : "null");
        }
    }

    public static synchronized void info(Object object) {
        if (isEnabled && logger.isLoggable(Level.INFO)) {
            logger.info(object != null ? object.toString() : "null");
        }
    }

    public static synchronized void decrIndent() {
        --indent;
    }

    public static synchronized void dumpStack(Throwable throwable) {
        if (isEnabled && logger.isLoggable(Level.FINE)) {
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                logger.fine(stackTraceElement.toString());
            }
        }
    }

    public static synchronized void error(Object object) {
        if (isEnabled && logger.isLoggable(Level.SEVERE)) {
            logger.severe(object != null ? object.toString() : "null");
        } else {
            System.err.println(object);
        }
    }

    public static int getIndent() {
        return indent;
    }

    public static synchronized void incrIndent() {
        ++indent;
    }

    public static synchronized void profile(Object object) {
        if (isEnabled && logger.isLoggable(Level.FINER)) {
            logger.finer(object != null ? object.toString() : "null");
        }
    }

    public static synchronized void setIndent(int n) {
        indent = n;
    }

    public static synchronized void warning(Object object) {
        if (isEnabled && logger.isLoggable(Level.WARNING)) {
            logger.warning(object != null ? object.toString() : "null");
        }
    }

    public static synchronized void write(Object object) {
        if (isEnabled && logger.isLoggable(Level.FINE)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = indent; i > 0; --i) {
                stringBuilder.append("    ");
            }
            stringBuilder.append(object != null ? object.toString() : "null");
            logger.fine(stringBuilder.toString());
        }
    }

    private static synchronized void writeHeader() {
        Log.write("#\n# FMJ\n#\n");
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        try {
            string = System.getProperty("os.name");
            string3 = System.getProperty("os.arch");
            string2 = System.getProperty("os.version");
            string4 = System.getProperty("java.vendor");
            string5 = System.getProperty("java.version");
        }
        catch (Throwable throwable) {
            return;
        }
        if (string != null) {
            Log.comment("Platform: " + string + ", " + string3 + ", " + string2);
        }
        if (string4 != null) {
            Log.comment("Java VM: " + string4 + ", " + string5);
        }
        Log.write("");
    }

    static {
        indent = 0;
        logger = Logger.getLogger(Log.class.getName());
        Object object = Registry.get("allowLogging");
        boolean bl = isEnabled = object != null && object instanceof Boolean ? (Boolean)object : false;
        if (isEnabled) {
            Log.writeHeader();
        }
    }
}

