/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import javax.media.Buffer;
import javax.media.Clock;
import javax.media.Drainable;
import javax.media.Format;
import javax.media.Multiplexer;
import javax.media.Prefetchable;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.DataSource;
import net.sf.fmj.media.BasicInputConnector;
import net.sf.fmj.media.BasicSinkModule;
import net.sf.fmj.media.Connector;
import net.sf.fmj.media.InputConnector;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.PlaybackEngine;
import net.sf.fmj.media.util.ElapseTime;

public class BasicMuxModule
extends BasicSinkModule {
    protected Multiplexer multiplexer;
    protected Format[] inputs;
    protected InputConnector[] ics;
    protected boolean[] prefetchMarkers;
    protected boolean[] endMarkers;
    protected boolean[] resettedMarkers;
    protected boolean[] stopAtTimeMarkers;
    protected boolean[] paused;
    protected boolean[] prerollTrack;
    private Object[] pauseSync;
    protected ElapseTime[] elapseTime;
    protected boolean prefetching = false;
    protected boolean started = false;
    private boolean closed = false;
    private boolean failed = false;
    private Object prefetchSync = new Object();
    private float frameRate = 30.0f;
    private float lastFramesBehind = -1.0f;
    private int framesPlayed = 0;
    private VideoFormat rtpVideoFormat = null;
    private VideoFormat firstVideoFormat = null;
    public static String ConnectorNamePrefix = "input";
    private long bitsWritten = 0L;
    static AudioFormat mpegAudio = new AudioFormat("mpegaudio/rtp");

    protected BasicMuxModule(Multiplexer multiplexer, Format[] formatArray) {
        this.multiplexer = multiplexer;
        if (formatArray != null) {
            this.ics = new InputConnector[formatArray.length];
            for (int i = 0; i < formatArray.length; ++i) {
                MyInputConnector myInputConnector = new MyInputConnector();
                myInputConnector.setSize(1);
                myInputConnector.setModule(this);
                this.registerInputConnector(ConnectorNamePrefix + i, myInputConnector);
                this.ics[i] = myInputConnector;
                if (!(formatArray[i] instanceof VideoFormat) || this.firstVideoFormat != null) continue;
                this.firstVideoFormat = (VideoFormat)formatArray[i];
                String string = formatArray[i].getEncoding().toUpperCase();
                if (!string.endsWith("RTP")) continue;
                this.rtpVideoFormat = this.firstVideoFormat;
            }
            this.inputs = formatArray;
        }
        if (this.multiplexer != null && this.multiplexer instanceof Clock) {
            this.setClock((Clock)((Object)this.multiplexer));
        }
        this.setProtocol(0);
    }

    public void abortPrefetch() {
        this.prefetching = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkEnd(int n) {
        boolean[] blArray = this.endMarkers;
        synchronized (this.endMarkers) {
            this.endMarkers[n] = true;
            for (int i = 0; i < this.endMarkers.length; ++i) {
                if (this.endMarkers[i]) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkPrefetch(int n) {
        boolean[] blArray = this.prefetchMarkers;
        synchronized (this.prefetchMarkers) {
            this.prefetchMarkers[n] = true;
            for (int i = 0; i < this.prefetchMarkers.length; ++i) {
                if (this.prefetchMarkers[i]) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkResetted(int n) {
        boolean[] blArray = this.resettedMarkers;
        synchronized (this.resettedMarkers) {
            this.resettedMarkers[n] = true;
            for (int i = 0; i < this.resettedMarkers.length; ++i) {
                if (this.resettedMarkers[i]) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkStopAtTime(int n) {
        boolean[] blArray = this.stopAtTimeMarkers;
        synchronized (this.stopAtTimeMarkers) {
            this.stopAtTimeMarkers[n] = true;
            for (int i = 0; i < this.stopAtTimeMarkers.length; ++i) {
                if (this.stopAtTimeMarkers[i]) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectorPushed(InputConnector inputConnector) {
        long l;
        int n = -1;
        if (this.ics[0] == inputConnector) {
            n = 0;
        } else if (this.ics[1] == inputConnector) {
            n = 1;
        } else {
            for (int i = 2; i < this.ics.length; ++i) {
                if (this.ics[i] != inputConnector) continue;
                n = i;
                break;
            }
            if (n == -1) {
                throw new RuntimeException("BasicMuxModule: unmatched input connector!");
            }
        }
        while (true) {
            if (this.paused[n]) {
                Object object = this.pauseSync[n];
                synchronized (object) {
                    try {
                        while (this.paused[n] && !this.closed) {
                            this.pauseSync[n].wait();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (this.stopTime <= -1L || this.elapseTime[n].value < this.stopTime) break;
            this.paused[n] = true;
            if (!this.checkStopAtTime(n)) continue;
            if (this.multiplexer instanceof Drainable) {
                ((Drainable)((Object)this.multiplexer)).drain();
            }
            this.doStop();
            if (this.moduleListener == null) continue;
            this.moduleListener.stopAtTime(this);
        }
        Buffer buffer = inputConnector.getValidBuffer();
        int n2 = buffer.getFlags();
        int n3 = 0;
        if (this.resetted) {
            if ((n2 & 0x200) != 0 && this.checkResetted(n)) {
                this.resetted = false;
                this.doStop();
                if (this.moduleListener != null) {
                    this.moduleListener.resetted(this);
                }
            }
            inputConnector.readReport();
            return;
        }
        if (this.failed || this.closed || buffer.isDiscard()) {
            inputConnector.readReport();
            return;
        }
        if ((n2 & 0x400) != 0 && this.moduleListener != null) {
            this.moduleListener.markedDataArrived(this, buffer);
            buffer.setFlags(n2 &= 0xFFFFFBFF);
        }
        boolean bl = false;
        Format format = buffer.getFormat();
        if (format == null) {
            format = inputConnector.getFormat();
            buffer.setFormat(format);
        }
        if (this.elapseTime[n].update(buffer.getLength(), buffer.getTimeStamp(), format)) {
            int n4;
            if (this.prerollTrack[n]) {
                l = this.getMediaNanoseconds();
                if (this.elapseTime[n].value > l) {
                    if (format instanceof AudioFormat && "LINEAR".equals(format.getEncoding())) {
                        n4 = (int)ElapseTime.audioTimeToLen(this.elapseTime[n].value - l, (AudioFormat)format);
                        int n5 = buffer.getOffset() + buffer.getLength() - n4;
                        if (n5 >= 0) {
                            buffer.setOffset(n5);
                            buffer.setLength(n4);
                        }
                    }
                    this.prerollTrack[n] = false;
                    this.elapseTime[n].setValue(l);
                } else {
                    bl = true;
                }
            }
            if (this.stopTime > -1L && this.elapseTime[n].value > this.stopTime && format instanceof AudioFormat) {
                l = this.elapseTime[n].value - this.stopTime;
                n4 = (int)ElapseTime.audioTimeToLen(l, (AudioFormat)format);
                if (buffer.getLength() > n4) {
                    buffer.setLength(buffer.getLength() - n4);
                }
            }
        }
        if (this.moduleListener != null && format instanceof VideoFormat) {
            l = this.getMediaNanoseconds();
            long l2 = l / 1000000L - buffer.getTimeStamp() / 1000000L - this.getLatency() / 1000000L;
            float f = (float)l2 * this.frameRate / 1000.0f;
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (this.lastFramesBehind != f && (n2 & 0x20) == 0) {
                this.moduleListener.framesBehind(this, f, inputConnector);
                this.lastFramesBehind = f;
            }
        }
        do {
            if (!bl) {
                block52: {
                    try {
                        n3 = this.multiplexer.process(buffer, n);
                    }
                    catch (Throwable throwable) {
                        Log.dumpStack(throwable);
                        if (this.moduleListener == null) break block52;
                        this.moduleListener.internalErrorOccurred(this);
                    }
                }
                if (n3 == 0 && format == this.firstVideoFormat) {
                    if (format == this.rtpVideoFormat) {
                        if ((n2 & 0x800) > 0) {
                            ++this.framesPlayed;
                        }
                    } else {
                        ++this.framesPlayed;
                    }
                }
            } else {
                n3 = 0;
            }
            if ((n3 & 8) != 0) {
                this.failed = true;
                if (this.moduleListener != null) {
                    this.moduleListener.pluginTerminated(this);
                }
                inputConnector.readReport();
                return;
            }
            if (!this.prefetching || this.multiplexer instanceof Prefetchable && !((Prefetchable)((Object)this.multiplexer)).isPrefetched()) continue;
            Object object = this.prefetchSync;
            synchronized (object) {
                if (!this.started && this.prefetching && !this.resetted) {
                    this.paused[n] = true;
                }
                if (this.checkPrefetch(n)) {
                    this.prefetching = false;
                }
            }
            if (this.prefetching || this.moduleListener == null) continue;
            this.moduleListener.bufferPrefetched(this);
        } while (!this.resetted && n3 == 2);
        this.bitsWritten += (long)buffer.getLength();
        if (buffer.isEOM()) {
            if (!this.resetted) {
                this.paused[n] = true;
            }
            if (this.checkEnd(n)) {
                this.doStop();
                if (this.moduleListener != null) {
                    this.moduleListener.mediaEnded(this);
                }
            }
        }
        inputConnector.readReport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doClose() {
        this.multiplexer.close();
        this.closed = true;
        for (int i = 0; i < this.pauseSync.length; ++i) {
            Object object = this.pauseSync[i];
            synchronized (object) {
                this.pauseSync[i].notifyAll();
                continue;
            }
        }
    }

    public void doDealloc() {
    }

    public void doFailedPrefetch() {
        this.prefetching = false;
    }

    public boolean doPrefetch() {
        if (!((PlaybackEngine)this.controller).prefetchEnabled) {
            return true;
        }
        this.resetPrefetchMarkers();
        this.prefetching = true;
        this.resume();
        return true;
    }

    public boolean doRealize() {
        if (this.multiplexer == null || this.inputs == null) {
            return false;
        }
        try {
            this.multiplexer.open();
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            return false;
        }
        this.prefetchMarkers = new boolean[this.ics.length];
        this.endMarkers = new boolean[this.ics.length];
        this.resettedMarkers = new boolean[this.ics.length];
        this.stopAtTimeMarkers = new boolean[this.ics.length];
        this.paused = new boolean[this.ics.length];
        this.prerollTrack = new boolean[this.ics.length];
        this.pauseSync = new Object[this.ics.length];
        this.elapseTime = new ElapseTime[this.ics.length];
        for (int i = 0; i < this.ics.length; ++i) {
            this.prerollTrack[i] = false;
            this.pauseSync[i] = new Object();
            this.elapseTime[i] = new ElapseTime();
        }
        this.pause();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() {
        super.doStart();
        this.resetEndMarkers();
        this.resetStopAtTimeMarkers();
        this.started = true;
        Object object = this.prefetchSync;
        synchronized (object) {
            this.prefetching = false;
            this.resume();
        }
    }

    public void doStop() {
        super.doStop();
        this.started = false;
        this.resetPrefetchMarkers();
        this.prefetching = true;
    }

    public long getBitsWritten() {
        return this.bitsWritten;
    }

    public Object getControl(String string) {
        return this.multiplexer.getControl(string);
    }

    public Object[] getControls() {
        return this.multiplexer.getControls();
    }

    public DataSource getDataOutput() {
        return this.multiplexer.getDataOutput();
    }

    public int getFramesPlayed() {
        return this.framesPlayed;
    }

    public Multiplexer getMultiplexer() {
        return this.multiplexer;
    }

    public boolean isThreaded() {
        return false;
    }

    void pause() {
        for (int i = 0; i < this.paused.length; ++i) {
            this.paused[i] = true;
        }
    }

    protected void process() {
    }

    public void reset() {
        super.reset();
        this.resetResettedMarkers();
        this.prefetching = false;
    }

    public void resetBitsWritten() {
        this.bitsWritten = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetEndMarkers() {
        boolean[] blArray = this.endMarkers;
        synchronized (this.endMarkers) {
            for (int i = 0; i < this.endMarkers.length; ++i) {
                this.endMarkers[i] = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void resetFramesPlayed() {
        this.framesPlayed = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetPrefetchMarkers() {
        boolean[] blArray = this.prefetchMarkers;
        synchronized (this.prefetchMarkers) {
            for (int i = 0; i < this.prefetchMarkers.length; ++i) {
                this.prefetchMarkers[i] = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetResettedMarkers() {
        boolean[] blArray = this.resettedMarkers;
        synchronized (this.resettedMarkers) {
            for (int i = 0; i < this.resettedMarkers.length; ++i) {
                this.resettedMarkers[i] = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetStopAtTimeMarkers() {
        boolean[] blArray = this.stopAtTimeMarkers;
        synchronized (this.stopAtTimeMarkers) {
            for (int i = 0; i < this.stopAtTimeMarkers.length; ++i) {
                this.stopAtTimeMarkers[i] = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resume() {
        for (int i = 0; i < this.pauseSync.length; ++i) {
            Object object = this.pauseSync[i];
            synchronized (object) {
                this.paused[i] = false;
                this.pauseSync[i].notifyAll();
                continue;
            }
        }
    }

    public void setFormat(Connector connector, Format format) {
        float f;
        if (format instanceof VideoFormat && (f = ((VideoFormat)format).getFrameRate()) != -1.0f) {
            this.frameRate = f;
        }
    }

    public void setPreroll(long l, long l2) {
        super.setPreroll(l, l2);
        for (int i = 0; i < this.elapseTime.length; ++i) {
            this.elapseTime[i].setValue(l2);
            this.prerollTrack[i] = !(this.inputs[i] instanceof AudioFormat) || !mpegAudio.matches(this.inputs[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerReset() {
        this.multiplexer.reset();
        Object object = this.prefetchSync;
        synchronized (object) {
            this.prefetching = false;
            if (this.resetted) {
                this.resume();
            }
        }
    }

    class MyInputConnector
    extends BasicInputConnector {
        public String toString() {
            return super.toString() + ": " + this.getFormat();
        }
    }
}

