/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.gui.customslider;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import net.sf.fmj.gui.controlpanel.images.Images;
import net.sf.fmj.gui.customslider.CustomSlider;

public class CustomSliderUI
extends BasicSliderUI {
    private final ImageIcon vertIcon;
    private final ImageIcon horizIcon;
    private Dimension vertIconSize = new Dimension(20, 20);
    private Dimension horizIconSize = new Dimension(20, 20);

    public static ComponentUI createUI(JComponent jComponent) {
        return new CustomSliderUI((JSlider)jComponent);
    }

    private CustomSliderUI(JSlider jSlider) {
        super(jSlider);
        this.horizIcon = Images.get("slider_thumb_horiz.png");
        this.horizIconSize = new Dimension(this.horizIcon.getIconWidth(), this.horizIcon.getIconHeight());
        this.vertIcon = Images.get("slider_thumb_vert.png");
        this.vertIconSize = new Dimension(this.vertIcon.getIconWidth(), this.vertIcon.getIconHeight());
    }

    protected Dimension getThumbSize() {
        int n = this.slider.getOrientation();
        if (n == 0) {
            return this.horizIconSize;
        }
        return this.vertIconSize;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void paintFocus(Graphics graphics) {
        if (((CustomSlider)this.slider).getPaintFocus()) {
            super.paintFocus(graphics);
        }
    }

    public void paintThumb(Graphics graphics) {
        Image image;
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.slider.getOrientation();
        switch (n) {
            case 1: {
                image = this.vertIcon.getImage();
                break;
            }
            default: {
                image = this.horizIcon.getImage();
            }
        }
        graphics2D.drawImage(image, this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height, null);
    }

    public void paintTrack(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.LIGHT_GRAY);
        float f = this.trackRect.x;
        float f2 = this.trackRect.y;
        float f3 = this.trackRect.width;
        float f4 = this.trackRect.height;
        int n = this.slider.getOrientation();
        if (n == 0) {
            f -= (float)this.trackBuffer;
            f3 += (float)(2 * this.trackBuffer - 1);
        } else {
            f2 -= (float)this.trackBuffer;
            f4 += (float)(2 * this.trackBuffer - 1);
        }
        float f5 = 20.0f;
        float f6 = 20.0f;
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(f, f2, f3, f4, f5, f6);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.fill(float_);
        graphics2D.setColor(this.getShadowColor());
        if (n == 0) {
            float_.setFrame(f, f2, f3 - 1.0f, f4 - 1.0f);
        } else {
            float_.setFrame(f, f2, f3 - 1.0f, f4 - 1.0f);
        }
        graphics2D.draw(float_);
    }
}

