/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.media;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.CachingControl;
import javax.media.CachingControlEvent;
import javax.swing.JButton;
import javax.swing.JProgressBar;
import net.sf.fmj.ejmf.toolkit.media.AbstractController;

public class BasicCachingControl
implements CachingControl {
    private static final String PAUSEMESSAGE = "Pause";
    private static final String RESUMEMESSAGE = "Resume";
    private boolean isDownloading;
    private boolean isPaused;
    private long length;
    private long progress;
    private JProgressBar progressBar;
    private JButton pauseButton;
    private AbstractController controller;

    public BasicCachingControl(AbstractController abstractController, long l) {
        this.controller = abstractController;
        this.progressBar = new JProgressBar();
        this.progressBar.setMinimum(0);
        this.pauseButton = new JButton(PAUSEMESSAGE);
        this.pauseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = BasicCachingControl.this.pauseButton.getText();
                if (BasicCachingControl.this.isPaused()) {
                    BasicCachingControl.this.pauseButton.setText(BasicCachingControl.PAUSEMESSAGE);
                    BasicCachingControl.this.setPaused(false);
                } else {
                    BasicCachingControl.this.pauseButton.setText(BasicCachingControl.RESUMEMESSAGE);
                    BasicCachingControl.this.setPaused(true);
                }
                BasicCachingControl.this.pauseButton.getParent().validate();
            }
        });
        this.reset(l);
        this.controller.addControl(this);
    }

    public void addToProgress(long l) {
        this.setContentProgress(this.progress + l);
    }

    public synchronized void blockWhilePaused() {
        while (this.isPaused) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public long getContentLength() {
        return this.length;
    }

    public long getContentProgress() {
        return this.progress;
    }

    public Component getControlComponent() {
        return this.pauseButton;
    }

    public Component getProgressBarComponent() {
        return this.progressBar;
    }

    public boolean isDownloading() {
        return this.isDownloading;
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public synchronized void reset(long l) {
        this.length = l;
        this.progress = 0L;
        this.progressBar.setValue(0);
        this.setContentLength(l);
        this.setDownLoading(false);
        this.setPaused(false);
        this.controller.postEvent(new CachingControlEvent(this.controller, this, this.progress));
    }

    public synchronized void setContentLength(long l) {
        this.length = l;
        if (l == Long.MAX_VALUE) {
            this.progressBar.setMaximum(0);
        } else {
            this.progressBar.setMaximum((int)l);
        }
    }

    public synchronized void setContentProgress(long l) {
        this.blockWhilePaused();
        this.progress = l;
        this.setDownLoading(l < this.length);
        this.progressBar.setValue((int)l);
        this.controller.postEvent(new CachingControlEvent(this.controller, this, l));
    }

    public void setDone() {
        this.setContentProgress(this.length);
    }

    public void setDownLoading(boolean bl) {
        this.isDownloading = bl;
        if (!bl) {
            this.setPaused(false);
        }
    }

    protected synchronized void setPaused(boolean bl) {
        this.isPaused = bl;
        this.notifyAll();
    }
}

