/*
 * Decompiled with CFR 0.152.
 */
package javax.media.format;

import java.awt.Dimension;
import javax.media.Format;
import javax.media.format.VideoFormat;
import net.sf.fmj.codegen.FormatTraceUtils;
import net.sf.fmj.utility.FormatUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPEGFormat
extends VideoFormat {
    public static final int DEC_422 = 0;
    public static final int DEC_420 = 1;
    public static final int DEC_444 = 2;
    public static final int DEC_402 = 3;
    public static final int DEC_411 = 4;
    int qFactor = -1;
    int decimation = -1;

    public JPEGFormat() {
        super("jpeg");
        this.dataType = Format.byteArray;
    }

    public JPEGFormat(Dimension dimension, int n, Class<?> clazz, float f, int n2, int n3) {
        super("jpeg", dimension, n, clazz, f);
        this.qFactor = n2;
        this.decimation = n3;
    }

    @Override
    public Object clone() {
        return new JPEGFormat(FormatUtils.clone(this.size), this.maxDataLength, this.dataType, this.frameRate, this.qFactor, this.decimation);
    }

    @Override
    protected void copy(Format format) {
        super.copy(format);
        JPEGFormat jPEGFormat = (JPEGFormat)format;
        this.qFactor = jPEGFormat.qFactor;
        this.decimation = jPEGFormat.decimation;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof JPEGFormat)) {
            return false;
        }
        JPEGFormat jPEGFormat = (JPEGFormat)object;
        return this.qFactor == jPEGFormat.qFactor && this.decimation == jPEGFormat.decimation;
    }

    public int getDecimation() {
        return this.decimation;
    }

    public int getQFactor() {
        return this.qFactor;
    }

    @Override
    public Format intersects(Format format) {
        Format format2 = super.intersects(format);
        if (format instanceof JPEGFormat) {
            JPEGFormat jPEGFormat = (JPEGFormat)format2;
            JPEGFormat jPEGFormat2 = (JPEGFormat)format;
            if (this.getClass().isAssignableFrom(format.getClass())) {
                if (FormatUtils.specified(this.qFactor)) {
                    jPEGFormat.qFactor = this.qFactor;
                }
                if (FormatUtils.specified(this.decimation)) {
                    jPEGFormat.decimation = this.decimation;
                }
            } else if (format.getClass().isAssignableFrom(this.getClass())) {
                if (!FormatUtils.specified(jPEGFormat.qFactor)) {
                    jPEGFormat.qFactor = jPEGFormat2.qFactor;
                }
                if (!FormatUtils.specified(jPEGFormat.decimation)) {
                    jPEGFormat.decimation = jPEGFormat2.decimation;
                }
            }
        }
        FormatTraceUtils.traceIntersects(this, format, format2);
        return format2;
    }

    @Override
    public boolean matches(Format format) {
        if (!super.matches(format)) {
            FormatTraceUtils.traceMatches(this, format, false);
            return false;
        }
        if (!(format instanceof JPEGFormat)) {
            FormatTraceUtils.traceMatches(this, format, true);
            return true;
        }
        JPEGFormat jPEGFormat = (JPEGFormat)format;
        boolean bl = FormatUtils.matches(jPEGFormat.qFactor, this.qFactor) && FormatUtils.matches(jPEGFormat.decimation, this.decimation);
        FormatTraceUtils.traceMatches(this, format, bl);
        return bl;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("jpeg video format:");
        if (FormatUtils.specified(this.size)) {
            stringBuffer.append(" size = " + this.size.width + "x" + this.size.height);
        }
        if (FormatUtils.specified(this.frameRate)) {
            stringBuffer.append(" FrameRate = " + this.frameRate);
        }
        if (FormatUtils.specified(this.maxDataLength)) {
            stringBuffer.append(" maxDataLength = " + this.maxDataLength);
        }
        if (FormatUtils.specified(this.dataType)) {
            stringBuffer.append(" dataType = " + this.dataType);
        }
        if (FormatUtils.specified(this.qFactor)) {
            stringBuffer.append(" q factor = " + this.qFactor);
        }
        if (FormatUtils.specified(this.decimation)) {
            stringBuffer.append(" decimation = " + this.decimation);
        }
        return stringBuffer.toString();
    }
}

