/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.portaudio;

import java.lang.reflect.UndeclaredThrowableException;
import org.jitsi.impl.neomedia.portaudio.PortAudioException;
import org.jitsi.impl.neomedia.portaudio.PortAudioStreamCallback;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.util.JNIUtils;
import org.jitsi.util.Logger;
import org.jitsi.util.OSUtils;
import org.jitsi.util.StringUtils;

public final class Pa {
    public static final int DEFAULT_MILLIS_PER_BUFFER = 20;
    public static final double DEFAULT_SAMPLE_RATE = 44100.0;
    private static Runnable devicesChangedCallback;
    public static final long FRAMES_PER_BUFFER_UNSPECIFIED = 0L;
    public static final double LATENCY_HIGH = -1.0;
    public static final double LATENCY_LOW = -2.0;
    public static final double LATENCY_UNSPECIFIED = 0.0;
    private static final Logger logger;
    public static final int MMSYSERR_NODRIVER = 6;
    public static final int paNoDevice = -1;
    public static final int paNoError = 0;
    public static final int paTimedOut = -9987;
    public static final int paUnanticipatedHostError = -9999;
    private static final String PROP_SUGGESTED_LATENCY = "net.java.sip.communicator.impl.neomedia.portaudio.suggestedLatency";
    public static final long SAMPLE_FORMAT_FLOAT32 = 1L;
    public static final long SAMPLE_FORMAT_INT16 = 8L;
    public static final long SAMPLE_FORMAT_INT24 = 4L;
    public static final long SAMPLE_FORMAT_INT32 = 2L;
    public static final long SAMPLE_FORMAT_INT8 = 16L;
    public static final long SAMPLE_FORMAT_UINT8 = 32L;
    public static final long STREAM_FLAGS_CLIP_OFF = 1L;
    public static final long STREAM_FLAGS_DITHER_OFF = 2L;
    public static final long STREAM_FLAGS_NEVER_DROP_INPUT = 4L;
    public static final long STREAM_FLAGS_NO_FLAG = 0L;
    public static final long STREAM_FLAGS_PLATFORM_SPECIFIC_FLAGS = -65536L;
    public static final long STREAM_FLAGS_PRIME_OUTPUT_BUFFERS_USING_STREAM_CALLBACK = 8L;

    public static native void AbortStream(long var0) throws PortAudioException;

    public static native void CloseStream(long var0) throws PortAudioException;

    public static native double DeviceInfo_getDefaultHighInputLatency(long var0);

    public static native double DeviceInfo_getDefaultHighOutputLatency(long var0);

    public static native double DeviceInfo_getDefaultLowInputLatency(long var0);

    public static native double DeviceInfo_getDefaultLowOutputLatency(long var0);

    public static native double DeviceInfo_getDefaultSampleRate(long var0);

    public static String DeviceInfo_getDeviceUID(long deviceInfo) {
        return StringUtils.newString(Pa.DeviceInfo_getDeviceUIDBytes(deviceInfo));
    }

    public static native byte[] DeviceInfo_getDeviceUIDBytes(long var0);

    public static native int DeviceInfo_getHostApi(long var0);

    public static native int DeviceInfo_getMaxInputChannels(long var0);

    public static native int DeviceInfo_getMaxOutputChannels(long var0);

    public static String DeviceInfo_getName(long deviceInfo) {
        return StringUtils.newString(Pa.DeviceInfo_getNameBytes(deviceInfo));
    }

    private static native byte[] DeviceInfo_getNameBytes(long var0);

    public static String DeviceInfo_getTransportType(long deviceInfo) {
        return StringUtils.newString(Pa.DeviceInfo_getTransportTypeBytes(deviceInfo));
    }

    public static native byte[] DeviceInfo_getTransportTypeBytes(long var0);

    public static void devicesChangedCallback() {
        Runnable devicesChangedCallback = Pa.devicesChangedCallback;
        if (devicesChangedCallback != null) {
            devicesChangedCallback.run();
        }
    }

    private static native void free(long var0);

    public static native int GetDefaultInputDevice();

    public static native int GetDefaultOutputDevice();

    public static native int GetDeviceCount() throws PortAudioException;

    public static int getDeviceIndex(String deviceID, int minInputChannels, int minOutputChannels) {
        if (deviceID != null) {
            int deviceCount = 0;
            try {
                deviceCount = Pa.GetDeviceCount();
            }
            catch (PortAudioException portAudioException) {
                // empty catch block
            }
            for (int deviceIndex = 0; deviceIndex < deviceCount; ++deviceIndex) {
                long deviceInfo = Pa.GetDeviceInfo(deviceIndex);
                String deviceUID = Pa.DeviceInfo_getDeviceUID(deviceInfo);
                if (!deviceID.equals(deviceUID == null || deviceUID.length() == 0 ? Pa.DeviceInfo_getName(deviceInfo) : deviceUID) || minInputChannels > 0 && Pa.DeviceInfo_getMaxInputChannels(deviceInfo) < minInputChannels || minOutputChannels > 0 && Pa.DeviceInfo_getMaxOutputChannels(deviceInfo) < minOutputChannels) continue;
                return deviceIndex;
            }
        }
        return -1;
    }

    public static native long GetDeviceInfo(int var0);

    public static native long GetHostApiInfo(int var0);

    public static long getPaSampleFormat(int sampleSizeInBits) {
        switch (sampleSizeInBits) {
            case 8: {
                return 16L;
            }
            case 24: {
                return 4L;
            }
            case 32: {
                return 2L;
            }
        }
        return 8L;
    }

    public static native int GetSampleSize(long var0);

    public static native long GetStreamReadAvailable(long var0);

    public static native long GetStreamWriteAvailable(long var0);

    public static double getSuggestedLatency() {
        String suggestedLatencyString;
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        if (cfg != null && (suggestedLatencyString = cfg.getString(PROP_SUGGESTED_LATENCY)) != null) {
            try {
                double suggestedLatency = Double.parseDouble(suggestedLatencyString);
                if (suggestedLatency != 0.0) {
                    return suggestedLatency;
                }
            }
            catch (NumberFormatException nfe) {
                logger.error("Failed to parse configuration property net.java.sip.communicator.impl.neomedia.portaudio.suggestedLatency value as a double", nfe);
            }
        }
        if (OSUtils.IS_MAC || OSUtils.IS_LINUX) {
            return -1.0;
        }
        if (OSUtils.IS_WINDOWS) {
            return 0.1;
        }
        return 0.0;
    }

    public static native int HostApiInfo_getDefaultInputDevice(long var0);

    public static native int HostApiInfo_getDefaultOutputDevice(long var0);

    public static native int HostApiInfo_getDeviceCount(long var0);

    public static native int HostApiInfo_getType(long var0);

    private static native void Initialize() throws PortAudioException;

    public static native boolean IsFormatSupported(long var0, long var2, double var4);

    public static native long OpenStream(long var0, long var2, double var4, long var6, long var8, PortAudioStreamCallback var10) throws PortAudioException;

    public static native void ReadStream(long var0, byte[] var2, long var3) throws PortAudioException;

    public static native void setDenoise(long var0, boolean var2);

    public static void setDevicesChangedCallback(Runnable devicesChangedCallback) {
        Pa.devicesChangedCallback = devicesChangedCallback;
    }

    public static native void setEchoFilterLengthInMillis(long var0, long var2);

    public static native void StartStream(long var0) throws PortAudioException;

    public static native void StopStream(long var0) throws PortAudioException;

    public static void StreamParameters_free(long streamParameters) {
        Pa.free(streamParameters);
    }

    public static native long StreamParameters_new(int var0, int var1, long var2, double var4);

    public static native void UpdateAvailableDeviceList();

    public static native void WriteStream(long var0, byte[] var2, int var3, long var4, int var6) throws PortAudioException;

    public static void WriteStream(long stream, byte[] buffer, long frames) throws PortAudioException {
        Pa.WriteStream(stream, buffer, 0, frames, 1);
    }

    private Pa() {
    }

    static {
        logger = Logger.getLogger(Pa.class);
        JNIUtils.loadLibrary("jnportaudio", Pa.class.getClassLoader());
        try {
            Pa.Initialize();
        }
        catch (PortAudioException paex) {
            logger.error("Failed to initialize the PortAudio library.", paex);
            throw new UndeclaredThrowableException(paex);
        }
    }

    public static enum HostApiTypeId {
        paAL(9),
        paALSA(8),
        paASIO(3),
        paAudioScienceHPI(14),
        paBeOS(10),
        paCoreAudio(5),
        paDirectSound(1),
        paInDevelopment(0),
        paJACK(12),
        paMME(2),
        paOSS(7),
        paSoundManager(4),
        paWASAPI(13),
        paWDMKS(11);

        private final int value;

        public static HostApiTypeId valueOf(int value) {
            for (HostApiTypeId hati : HostApiTypeId.values()) {
                if (hati.value != value) continue;
                return hati;
            }
            return null;
        }

        private HostApiTypeId(int value) {
            this.value = value;
        }
    }
}

