/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol.greyfading;

import java.awt.Dimension;
import java.io.IOException;
import java.util.Arrays;
import javax.media.Buffer;
import javax.media.control.FormatControl;
import javax.media.format.VideoFormat;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractVideoPullBufferStream;
import org.jitsi.impl.neomedia.jmfext.media.protocol.greyfading.DataSource;

public class VideoGreyFadingStream
extends AbstractVideoPullBufferStream<DataSource> {
    private int color = 0;
    private boolean increment = true;
    private long timeLastRead = 0L;

    public VideoGreyFadingStream(DataSource dataSource, FormatControl formatControl) {
        super(dataSource, formatControl);
    }

    @Override
    protected void doRead(Buffer buffer) throws IOException {
        long millis = 0L;
        VideoFormat format = (VideoFormat)buffer.getFormat();
        if (format == null && (format = (VideoFormat)this.getFormat()) != null) {
            buffer.setFormat(format);
        }
        Dimension size = format.getSize();
        int frameSizeInBytes = (int)(size.getHeight() * size.getWidth() * 4.0);
        byte[] data = AbstractCodec2.validateByteArraySize(buffer, frameSizeInBytes, false);
        Arrays.fill(data, 0, frameSizeInBytes, (byte)this.color);
        this.color = this.increment ? (this.color += 3) : (this.color -= 3);
        if (this.color >= 255) {
            this.increment = false;
            this.color = 255;
        } else if (this.color <= 0) {
            this.increment = true;
            this.color = 0;
        }
        buffer.setData(data);
        buffer.setOffset(0);
        buffer.setLength(frameSizeInBytes);
        buffer.setTimeStamp(System.nanoTime());
        millis = System.currentTimeMillis() - this.timeLastRead;
        millis = (long)(1000.0 / (double)format.getFrameRate()) - millis;
        if (millis > 0L) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.timeLastRead = System.currentTimeMillis();
    }
}

