/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.video.h263p;

import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;
import net.sf.fmj.media.AbstractCodec;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.codec.FFmpeg;
import org.jitsi.impl.neomedia.codec.video.AVFrame;
import org.jitsi.impl.neomedia.codec.video.AVFrameFormat;

public class JNIDecoder
extends AbstractCodec {
    private static final VideoFormat[] DEFAULT_OUTPUT_FORMATS = new VideoFormat[]{new AVFrameFormat(0)};
    private static final String PLUGIN_NAME = "H.263+ Decoder";
    private long avcontext = 0L;
    private long avframe = 0L;
    private final boolean[] got_picture = new boolean[1];
    private int height = 0;
    private final VideoFormat[] outputFormats;
    private int width = 0;

    public JNIDecoder() {
        this.inputFormats = new VideoFormat[]{new VideoFormat("h263-1998")};
        this.outputFormats = DEFAULT_OUTPUT_FORMATS;
    }

    public boolean checkFormat(Format format) {
        return format.getEncoding().equals("h263-1998/rtp");
    }

    @Override
    public synchronized void close() {
        if (this.opened) {
            this.opened = false;
            super.close();
            FFmpeg.avcodec_close(this.avcontext);
            FFmpeg.av_free(this.avcontext);
            this.avcontext = 0L;
            FFmpeg.avcodec_free_frame(this.avframe);
            this.avframe = 0L;
        }
    }

    private float ensureFrameRate(float frameRate) {
        return frameRate;
    }

    protected Format[] getMatchingOutputFormats(Format inputFormat) {
        VideoFormat inputVideoFormat = (VideoFormat)inputFormat;
        return new Format[]{new AVFrameFormat(inputVideoFormat.getSize(), this.ensureFrameRate(inputVideoFormat.getFrameRate()), 0)};
    }

    @Override
    public String getName() {
        return PLUGIN_NAME;
    }

    @Override
    public Format[] getSupportedOutputFormats(Format inputFormat) {
        if (inputFormat == null) {
            return this.outputFormats;
        }
        if (!(inputFormat instanceof VideoFormat) || AbstractCodec2.matches(inputFormat, this.inputFormats) == null) {
            return new Format[0];
        }
        return this.getMatchingOutputFormats(inputFormat);
    }

    @Override
    public synchronized void open() throws ResourceUnavailableException {
        if (this.opened) {
            return;
        }
        long avcodec = FFmpeg.avcodec_find_decoder(5);
        this.avcontext = FFmpeg.avcodec_alloc_context3(avcodec);
        FFmpeg.avcodeccontext_set_workaround_bugs(this.avcontext, 1);
        if (FFmpeg.avcodec_open2(this.avcontext, avcodec, new String[0]) < 0) {
            throw new RuntimeException("Could not open codec CODEC_ID_H263");
        }
        this.avframe = FFmpeg.avcodec_alloc_frame();
        this.opened = true;
        super.open();
    }

    @Override
    public synchronized int process(Buffer in, Buffer out) {
        long pts;
        if (!this.checkInputBuffer(in)) {
            return 1;
        }
        if (this.isEOM(in) || !this.opened) {
            this.propagateEOM(out);
            return 0;
        }
        if (in.isDiscard()) {
            out.setDiscard(true);
            return 0;
        }
        this.got_picture[0] = false;
        FFmpeg.avcodec_decode_video(this.avcontext, this.avframe, this.got_picture, (byte[])in.getData(), in.getLength());
        if (!this.got_picture[0]) {
            out.setDiscard(true);
            return 0;
        }
        int width = FFmpeg.avcodeccontext_get_width(this.avcontext);
        int height = FFmpeg.avcodeccontext_get_height(this.avcontext);
        if (width > 0 && height > 0 && (this.width != width || this.height != height)) {
            this.width = width;
            this.height = height;
            Dimension outSize = new Dimension(this.width, this.height);
            VideoFormat inFormat = (VideoFormat)in.getFormat();
            float outFrameRate = this.ensureFrameRate(inFormat.getFrameRate());
            this.outputFormat = new AVFrameFormat(outSize, outFrameRate, 0);
        }
        out.setFormat(this.outputFormat);
        Object outData = out.getData();
        if (!(outData instanceof AVFrame) || ((AVFrame)outData).getPtr() != this.avframe) {
            out.setData(new AVFrame(this.avframe));
        }
        if ((pts = Long.MIN_VALUE) == Long.MIN_VALUE) {
            out.setTimeStamp(-1L);
        } else {
            out.setTimeStamp(pts);
            int outFlags = out.getFlags();
            outFlags |= 0x100;
            out.setFlags(outFlags &= 0xFFFFEF7F);
        }
        return 0;
    }

    @Override
    public Format setInputFormat(Format format) {
        Format setFormat = super.setInputFormat(format);
        if (setFormat != null) {
            this.reset();
        }
        return setFormat;
    }
}

