/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mortbay.util.LazyList;

public class MultiMap
extends HashMap
implements Cloneable {
    public MultiMap() {
    }

    public MultiMap(int size) {
        super(size);
    }

    public MultiMap(Map map) {
        super(map.size() * 3 / 2);
        this.putAll(map);
    }

    public List getValues(Object name) {
        return LazyList.getList(super.get(name), true);
    }

    public Object getValue(Object name, int i) {
        Object l = super.get(name);
        if (i == 0 && LazyList.size(l) == 0) {
            return null;
        }
        return LazyList.get(l, i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(Object name) {
        StringBuffer values;
        Object l = super.get(name);
        switch (LazyList.size(l)) {
            case 0: {
                return null;
            }
            case 1: {
                Object o = LazyList.get(l, 0);
                return o == null ? null : o.toString();
            }
        }
        StringBuffer stringBuffer = values = new StringBuffer(128);
        synchronized (stringBuffer) {
            int i = 0;
            while (i < LazyList.size(l)) {
                Object e = LazyList.get(l, i);
                if (e != null) {
                    if (values.length() > 0) {
                        values.append(',');
                    }
                    values.append(e.toString());
                }
                ++i;
            }
            return values.toString();
        }
    }

    public Object get(Object name) {
        Object l = super.get(name);
        switch (LazyList.size(l)) {
            case 0: {
                return null;
            }
            case 1: {
                Object o = LazyList.get(l, 0);
                return o;
            }
        }
        return LazyList.getList(l, true);
    }

    public Object put(Object name, Object value) {
        return super.put(name, LazyList.add(null, value));
    }

    public Object putValues(Object name, List values) {
        return super.put(name, values);
    }

    public Object putValues(Object name, String[] values) {
        Object list = null;
        int i = 0;
        while (i < values.length) {
            list = LazyList.add(list, values[i]);
            ++i;
        }
        return this.put(name, list);
    }

    public void add(Object name, Object value) {
        Object ln;
        Object lo = super.get(name);
        if (lo != (ln = LazyList.add(lo, value))) {
            super.put(name, ln);
        }
    }

    public void addValues(Object name, List values) {
        Object ln;
        Object lo = super.get(name);
        if (lo != (ln = LazyList.addCollection(lo, values))) {
            super.put(name, ln);
        }
    }

    public void addValues(Object name, String[] values) {
        Object ln;
        Object lo = super.get(name);
        if (lo != (ln = LazyList.addCollection(lo, Arrays.asList(values)))) {
            super.put(name, ln);
        }
    }

    public boolean removeValue(Object name, Object value) {
        Object lo;
        Object ln = lo = super.get(name);
        int s = LazyList.size(lo);
        if (s > 0) {
            ln = LazyList.remove(lo, value);
        }
        return LazyList.size(ln) != s;
    }

    public void putAll(Map m) {
        Iterator i = m.entrySet().iterator();
        boolean multi = m instanceof MultiMap;
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (multi) {
                super.put(entry.getKey(), LazyList.clone(entry.getValue()));
                continue;
            }
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Map toStringArrayMap() {
        HashMap map = new HashMap(this.size() * 3 / 2);
        Iterator i = super.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Object l = entry.getValue();
            map.put(entry.getKey(), LazyList.toStringArray(l));
        }
        return map;
    }

    public Object clone() {
        return new MultiMap((Map)this);
    }
}

