/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.http.HttpContext;
import org.mortbay.jetty.servlet.Dispatcher;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.RequestListenerFilter;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletHttpContext;
import org.mortbay.jetty.servlet.ServletHttpRequest;
import org.mortbay.jetty.servlet.ServletHttpResponse;
import org.mortbay.jetty.servlet.SessionManager;
import org.mortbay.jetty.servlet.WebApplicationContext;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiException;
import org.mortbay.util.MultiMap;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;

public class WebApplicationHandler
extends ServletHandler {
    private static Log log = LogFactory.getLog((Class)(class$org$mortbay$jetty$servlet$WebApplicationHandler == null ? (class$org$mortbay$jetty$servlet$WebApplicationHandler = WebApplicationHandler.class$("org.mortbay.jetty.servlet.WebApplicationHandler")) : class$org$mortbay$jetty$servlet$WebApplicationHandler));
    private Map _filterMap = new HashMap();
    private List _pathFilters = new ArrayList();
    private List _filters = new ArrayList();
    private MultiMap _servletFilterMap = new MultiMap();
    private boolean _acceptRanges = true;
    private transient boolean _started = false;
    private transient WebApplicationContext _webApplicationContext;
    protected transient Object _requestListeners;
    protected transient Object _requestAttributeListeners;
    protected transient Object _sessionListeners;
    static /* synthetic */ Class class$org$mortbay$jetty$servlet$WebApplicationHandler;
    static /* synthetic */ Class class$javax$servlet$ServletException;

    public boolean isAcceptRanges() {
        return this._acceptRanges;
    }

    public void setAcceptRanges(boolean ar) {
        this._acceptRanges = ar;
    }

    public FilterHolder defineFilter(String name, String className) {
        FilterHolder holder = new FilterHolder(this, name, className);
        this._filterMap.put(holder.getName(), holder);
        this._filters.add(holder);
        return holder;
    }

    public FilterHolder getFilter(String name) {
        return (FilterHolder)this._filterMap.get(name);
    }

    public FilterHolder mapServletToFilter(String servletName, String filterName) {
        FilterHolder holder = (FilterHolder)this._filterMap.get(filterName);
        if (holder == null) {
            throw new IllegalArgumentException("Unknown filter :" + filterName);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Filter servlet " + servletName + " --> " + filterName));
        }
        this._servletFilterMap.add(servletName, holder);
        holder.addServlet(servletName);
        return holder;
    }

    public List getFilters() {
        return this._filters;
    }

    public FilterHolder mapPathToFilter(String pathSpec, String filterName) {
        FilterHolder holder = (FilterHolder)this._filterMap.get(filterName);
        if (holder == null) {
            throw new IllegalArgumentException("Unknown filter :" + filterName);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Filter path " + pathSpec + " --> " + filterName));
        }
        if (!holder.isMappedToPath()) {
            this._pathFilters.add(holder);
        }
        holder.addPathSpec(pathSpec);
        return holder;
    }

    public synchronized void addEventListener(EventListener listener) throws IllegalArgumentException {
        boolean known = false;
        if (listener instanceof HttpSessionActivationListener || listener instanceof HttpSessionAttributeListener || listener instanceof HttpSessionBindingListener || listener instanceof HttpSessionListener) {
            if (this._sessionManager != null) {
                this._sessionManager.addEventListener(listener);
            }
            this._sessionListeners = LazyList.add(this._sessionListeners, listener);
            known = true;
        }
        if (listener instanceof ServletRequestListener) {
            known = true;
            this._requestListeners = LazyList.add(this._requestListeners, listener);
        }
        if (listener instanceof ServletRequestAttributeListener) {
            known = true;
            this._requestAttributeListeners = LazyList.add(this._requestAttributeListeners, listener);
        }
        if (!known) {
            throw new IllegalArgumentException(listener.toString());
        }
    }

    public synchronized void removeEventListener(EventListener listener) {
        if (this._sessionManager != null) {
            this._sessionManager.removeEventListener(listener);
        }
        this._sessionListeners = LazyList.remove(this._sessionListeners, listener);
        this._requestListeners = LazyList.remove(this._requestListeners, listener);
        this._requestAttributeListeners = LazyList.remove(this._requestAttributeListeners, listener);
    }

    public void setSessionManager(SessionManager sm) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        SessionManager old = this.getSessionManager();
        if (this.getHttpContext() != null) {
            EventListener listener;
            Iterator i;
            if (old != null && old != sm && this._sessionListeners != null) {
                i = LazyList.iterator(this._sessionListeners);
                while (i.hasNext()) {
                    listener = (EventListener)i.next();
                    this._sessionManager.removeEventListener(listener);
                }
            }
            if (sm != null && old != sm && this._sessionListeners != null) {
                i = LazyList.iterator(this._sessionListeners);
                while (i.hasNext()) {
                    listener = (EventListener)i.next();
                    sm.addEventListener(listener);
                }
            }
        }
        super.setSessionManager(sm);
    }

    public boolean isStarted() {
        return this._started && super.isStarted();
    }

    public synchronized void start() throws Exception {
        super.start();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Path Filters: " + this._pathFilters));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Servlet Filters: " + this._servletFilterMap));
        }
        this._started = true;
        if (this.getHttpContext() instanceof WebApplicationContext) {
            this._webApplicationContext = (WebApplicationContext)this.getHttpContext();
        }
        if (LazyList.size(this._requestAttributeListeners) > 0 || LazyList.size(this._requestListeners) > 0) {
            FilterHolder holder = new FilterHolder(this, "RequestAttributeListener", "org.mortbay.jetty.servlet.RequestListenerFilter");
            holder.addAppliesTo(15);
            holder.addPathSpec("/");
            holder.start();
            RequestListenerFilter filter = (RequestListenerFilter)holder.getFilter();
            filter.setRequestAttributeListeners(this._requestAttributeListeners);
            filter.setRequestListeners(this._requestListeners);
            this._pathFilters.add(0, holder);
        }
    }

    public void initializeServlets() throws Exception {
        MultiException mex = new MultiException();
        Iterator iter = this._filters.iterator();
        while (iter.hasNext()) {
            FilterHolder holder = (FilterHolder)iter.next();
            try {
                holder.start();
            }
            catch (Exception e) {
                mex.add(e);
            }
        }
        try {
            super.initializeServlets();
        }
        catch (Exception e) {
            mex.add(e);
        }
        mex.ifExceptionThrow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() throws InterruptedException {
        try {
            super.stop();
            int i = this._filters.size();
            while (i-- > 0) {
                FilterHolder holder = (FilterHolder)this._filters.get(i);
                holder.stop();
            }
        }
        finally {
            this._started = false;
            this._webApplicationContext = null;
            this._sessionListeners = null;
            this._requestListeners = null;
            this._requestAttributeListeners = null;
        }
    }

    protected String getErrorPage(int status, ServletHttpRequest request) {
        Class<Object> exClass;
        String error_page = null;
        if ((class$javax$servlet$ServletException == null ? (class$javax$servlet$ServletException = WebApplicationHandler.class$("javax.servlet.ServletException")) : class$javax$servlet$ServletException).equals(exClass = (Class)request.getAttribute("javax.servlet.error.exception_type")) && (error_page = this._webApplicationContext.getErrorPage(exClass.getName())) == null) {
            Throwable th = (Throwable)request.getAttribute("javax.servlet.error.exception");
            while (th instanceof ServletException) {
                th = ((ServletException)th).getRootCause();
            }
            if (th != null) {
                exClass = th.getClass();
            }
        }
        if (error_page == null && exClass != null) {
            while (error_page == null && exClass != null && this._webApplicationContext != null) {
                error_page = this._webApplicationContext.getErrorPage(exClass.getName());
                exClass = exClass.getSuperclass();
            }
            if (error_page == null) {
                // empty if block
            }
        }
        if (error_page == null && this._webApplicationContext != null) {
            error_page = this._webApplicationContext.getErrorPage(TypeUtil.toString(status));
        }
        return error_page;
    }

    protected void dispatch(String pathInContext, HttpServletRequest request, HttpServletResponse response, ServletHolder servletHolder) throws ServletException, UnavailableException, IOException {
        Object o;
        FilterHolder holder;
        int requestType = 0;
        if (request instanceof Dispatcher.DispatcherRequest) {
            HttpContext context = this.getHttpContext();
            if (context != null && context instanceof ServletHttpContext && pathInContext != null && pathInContext.endsWith("j_security_check")) {
                ServletHttpRequest servletHttpRequest = (ServletHttpRequest)context.getHttpConnection().getRequest().getWrapper();
                ServletHttpResponse servletHttpResponse = servletHttpRequest.getServletHttpResponse();
                ServletHttpContext servletContext = (ServletHttpContext)context;
                if (!servletContext.jSecurityCheck(pathInContext, servletHttpRequest.getHttpRequest(), servletHttpResponse.getHttpResponse())) {
                    return;
                }
            }
            requestType = ((Dispatcher.DispatcherRequest)request).getFilterType();
        } else {
            ServletHttpRequest servletHttpRequest = (ServletHttpRequest)request;
            ServletHttpResponse servletHttpResponse = (ServletHttpResponse)response;
            requestType = 1;
            if (StringUtil.startsWithIgnoreCase(pathInContext, "/web-inf") || StringUtil.startsWithIgnoreCase(pathInContext, "/meta-inf")) {
                response.sendError(404);
                return;
            }
            if (!this.getHttpContext().checkSecurityConstraints(pathInContext, servletHttpRequest.getHttpRequest(), servletHttpResponse.getHttpResponse())) {
                return;
            }
        }
        Object filters = null;
        if (pathInContext != null && this._pathFilters.size() > 0) {
            int i = 0;
            while (i < this._pathFilters.size()) {
                holder = (FilterHolder)this._pathFilters.get(i);
                if (holder.appliesTo(pathInContext, requestType)) {
                    filters = LazyList.add(filters, holder);
                }
                ++i;
            }
        }
        if (servletHolder != null && this._servletFilterMap.size() > 0 && (o = this._servletFilterMap.get(servletHolder.getName())) != null) {
            if (o instanceof List) {
                List list = (List)o;
                int i = 0;
                while (i < list.size()) {
                    FilterHolder holder2 = (FilterHolder)list.get(i);
                    if (holder2.appliesTo(requestType)) {
                        filters = LazyList.add(filters, holder2);
                    }
                    ++i;
                }
            } else {
                holder = (FilterHolder)o;
                if (holder.appliesTo(requestType)) {
                    filters = LazyList.add(filters, holder);
                }
            }
        }
        if (LazyList.size(filters) > 0) {
            Chain chain = new Chain(pathInContext, filters, servletHolder);
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else if (servletHolder != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("call servlet " + servletHolder));
            }
            servletHolder.handle((ServletRequest)request, (ServletResponse)response);
        } else {
            this.notFound(request, response);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Chain
    implements FilterChain {
        String _pathInContext;
        int _filter = 0;
        Object _filters;
        ServletHolder _servletHolder;

        Chain(String pathInContext, Object filters, ServletHolder servletHolder) {
            this._pathInContext = pathInContext;
            this._filters = filters;
            this._servletHolder = servletHolder;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("doFilter " + this._filter));
            }
            if (this._filter < LazyList.size(this._filters)) {
                FilterHolder holder = (FilterHolder)LazyList.get(this._filters, this._filter++);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("call filter " + holder));
                }
                Filter filter = holder.getFilter();
                filter.doFilter(request, response, (FilterChain)this);
                return;
            }
            if (this._servletHolder != null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("call servlet " + this._servletHolder));
                }
                this._servletHolder.handle(request, response);
            } else {
                WebApplicationHandler.this.notFound((HttpServletRequest)request, (HttpServletResponse)response);
            }
        }
    }
}

