/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.stream;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.AttributeIterator;
import weblogic.xml.stream.ChangePrefixMapping;
import weblogic.xml.stream.CharacterData;
import weblogic.xml.stream.Comment;
import weblogic.xml.stream.EndDocument;
import weblogic.xml.stream.EndElement;
import weblogic.xml.stream.EndPrefixMapping;
import weblogic.xml.stream.EntityReference;
import weblogic.xml.stream.ProcessingInstruction;
import weblogic.xml.stream.Space;
import weblogic.xml.stream.StartDocument;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.StartPrefixMapping;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.stream.events.StartDocumentEvent;

public class XMLWriter {
    protected Writer writer;
    protected int elementLevel = 0;
    protected Map prefixMap = new HashMap();
    protected boolean writeElementNameSpaces = false;
    protected boolean writeAll = false;
    protected boolean showNamespaceBindings = false;
    protected boolean normalizeWhiteSpace = false;
    protected boolean writeHeader = true;

    public XMLWriter() {
    }

    public XMLWriter(Writer writer) {
        this.writer = writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void setWriteElementNameSpaces(boolean bl) {
        this.writeElementNameSpaces = bl;
    }

    public void setWriteAll(boolean bl) {
        this.writeAll = bl;
    }

    public void setNormalizeWhiteSpace(boolean bl) {
        this.normalizeWhiteSpace = bl;
    }

    public void setWriteHeader(boolean bl) {
        this.writeHeader = bl;
    }

    public void setShowNamespaceBindings(boolean bl) {
        this.showNamespaceBindings = bl;
    }

    protected void write(String string) throws XMLStreamException {
        try {
            this.writer.write(string);
        }
        catch (IOException iOException) {
            throw new XMLStreamException((Throwable)iOException);
        }
    }

    protected void write(char c) throws XMLStreamException {
        try {
            this.writer.write(c);
        }
        catch (IOException iOException) {
            throw new XMLStreamException((Throwable)iOException);
        }
    }

    private void write(char[] cArray) throws XMLStreamException {
        try {
            this.writer.write(cArray);
        }
        catch (IOException iOException) {
            throw new XMLStreamException((Throwable)iOException);
        }
    }

    public void flush() throws XMLStreamException {
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new XMLStreamException((Throwable)iOException);
        }
    }

    public void write(StartElement startElement) throws XMLStreamException {
        ++this.elementLevel;
        this.write('<');
        this.write(startElement.getName());
        if (this.writeElementNameSpaces) {
            this.write(startElement.getAttributesAndNamespaces());
        } else {
            this.write(startElement.getAttributes());
        }
        this.write('>');
    }

    public void writeEmpty(StartElement startElement) throws XMLStreamException {
        this.write('<');
        this.write(startElement.getName());
        if (this.writeElementNameSpaces) {
            this.write(startElement.getAttributesAndNamespaces());
        } else {
            this.write(startElement.getAttributes());
        }
        this.write("/>");
    }

    public void write(EndElement endElement) throws XMLStreamException {
        --this.elementLevel;
        this.write("</");
        this.write(endElement.getName());
        this.write(">");
    }

    public void write(ProcessingInstruction processingInstruction) throws XMLStreamException {
        this.write("<?");
        if (processingInstruction.getTarget() != null) {
            this.write(processingInstruction.getTarget());
        }
        if (processingInstruction.getData() != null) {
            this.write(" " + processingInstruction.getData());
        }
        this.write("?>");
    }

    public void write(CharacterData characterData) throws XMLStreamException {
        if (characterData.hasContent()) {
            this.writeCharacters(characterData.getContent(), false);
        }
    }

    public void write(StartDocument startDocument) throws XMLStreamException {
        if (!this.writeHeader) {
            return;
        }
        if (startDocument instanceof StartDocumentEvent) {
            StartDocumentEvent startDocumentEvent = (StartDocumentEvent)startDocument;
            this.write("<?xml version=\"" + startDocumentEvent.getVersion() + "\"");
            if (startDocumentEvent.getCharacterEncodingScheme() != null && startDocumentEvent.encodingSet()) {
                this.write(" encoding=\"" + startDocumentEvent.getCharacterEncodingScheme() + "\"");
            }
            if (startDocumentEvent.standaloneSet()) {
                if (startDocumentEvent.isStandalone()) {
                    this.write(" standalone=\"yes\"");
                } else {
                    this.write(" standalone=\"no\"");
                }
            }
            this.write("?>");
        } else {
            this.write("<?xml version=\"" + startDocument.getVersion() + "\"");
            if (startDocument.getCharacterEncodingScheme() != null) {
                this.write(" encoding=\"" + startDocument.getCharacterEncodingScheme() + "\"");
            }
            if (startDocument.isStandalone()) {
                this.write(" standalone=\"yes\"");
            } else {
                this.write(" standalone=\"no\"");
            }
            this.write("?>");
        }
    }

    public void write(EndDocument endDocument) throws XMLStreamException {
        if (!this.writeAll) {
            return;
        }
        this.write("<?END_DOCUMENT?>");
    }

    public void write(Comment comment) throws XMLStreamException {
        this.write("<!--");
        if (comment.hasContent()) {
            this.writeCharacters(comment.getContent(), false);
        }
        this.write("-->");
    }

    protected void writeNamespace(String string, String string2) throws XMLStreamException {
        this.write("['" + string + "']=['" + string2 + "']");
    }

    public boolean inScope(String string) {
        return this.prefixMap.get(string) != null;
    }

    public void write(StartPrefixMapping startPrefixMapping) throws XMLStreamException {
        this.prefixMap.put(startPrefixMapping.getPrefix(), startPrefixMapping.getNamespaceUri());
        if (!this.writeAll) {
            return;
        }
        this.write("<?START_PREFIX_MAPPING ");
        this.writeNamespace(startPrefixMapping.getPrefix(), startPrefixMapping.getNamespaceUri());
        this.write("?>");
    }

    public void write(ChangePrefixMapping changePrefixMapping) throws XMLStreamException {
        this.prefixMap.put(changePrefixMapping.getPrefix(), changePrefixMapping.getNewNamespaceUri());
        if (!this.writeAll) {
            return;
        }
        this.write("<?CHANGE_PREFIX_MAPPING ");
        this.writeNamespace(changePrefixMapping.getPrefix(), changePrefixMapping.getOldNamespaceUri());
        this.write(" ");
        this.writeNamespace(changePrefixMapping.getPrefix(), changePrefixMapping.getNewNamespaceUri());
        this.write(">?");
    }

    public void write(EndPrefixMapping endPrefixMapping) throws XMLStreamException {
        this.prefixMap.remove(endPrefixMapping.getPrefix());
        if (!this.writeAll) {
            return;
        }
        this.write("<?END_PREFIX_MAPPING " + endPrefixMapping.getPrefix() + "?>");
    }

    public void write(XMLName xMLName) throws XMLStreamException {
        if (xMLName == null) {
            return;
        }
        if (this.showNamespaceBindings && xMLName.getNamespaceUri() != null) {
            this.write("['" + xMLName.getNamespaceUri() + "']:" + xMLName.getQualifiedName());
        } else {
            this.write(xMLName.getQualifiedName());
        }
    }

    public void write(AttributeIterator attributeIterator) throws XMLStreamException {
        while (attributeIterator.hasNext()) {
            this.write(" ");
            this.write(attributeIterator.next());
        }
    }

    public void write(Attribute attribute) throws XMLStreamException {
        this.write(attribute.getName());
        this.write("=\"");
        this.writeCharacters(attribute.getValue(), true);
        this.write('\"');
    }

    public void write(EntityReference entityReference) throws XMLStreamException {
        this.write("&" + entityReference.getName() + ";");
    }

    public void write(Space space) throws XMLStreamException {
        if (this.normalizeWhiteSpace) {
            this.write(' ');
        } else if (space.hasContent()) {
            this.write(space.getContent());
        }
    }

    protected void writeCharacters(String string, boolean bl) throws XMLStreamException {
        if (string == null || string.length() == 0) {
            return;
        }
        boolean bl2 = true;
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            switch (string.charAt(n)) {
                case '\"': 
                case '&': 
                case '<': 
                case '>': {
                    bl2 = false;
                }
            }
            ++n;
        }
        if (bl2) {
            this.write(string);
        } else {
            this.slowWriteCharacters(string, bl);
        }
    }

    private void slowWriteCharacters(String string, boolean bl) throws XMLStreamException {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            switch (c) {
                case '&': {
                    this.write("&amp;");
                    break;
                }
                case '<': {
                    this.write("&lt;");
                    break;
                }
                case '>': {
                    this.write("&gt;");
                    break;
                }
                case '\"': {
                    if (bl) {
                        this.write("&quot;");
                        break;
                    }
                    this.write('\"');
                    break;
                }
                default: {
                    this.write(c);
                }
            }
            ++n;
        }
    }

    public boolean write(XMLEvent xMLEvent) throws XMLStreamException {
        switch (xMLEvent.getType()) {
            case 2: {
                this.write((StartElement)xMLEvent);
                return true;
            }
            case 4: {
                this.write((EndElement)xMLEvent);
                return true;
            }
            case 8: {
                this.write((ProcessingInstruction)xMLEvent);
                return true;
            }
            case 16: {
                this.write((CharacterData)xMLEvent);
                return true;
            }
            case 32: {
                this.write((Comment)xMLEvent);
                return true;
            }
            case 256: {
                this.write((StartDocument)xMLEvent);
                return true;
            }
            case 512: {
                this.write((EndDocument)xMLEvent);
                return true;
            }
            case 1024: {
                this.write((StartPrefixMapping)xMLEvent);
                return true;
            }
            case 2048: {
                this.write((EndPrefixMapping)xMLEvent);
                return true;
            }
            case 4096: {
                this.write((ChangePrefixMapping)xMLEvent);
                return true;
            }
            case 8192: {
                this.write((EntityReference)xMLEvent);
                return true;
            }
            case 64: {
                this.write((Space)xMLEvent);
                return true;
            }
            case 128: {
                throw new XMLStreamException("Attempt to write a null element.");
            }
        }
        throw new XMLStreamException("Attempt to write unknown element [" + xMLEvent.getType() + "]");
    }

    public static XMLWriter getDebugWriter(Writer writer) throws XMLStreamException {
        XMLWriter xMLWriter = new XMLWriter();
        xMLWriter.setWriter(writer);
        xMLWriter.setWriteElementNameSpaces(true);
        xMLWriter.setWriteAll(true);
        xMLWriter.setShowNamespaceBindings(true);
        xMLWriter.setNormalizeWhiteSpace(true);
        return xMLWriter;
    }

    public static XMLWriter getSymmetricWriter(Writer writer) throws XMLStreamException {
        XMLWriter xMLWriter = new XMLWriter();
        xMLWriter.setWriter(writer);
        xMLWriter.setWriteHeader(true);
        xMLWriter.setWriteElementNameSpaces(true);
        xMLWriter.setWriteAll(false);
        xMLWriter.setShowNamespaceBindings(false);
        xMLWriter.setNormalizeWhiteSpace(false);
        return xMLWriter;
    }
}

