/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.stream;

import java.util.ArrayList;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.InputSource;
import weblogic.apache.xerces.parsers.DOMParser;
import weblogic.utils.collections.CircularQueue;
import weblogic.xml.babel.adapters.DOMAdapter;
import weblogic.xml.babel.baseparser.SAXElementFactory;
import weblogic.xml.babel.stream.XMLInputStreamBase;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.stream.events.NullEvent;

public class DOMInputStream
extends XMLInputStreamBase {
    protected Node node;
    protected DOMAdapter adapter;

    public DOMInputStream() {
        this.open = false;
        this.children = new ArrayList();
        this.adapter = new DOMAdapter(this);
    }

    public void open(InputSource inputSource) throws XMLStreamException {
        throw new XMLStreamException("Not Implemented");
    }

    public void open(Node node) throws XMLStreamException {
        this.open = true;
        this.elementQ = new CircularQueue(8);
        this.adapter.adapt(node);
    }

    public boolean parseSome() throws XMLStreamException {
        return false;
    }

    public boolean hasNext() throws XMLStreamException {
        return this.open && !this.elementQ.isEmpty();
    }

    public XMLEvent peek() throws XMLStreamException {
        if (this.hasNext()) {
            return (XMLEvent)this.elementQ.peek();
        }
        return new NullEvent();
    }

    public static void printNode(Node node) {
        switch (node.getNodeType()) {
            case 11: {
                NodeList nodeList = node.getChildNodes();
                int n = nodeList.getLength();
                int n2 = 0;
                while (n2 < n) {
                    DOMInputStream.printNode(nodeList.item(n2));
                    ++n2;
                }
                break;
            }
            case 9: {
                System.out.println("<xml version=\"1.0\">");
                Document document = (Document)node;
                DOMInputStream.printNode(document.getDocumentElement());
                break;
            }
            case 1: {
                Object object;
                String string = node.getNodeName();
                System.out.print("<" + string);
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n = 0;
                while (n < namedNodeMap.getLength()) {
                    object = namedNodeMap.item(n);
                    System.out.print(" " + object.getNodeName() + "=\"" + object.getNodeValue() + "\"");
                    ++n;
                }
                System.out.print(">");
                object = node.getChildNodes();
                if (object != null) {
                    int n3 = 0;
                    while (n3 < object.getLength()) {
                        DOMInputStream.printNode(object.item(n3));
                        ++n3;
                    }
                }
                System.out.print("</" + string + ">");
                break;
            }
            case 8: {
                System.out.println("<!--" + ((Comment)node).getData() + "-->");
                break;
            }
            case 3: 
            case 4: {
                System.out.print(node.getNodeValue());
                break;
            }
            case 7: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                System.out.print("<?" + processingInstruction.getTarget() + " " + processingInstruction.getData() + "?>");
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        XMLEvent xMLEvent;
        DOMInputStream dOMInputStream = new DOMInputStream();
        DOMParser dOMParser = new DOMParser();
        dOMParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        dOMParser.setFeature("http://xml.org/sax/features/validation", false);
        dOMParser.setFeature("http://xml.org/sax/features/namespaces", true);
        dOMParser.setFeature("http://apache.org/xml/features/validation/schema", true);
        dOMParser.parse(SAXElementFactory.createInputSource(stringArray[0]));
        Document document = dOMParser.getDocument();
        dOMInputStream.open(document);
        while (dOMInputStream.hasNext()) {
            xMLEvent = dOMInputStream.next();
            System.out.print("EVENT: " + xMLEvent.getTypeAsString() + " [");
            System.out.print(xMLEvent);
            System.out.println("]");
        }
        System.out.println("Echoed dom");
        xMLEvent = XMLInputStreamFactory.newInstance().newInputStream((Node)document);
        while (xMLEvent.hasNext()) {
            XMLEvent xMLEvent2 = xMLEvent.next();
            System.out.print("EVENT:[ " + xMLEvent2 + "]");
        }
    }
}

